@extends('layouts.app')

@section('title', 'Input Data Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-calendar-week mr-2"></i>
                        Input Data Yaumiyah - Pekan {{ $week }} Tahun {{ $year }}
                    </h3>
                </div>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle mr-2"></i>
                        {{ session('success') }}
                        @if($anggotaId)
                        <div class="mt-2">
                            <a href="{{ route('yaumiyah.records.detail', ['anggota_id' => $anggotaId, 'week' => $week, 'year' => $year]) }}" 
                               class="btn btn-sm btn-info">
                                <i class="fas fa-eye mr-1"></i>
                                Lihat Detail
                            </a>
                            <a href="{{ route('yaumiyah.records.list') }}" 
                               class="btn btn-sm btn-success">
                                <i class="fas fa-list mr-1"></i>
                                Lihat Daftar Semua Data
                            </a>
                        </div>
                        @endif
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <form method="GET" action="{{ route('yaumiyah.records') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="anggota_id">Pilih Anggota</label>
                                    <select name="anggota_id" id="anggota_id" class="form-control" required>
                                        <option value="">-- Pilih Anggota --</option>
                                        @foreach($anggota as $a)
                                        <option value="{{ $a->id }}" {{ $anggotaId == $a->id ? 'selected' : '' }}>
                                            {{ $a->nama_lengkap }} ({{ $a->nia }})
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="week">Pekan</label>
                                    <select name="week" id="week" class="form-control">
                                        @for($i = 1; $i <= 53; $i++)
                                        <option value="{{ $i }}" {{ $week == $i ? 'selected' : '' }}>
                                            Pekan {{ $i }}
                                        </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="year">Tahun</label>
                                    <select name="year" id="year" class="form-control">
                                        @for($i = 2020; $i <= 2030; $i++)
                                        <option value="{{ $i }}" {{ $year == $i ? 'selected' : '' }}>
                                            {{ $i }}
                                        </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="fas fa-search mr-1"></i>
                                        Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    @if($anggotaId)
                    <form method="POST" action="{{ route('yaumiyah.records.store') }}">
                        @csrf
                        <input type="hidden" name="anggota_id" value="{{ $anggotaId }}">
                        <input type="hidden" name="week_number" value="{{ $week }}">
                        <input type="hidden" name="year" value="{{ $year }}">

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">
                                    @php
                                        $selectedAnggota = $anggota->where('id', $anggotaId)->first();
                                    @endphp
                                    Data Yaumiyah - {{ $selectedAnggota->nama_lengkap ?? 'Anggota' }} 
                                    @if($selectedAnggota)
                                        ({{ $selectedAnggota->nia }})
                                    @endif
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%">No</th>
                                                <th style="width: 50%">Aktivitas</th>
                                                <th style="width: 15%">Target/Minggu</th>
                                                <th style="width: 15%">Pencapaian</th>
                                                <th style="width: 15%">Catatan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($activities as $index => $activity)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <strong>{{ $activity->name }}</strong>
                                                    @if($activity->description)
                                                    <br><small class="text-muted">{{ $activity->description }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    <span class="badge bg-info text-white">
                                                        {{ $activity->target_per_week }} {{ $activity->unit }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <input type="hidden" name="records[{{ $index }}][yaumiyah_activity_id]" value="{{ $activity->id }}">
                                                    <input type="number" 
                                                           name="records[{{ $index }}][value]" 
                                                           class="form-control form-control-sm" 
                                                           value="{{ $existingRecords->get($activity->id)->value ?? 0 }}"
                                                           min="0" 
                                                           step="1">
                                                </td>
                                                <td>
                                                    <input type="text" 
                                                           name="records[{{ $index }}][notes]" 
                                                           class="form-control form-control-sm" 
                                                           value="{{ $existingRecords->get($activity->id)->notes ?? '' }}"
                                                           placeholder="Catatan...">
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-save mr-2"></i>
                                            Simpan Data Yaumiyah
                                        </button>
                                        <a href="{{ route('yaumiyah.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-arrow-left mr-2"></i>
                                            Kembali
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    @else
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle mr-2"></i>
                        Silakan pilih anggota terlebih dahulu untuk melihat dan mengisi data yaumiyah.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-submit form when anggota is selected
    $('#anggota_id').change(function() {
        if ($(this).val()) {
            $(this).closest('form').submit();
        }
    });
});
</script>
@endpush
