@extends('layouts.app')

@section('title', 'Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-calendar-check mr-2"></i>
                        Yaumiyah - Aktivitas Harian
                    </h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <i class="fas fa-tasks"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Aktivitas</span>
                                    <span class="info-box-number">{{ $activities->count() }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-calendar-week"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pekan Ini</span>
                                    <span class="info-box-number">{{ now()->weekOfYear }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-calendar-alt"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Tahun</span>
                                    <span class="info-box-number">{{ now()->year }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Aktivitas Yaumiyah</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>No</th>
                                                    <th>Aktivitas</th>
                                                    <th>Target/Minggu</th>
                                                    <th>Unit</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($activities as $index => $activity)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $activity->name }}</td>
                                                    <td>{{ $activity->target_per_week }}</td>
                                                    <td>{{ $activity->unit }}</td>
                                                    <td>
                                                        <span class="text-dark">Aktif</span>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Input Data Yaumiyah</h5>
                                </div>
                                <div class="card-body">
                                    <p>Masukkan data aktivitas yaumiyah per pekan untuk setiap anggota.</p>
                                    <a href="{{ route('yaumiyah.records') }}" class="btn btn-primary">
                                        <i class="fas fa-plus mr-2"></i>
                                        Input Data Yaumiyah
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Daftar Data Yaumiyah</h5>
                                </div>
                                <div class="card-body">
                                    <p>Lihat semua data yaumiyah yang sudah diinput.</p>
                                    <a href="{{ route('yaumiyah.records.list') }}" class="btn btn-success">
                                        <i class="fas fa-list mr-2"></i>
                                        Lihat Daftar Data
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Laporan Yaumiyah</h5>
                                </div>
                                <div class="card-body">
                                    <p>Lihat laporan dan statistik aktivitas yaumiyah.</p>
                                    <a href="{{ route('yaumiyah.reports') }}" class="btn btn-info">
                                        <i class="fas fa-chart-bar mr-2"></i>
                                        Lihat Laporan
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    @can('manage-yaumiyah')
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Kelola Master Aktivitas</h5>
                                </div>
                                <div class="card-body">
                                    <p>Kelola daftar aktivitas yaumiyah yang tersedia.</p>
                                    <a href="{{ route('yaumiyah.activities.index') }}" class="btn btn-warning">
                                        <i class="fas fa-cog mr-2"></i>
                                        Kelola Aktivitas
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcan
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
