@extends('layouts.app')

@section('title', 'Master Aktivitas Yaumiyah')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-tasks mr-2"></i>
                        Master Aktivitas Yaumiyah
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('yaumiyah.activities.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus mr-2"></i>
                            Tambah Aktivitas
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert">
                            <span>&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%">No</th>
                                    <th style="width: 30%">Nama Aktivitas</th>
                                    <th style="width: 25%">Deskripsi</th>
                                    <th style="width: 10%">Target/Minggu</th>
                                    <th style="width: 10%">Unit</th>
                                    <th style="width: 10%">Urutan</th>
                                    <th style="width: 10%">Status</th>
                                    <th style="width: 10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($activities as $index => $activity)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <strong>{{ $activity->name }}</strong>
                                    </td>
                                    <td>
                                        @if($activity->description)
                                        {{ Str::limit($activity->description, 50) }}
                                        @else
                                        <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="text-dark">
                                            {{ $activity->target_per_week }}
                                        </span>
                                    </td>
                                    <td>{{ $activity->unit }}</td>
                                    <td>{{ $activity->sort_order }}</td>
                                    <td>
                                        @if($activity->is_active)
                                        <span class="text-dark">Aktif</span>
                                        @else
                                        <span class="text-dark">Tidak Aktif</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('yaumiyah.activities.show', $activity) }}" 
                                               class="btn btn-sm btn-info" 
                                               title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('yaumiyah.activities.edit', $activity) }}" 
                                               class="btn btn-sm btn-warning" 
                                               title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form method="POST" 
                                                  action="{{ route('yaumiyah.activities.destroy', $activity) }}" 
                                                  style="display: inline;"
                                                  onsubmit="return confirm('Apakah Anda yakin ingin menghapus aktivitas ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn btn-sm btn-danger" 
                                                        title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">Belum ada aktivitas yaumiyah.</p>
                                            <a href="{{ route('yaumiyah.activities.create') }}" class="btn btn-primary">
                                                <i class="fas fa-plus mr-2"></i>
                                                Tambah Aktivitas Pertama
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12">
                            <a href="{{ route('yaumiyah.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left mr-2"></i>
                                Kembali ke Yaumiyah
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
