@extends('layouts.app')

@section('title', 'Detail User')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-user me-2"></i>Detail User: {{ $user->name }}
                    </h4>
                    <div>
                        @if(auth()->user()->isAdmin() && $user->id !== auth()->id())
                            <a href="{{ route('user-management.edit', $user) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit me-1"></i>Edit
                            </a>
                        @endif
                        <a href="{{ route('user-management.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left me-1"></i>Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center">
                            <div class="avatar-lg bg-primary text-white rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 100px; height: 100px; font-size: 40px;">
                                {{ strtoupper(substr($user->name, 0, 1)) }}
                            </div>
                            <h5 class="mb-1">{{ $user->name }}</h5>
                            <p class="text-muted mb-0">{{ $user->email }}</p>
                        </div>
                        
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Role</label>
                                        <div>
                                            <span class="badge bg-{{ $user->getRoleBadgeColor() }} fs-6">
                                                {{ $user->getRoleDisplayName() }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Status</label>
                                        <div>
                                            @if($user->isActive())
                                                <span class="badge bg-success fs-6">Aktif</span>
                                            @else
                                                <span class="badge bg-danger fs-6">Tidak Aktif</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Tanggal Dibuat</label>
                                        <p class="mb-0">{{ $user->created_at->format('d F Y, H:i') }}</p>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Terakhir Diupdate</label>
                                        <p class="mb-0">{{ $user->updated_at->format('d F Y, H:i') }}</p>
                                    </div>
                                </div>
                                
                                @if($user->email_verified_at)
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Email Terverifikasi</label>
                                            <p class="mb-0 text-success">
                                                <i class="fas fa-check-circle me-1"></i>
                                                {{ $user->email_verified_at->format('d F Y, H:i') }}
                                            </p>
                                        </div>
                                    </div>
                                @else
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Email Terverifikasi</label>
                                            <p class="mb-0 text-warning">
                                                <i class="fas fa-exclamation-triangle me-1"></i>
                                                Belum Terverifikasi
                                            </p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-12">
                            <h6 class="fw-bold mb-3">Informasi Tambahan</h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">ID User</label>
                                        <p class="mb-0 font-monospace">{{ $user->id }}</p>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Akun Ini</label>
                                        @if($user->id === auth()->id())
                                            <p class="mb-0 text-primary">
                                                <i class="fas fa-user me-1"></i>
                                                Akun Anda
                                            </p>
                                        @else
                                            <p class="mb-0 text-muted">
                                                <i class="fas fa-users me-1"></i>
                                                User Lain
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if(auth()->user()->isAdmin() && $user->id !== auth()->id())
                        <hr>
                        <div class="row">
                            <div class="col-12">
                                <h6 class="fw-bold mb-3">Aksi Cepat</h6>
                                <div class="d-flex gap-2">
                                    @if($user->isSuperAdmin() && !auth()->user()->isSuperAdmin())
                                        <button class="btn btn-outline-secondary" disabled>
                                            <i class="fas fa-ban me-1"></i>
                                            Tidak Dapat Mengubah Super Admin
                                        </button>
                                    @else
                                        <form method="POST" action="{{ route('user-management.toggle-status', $user) }}" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-{{ $user->isActive() ? 'outline-warning' : 'outline-success' }}"
                                                    onclick="return confirm('Apakah Anda yakin ingin {{ $user->isActive() ? 'menonaktifkan' : 'mengaktifkan' }} user ini?')">
                                                <i class="fas fa-{{ $user->isActive() ? 'ban' : 'check' }} me-1"></i>
                                                {{ $user->isActive() ? 'Nonaktifkan' : 'Aktifkan' }}
                                            </button>
                                        </form>
                                        
                                        <form method="POST" action="{{ route('user-management.destroy', $user) }}" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger"
                                                    onclick="return confirm('Apakah Anda yakin ingin menghapus user ini?')">
                                                <i class="fas fa-trash me-1"></i>
                                                Hapus User
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.avatar-lg {
    font-weight: 600;
}

.font-monospace {
    font-family: 'Courier New', Courier, monospace;
    font-size: 0.9em;
}
</style>
@endsection
