@extends('layouts.app')

@section('title', 'Master UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Master UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Master UPA</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Daftar UPA</h5>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('upa.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Tambah UPA
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter dan Pencarian -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <form method="GET" class="d-flex">
                                <input type="text" class="form-control me-2" name="search" 
                                       value="{{ request('search') }}" placeholder="Cari UPA...">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-search"></i>
                                </button>
                            </form>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" onchange="filterByStatus(this.value)">
                                <option value="">Semua Status</option>
                                @foreach($statusList as $status)
                                    <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                        {{ $status }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3 text-end">
                            @if(request('search') || request('status'))
                                <a href="{{ route('upa.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i> Reset Filter
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Tabel UPA -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Kode UPA</th>
                                    <th>Nama UPA</th>
                                    <th>Kota</th>
                                    <th>Provinsi</th>
                                    <th>Pembimbing</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($upas as $index => $upa)
                                    <tr>
                                        <td>{{ $upas->firstItem() + $index }}</td>
                                        <td>
                                            <span class="fw-bold text-primary">{{ $upa->kode_upa }}</span>
                                        </td>
                                        <td>
                                            <div>
                                                <div class="fw-bold">{{ $upa->nama_upa }}</div>
                                                @if($upa->deskripsi)
                                                    <small class="text-muted">{{ Str::limit($upa->deskripsi, 50) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>{{ $upa->refKota->nama_kota ?? ($upa->kota ?? '-') }}</td>
                                        <td>{{ $upa->refProvinsi->nama_provinsi ?? ($upa->provinsi ?? '-') }}</td>
                                        <td>
                                            @if($upa->pembimbingAktif && $upa->pembimbingAktif->count() > 0)
                                                @foreach($upa->pembimbingAktif->take(2) as $pembimbing)
                                                    <span class="badge bg-info me-1 mb-1">
                                                        {{ $pembimbing->pivot->jabatan }}: {{ $pembimbing->nama_lengkap }}
                                                    </span>
                                                @endforeach
                                                @if($upa->pembimbingAktif->count() > 2)
                                                    <span class="badge bg-light text-dark">+{{ $upa->pembimbingAktif->count() - 2 }} lainnya</span>
                                                @endif
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $upa->status == 'Aktif' ? 'success' : ($upa->status == 'Tidak Aktif' ? 'warning' : 'danger') }}">
                                                {{ $upa->status }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('upa.show', $upa) }}" class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('upa.edit', $upa) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('upa.destroy', $upa) }}" method="POST" class="d-inline" 
                                                      onsubmit="return confirm('Apakah Anda yakin ingin menghapus UPA ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                                <p>Tidak ada data UPA ditemukan</p>
                                                @if(request('search') || request('status'))
                                                    <a href="{{ route('upa.index') }}" class="btn btn-outline-primary">
                                                        Lihat Semua UPA
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($upas->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $upas->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByStatus(status) {
    const url = new URL(window.location);
    if (status) {
        url.searchParams.set('status', status);
    } else {
        url.searchParams.delete('status');
    }
    window.location = url;
}
</script>
@endsection
