@extends('layouts.app')

@section('title', 'Detail Aktivitas UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Detail Aktivitas UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa-group-activity.index') }}">Pelaksanaan Grup UPA</a></li>
                        <li class="breadcrumb-item active">Detail Aktivitas</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Informasi Aktivitas UPA</h5>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('upa-group-activity.edit', $upaGroupActivity) }}" class="btn btn-warning">
                                <i class="fas fa-edit me-1"></i> Edit
                            </a>
                            <a href="{{ route('upa-group-activity.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Informasi Dasar -->
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Informasi Dasar</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Kode UPA:</strong></td>
                                    <td>{{ $upaGroupActivity->kode_upa }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Nama UPA:</strong></td>
                                    <td>{{ $upaGroupActivity->upa->nama_upa ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Pembimbing:</strong></td>
                                    <td>{{ $upaGroupActivity->nama_pembimbing }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal UPA:</strong></td>
                                    <td>{{ \Carbon\Carbon::parse($upaGroupActivity->tanggal_upa)->format('d F Y') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Pekan:</strong></td>
                                    <td>{{ $upaGroupActivity->pekan ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Waktu UPA:</strong></td>
                                    <td>{{ \Carbon\Carbon::parse($upaGroupActivity->waktu_upa)->format('H:i') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Kehadiran Pembimbing:</strong></td>
                                    <td>
                                        @if($upaGroupActivity->kehadiran_pembimbing)
                                            <span class="badge bg-success">Hadir</span>
                                        @else
                                            <span class="badge bg-danger">Tidak Hadir</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status Terlaksana:</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $upaGroupActivity->status_terlaksana == 'Terlaksana' ? 'success' : 'warning' }}">
                                            {{ $upaGroupActivity->status_terlaksana }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <!-- Statistik Kehadiran -->
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Statistik Kehadiran</h6>
                            <div class="row">
                                <div class="col-6">
                                    <div class="card bg-light">
                                        <div class="card-body text-center">
                                            <h3 class="text-success">{{ $upaGroupActivity->total_kehadiran }}</h3>
                                            <p class="mb-0">Hadir</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="card bg-light">
                                        <div class="card-body text-center">
                                            <h3 class="text-danger">{{ $upaGroupActivity->total_anggota - $upaGroupActivity->total_kehadiran }}</h3>
                                            <p class="mb-0">Tidak Hadir</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="progress">
                                    <div class="progress-bar" role="progressbar" 
                                         style="width: {{ $upaGroupActivity->total_anggota > 0 ? ($upaGroupActivity->total_kehadiran / $upaGroupActivity->total_anggota) * 100 : 0 }}%">
                                        {{ $upaGroupActivity->total_anggota > 0 ? round(($upaGroupActivity->total_kehadiran / $upaGroupActivity->total_anggota) * 100, 1) : 0 }}%
                                    </div>
                                </div>
                                <small class="text-muted">Persentase Kehadiran</small>
                            </div>
                        </div>
                    </div>

                    <!-- Agenda UPA -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-clipboard-list me-2"></i>Agenda UPA
                            </h6>
                            
                            @if($upaGroupActivity->agenda_notes && is_array($upaGroupActivity->agenda_notes) && count($upaGroupActivity->agenda_notes) > 0)
                                <!-- Multiple Agenda dengan Notes -->
                                <div class="row">
                                    @foreach($upaGroupActivity->agenda_notes as $index => $agenda)
                                    <div class="col-md-6 mb-3">
                                        <div class="card border-start border-primary border-3">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center mb-2">
                                                    <span class="badge bg-primary me-2">{{ $index + 1 }}</span>
                                                    <h6 class="mb-0">{{ $agenda['nama_agenda'] ?? '-' }}</h6>
                                                </div>
                                            @if(!empty($agenda['note']))
                                            <div class="mt-2 p-2 bg-light rounded">
                                                <small class="text-muted d-block mb-1">
                                                    <i class="fas fa-sticky-note me-1"></i>Description/Keterangan:
                                                </small>
                                                <p class="mb-0" style="white-space: pre-wrap;">{{ $agenda['note'] }}</p>
                                            </div>
                                            @else
                                            <small class="text-muted">
                                                <i class="fas fa-info-circle me-1"></i>Tidak ada keterangan
                                            </small>
                                            @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            @elseif($upaGroupActivity->agenda_upa)
                                <!-- Single Agenda (Data Lama) -->
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <p class="mb-0">{{ $upaGroupActivity->agenda_upa }}</p>
                                    </div>
                                </div>
                            @else
                                <!-- Tidak Ada Agenda -->
                                <div class="card bg-light border-warning">
                                    <div class="card-body text-center py-4">
                                        <i class="fas fa-info-circle text-warning fa-2x mb-2"></i>
                                        <p class="text-muted mb-0">Tidak ada agenda yang dicatat untuk aktivitas ini</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Catatan -->
                    @if($upaGroupActivity->catatan)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">Catatan</h6>
                            <div class="card bg-light">
                                <div class="card-body">
                                    <p class="mb-0">{{ $upaGroupActivity->catatan }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Daftar Kehadiran Anggota -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">Daftar Kehadiran Anggota</h6>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>No</th>
                                            <th>Nama Anggota</th>
                                            <th>Telepon</th>
                                            <th>Status Kehadiran</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($upaGroupActivity->attendances as $index => $attendance)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $attendance->anggota->nama_lengkap }}</td>
                                                <td>{{ $attendance->anggota->no_telepon ?? '-' }}</td>
                                                <td>
                                                    @if($attendance->status_kehadiran == 'Hadir')
                                                        <span class="badge bg-success">Hadir</span>
                                                    @else
                                                        <span class="badge bg-danger">Tidak Hadir</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-center py-4">
                                                    <div class="text-muted">
                                                        <i class="fas fa-users fa-2x mb-2"></i>
                                                        <p>Tidak ada data kehadiran</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
