@extends('layouts.app')

@section('title', 'Edit Aktivitas UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Edit Aktivitas UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa-group-activity.index') }}">Pelaksanaan Grup UPA</a></li>
                        <li class="breadcrumb-item active">Edit Aktivitas</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Edit Aktivitas UPA</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('upa-group-activity.update', $upaGroupActivity) }}" method="POST" id="upa-form">
                        @csrf
                        @method('PUT')
                        
                        <!-- Hidden input untuk agenda notes -->
                        <input type="hidden" name="agenda_notes_json" id="agenda_notes_json" value="">
                        
                        <div class="row">
                            <!-- Kode UPA -->
                            <div class="col-md-6 mb-3">
                                <label for="kode_upa" class="form-label">Kode UPA <span class="text-danger">*</span></label>
                                <select class="form-select @error('kode_upa') is-invalid @enderror" id="kode_upa" name="kode_upa" required>
                                    <option value="">Pilih UPA</option>
                                    @foreach($upaList as $upa)
                                        <option value="{{ $upa->kode_upa }}" 
                                                {{ old('kode_upa', $upaGroupActivity->kode_upa) == $upa->kode_upa ? 'selected' : '' }}>
                                            {{ $upa->kode_upa }} - {{ $upa->nama_upa }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('kode_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Nama Pembimbing -->
                            <div class="col-md-6 mb-3">
                                <label for="nama_pembimbing" class="form-label">Nama Pembimbing <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_pembimbing') is-invalid @enderror" 
                                       id="nama_pembimbing" name="nama_pembimbing" 
                                       value="{{ old('nama_pembimbing', $upaGroupActivity->nama_pembimbing) }}" 
                                       readonly style="background-color: #f8f9fa;" required>
                                <small class="text-muted">Nama pembimbing akan terisi otomatis berdasarkan UPA yang dipilih</small>
                                @error('nama_pembimbing')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Tanggal UPA -->
                            <div class="col-md-4 mb-3">
                                <label for="tanggal_upa" class="form-label">Tanggal UPA <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('tanggal_upa') is-invalid @enderror" 
                                       id="tanggal_upa" name="tanggal_upa" 
                                       value="{{ old('tanggal_upa', $upaGroupActivity->tanggal_upa ? $upaGroupActivity->tanggal_upa->format('Y-m-d') : '') }}" required>
                                @error('tanggal_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Pekan -->
                            <div class="col-md-2 mb-3">
                                <label for="pekan" class="form-label">Pekan</label>
                                <input type="text" class="form-control @error('pekan') is-invalid @enderror" 
                                       id="pekan" name="pekan" value="{{ old('pekan', $upaGroupActivity->pekan) }}" readonly 
                                       style="background-color: #f8f9fa;" placeholder="Auto">
                                @error('pekan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Waktu UPA -->
                            <div class="col-md-6 mb-3">
                                <label for="waktu_upa" class="form-label">Waktu UPA <span class="text-danger">*</span></label>
                                <input type="time" class="form-control @error('waktu_upa') is-invalid @enderror" 
                                       id="waktu_upa" name="waktu_upa" 
                                       value="{{ old('waktu_upa', $upaGroupActivity->waktu_upa ? $upaGroupActivity->waktu_upa->format('H:i') : '') }}" required>
                                @error('waktu_upa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Status Terlaksana -->
                            <div class="col-12 mb-3">
                                <label for="status_terlaksana" class="form-label">Status Terlaksana <span class="text-danger">*</span></label>
                                <select class="form-select @error('status_terlaksana') is-invalid @enderror" 
                                        id="status_terlaksana" name="status_terlaksana" required>
                                    <option value="">Pilih Status</option>
                                    <option value="Terlaksana" 
                                            {{ old('status_terlaksana', $upaGroupActivity->status_terlaksana) == 'Terlaksana' ? 'selected' : '' }}>
                                        Terlaksana
                                    </option>
                                    <option value="Tidak Terlaksana" 
                                            {{ old('status_terlaksana', $upaGroupActivity->status_terlaksana) == 'Tidak Terlaksana' ? 'selected' : '' }}>
                                        Tidak Terlaksana
                                    </option>
                                </select>
                                @error('status_terlaksana')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Agenda UPA (Multiple) -->
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <label class="form-label mb-0">Agenda UPA</label>
                                    <button type="button" class="btn btn-sm btn-primary" id="add-agenda-btn">
                                        <i class="fas fa-plus me-1"></i>Tambah Agenda
                                    </button>
                                </div>

                                <div class="border rounded p-3 bg-light">
                                    <!-- Dropdown untuk pilih agenda -->
                                    <div class="mb-3" id="agenda-selector">
                                        <select class="form-select" id="agenda_select">
                                            <option value="">Pilih Agenda...</option>
                                            @foreach($agendaList as $agenda)
                                                <option value="{{ $agenda->nama_agenda }}">{{ $agenda->nama_agenda }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Container untuk agenda yang sudah ditambahkan -->
                                    <div id="agenda-items-container">
                                        <p class="text-muted text-center mb-0" id="empty-agenda-message">
                                            <i class="fas fa-info-circle me-1"></i>Belum ada agenda yang ditambahkan
                                        </p>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    <i class="fas fa-lightbulb me-1"></i>Agenda UPA bisa lebih dari satu dan masing-masing bisa diberi description/keterangan
                                </small>
                            </div>

                            <!-- Catatan -->
                            <div class="col-12 mb-3">
                                <label for="catatan" class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          id="catatan" name="catatan" rows="3" 
                                          placeholder="Masukkan catatan tambahan">{{ old('catatan', $upaGroupActivity->catatan) }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Presensi Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5 class="mb-3">Presensi</h5>
                                
                                <!-- Kehadiran Pembimbing -->
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <div class="card border-0 bg-light">
                                            <div class="card-body">
                                                <h6 class="card-title mb-3">
                                                    <i class="fas fa-user-tie me-2 text-primary"></i>Kehadiran Pembimbing
                                                </h6>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="kehadiran_pembimbing" 
                                                           name="kehadiran_pembimbing" value="1" 
                                                           {{ old('kehadiran_pembimbing', $upaGroupActivity->kehadiran_pembimbing) ? 'checked' : '' }}>
                                                    <label class="form-check-label fw-bold" for="kehadiran_pembimbing">
                                                        Pembimbing Hadir
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Presensi Anggota -->
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="mb-0">
                                            <i class="fas fa-users me-2 text-success"></i>Presensi Anggota
                                        </h6>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-success btn-sm" id="hadir-semua-btn">
                                                <i class="fas fa-check-double me-1"></i>Hadir Semua
                                            </button>
                                            <button type="button" class="btn btn-outline-secondary btn-sm" id="tidak-hadir-semua-btn">
                                                <i class="fas fa-times me-1"></i>Tidak Hadir Semua
                                            </button>
                                        </div>
                                    </div>
                                    <div id="anggota-container">
                                        <p class="text-muted">Loading daftar anggota...</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> Update
                                </button>
                                <a href="{{ route('upa-group-activity.show', $upaGroupActivity) }}" class="btn btn-secondary">
                                    <i class="fas fa-times me-1"></i> Batal
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const kodeUpaSelect = document.getElementById('kode_upa');
    const anggotaContainer = document.getElementById('anggota-container');
    const tanggalUpaInput = document.getElementById('tanggal_upa');
    const pekanInput = document.getElementById('pekan');
    
    // Load existing attendance data
    const existingAttendance = @json($upaGroupActivity->attendances->keyBy('anggota_id'));

    // Function to calculate week number from a date
    function getWeekNumber(date) {
        const d = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate()));
        const dayNum = d.getUTCDay() || 7;
        d.setUTCDate(d.getUTCDate() + 4 - dayNum);
        const yearStart = new Date(Date.UTC(d.getUTCFullYear(), 0, 1));
        const weekNo = Math.ceil((((d - yearStart) / 86400000) + 1) / 7);
        return weekNo;
    }

    // Auto-fill week number when date is selected
    tanggalUpaInput.addEventListener('change', function() {
        if (this.value) {
            const selectedDate = new Date(this.value);
            const weekNumber = getWeekNumber(selectedDate);
            pekanInput.value = weekNumber;
        } else {
            pekanInput.value = '';
        }
    });

    // Initialize week number if date is already set (for old values)
    if (tanggalUpaInput.value) {
        const selectedDate = new Date(tanggalUpaInput.value);
        const weekNumber = getWeekNumber(selectedDate);
        pekanInput.value = weekNumber;
    }

    // CSS untuk memastikan checkbox terlihat jelas
    const style = document.createElement('style');
    style.textContent = `
        .form-check-input[type="checkbox"] {
            margin-right: 8px;
            transform: scale(1.2);
        }
        .form-check-label {
            cursor: pointer;
            font-size: 14px;
        }
        .form-check-input:checked {
            background-color: #198754;
            border-color: #198754;
        }
        .form-check-input:focus {
            box-shadow: 0 0 0 0.25rem rgba(25, 135, 84, 0.25);
        }
        #hadir-semua-btn, #tidak-hadir-semua-btn {
            transition: all 0.2s ease;
        }
        #hadir-semua-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(25, 135, 84, 0.3);
        }
        #tidak-hadir-semua-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
        }
        .card.bg-light {
            background-color: #f8f9fa !important;
            border: 1px solid #e9ecef;
            min-height: 200px;
        }
        .card-title {
            color: #495057;
            font-size: 14px;
        }
        .card-body.d-flex {
            padding: 1.5rem;
        }
        .btn-group .btn {
            font-size: 12px;
            padding: 0.375rem 0.75rem;
        }
        .btn-group .btn:not(:last-child) {
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }
        .btn-group .btn:not(:first-child) {
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }
        .agenda-note-item {
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 6px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .agenda-note-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #e9ecef;
        }
        .agenda-note-header span {
            font-weight: 600;
            color: #495057;
        }
        .agenda-note-remove {
            background: none;
            border: none;
            color: #dc3545;
            cursor: pointer;
            padding: 5px 10px;
            border-radius: 4px;
            transition: all 0.2s;
        }
        .agenda-note-remove:hover {
            background-color: #dc3545;
            color: white;
        }
        .agenda-note-textarea {
            width: 100%;
            min-height: 80px;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            font-size: 14px;
            resize: vertical;
        }
        .agenda-note-textarea:focus {
            outline: none;
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
    `;
    document.head.appendChild(style);

    // Multiple Agenda Management
    const agendaSelect = document.getElementById('agenda_select');
    const addAgendaBtn = document.getElementById('add-agenda-btn');
    const agendaItemsContainer = document.getElementById('agenda-items-container');
    const emptyMessage = document.getElementById('empty-agenda-message');

    let agendaItems = [];

    // Load existing agenda notes from database
    const existingAgendaNotes = @json($upaGroupActivity->agenda_notes ?? []);
    if (existingAgendaNotes && existingAgendaNotes.length > 0) {
        agendaItems = existingAgendaNotes.map((item, index) => ({
            id: Date.now() + index,
            nama_agenda: item.nama_agenda,
            note: item.note || ''
        }));
        renderAgendaItems();
        updateAgendaHiddenInputs();
    }

    // Function to add agenda item
    function addAgendaItem(agendaNama, agendaNote = '') {
        const id = Date.now(); // Unique ID
        const item = {
            id: id,
            nama_agenda: agendaNama,
            note: agendaNote
        };

        agendaItems.push(item);
        renderAgendaItems();
        updateAgendaHiddenInputs();
    }

    // Function to remove agenda item
    function removeAgendaItem(id) {
        agendaItems = agendaItems.filter(item => item.id !== id);
        renderAgendaItems();
        updateAgendaHiddenInputs();
    }

    // Function to render agenda items
    function renderAgendaItems() {
        if (agendaItems.length === 0) {
            emptyMessage.style.display = 'block';
            return;
        }

        emptyMessage.style.display = 'none';

        let html = '';
        agendaItems.forEach((item, index) => {
            html += `
                <div class="agenda-note-item" data-id="${item.id}">
                    <div class="agenda-note-header">
                        <span><i class="fas fa-clipboard-list me-2"></i>${item.nama_agenda}</span>
                        <button type="button" class="agenda-note-remove" onclick="removeAgendaItem(${item.id})">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <textarea class="agenda-note-textarea"
                              placeholder="Tuliskan description/keterangan untuk agenda ini..."
                              onchange="updateAgendaNote(${item.id}, this.value)">${item.note}</textarea>
                </div>
            `;
        });

        agendaItemsContainer.innerHTML = html;
    }

    // Function to update agenda note
    window.updateAgendaNote = function(id, note) {
        const item = agendaItems.find(item => item.id === id);
        if (item) {
            item.note = note;
            updateAgendaHiddenInputs();
        }
    };

    // Function to remove agenda item (global)
    window.removeAgendaItem = removeAgendaItem;

    // Function to update hidden inputs
    function updateAgendaHiddenInputs() {
        const hiddenInput = document.getElementById('agenda_notes_json');
        
        if (!hiddenInput) {
            console.error('❌ Hidden input agenda_notes_json not found!');
            return;
        }

        if (agendaItems.length > 0) {
            const jsonValue = JSON.stringify(agendaItems);
            hiddenInput.value = jsonValue;
            
            console.log('✅ Agenda Notes Updated (EDIT):', {
                count: agendaItems.length,
                data: agendaItems,
                json: jsonValue
            });
        } else {
            hiddenInput.value = '';
            console.log('⚠️ No agenda items to save - hidden input cleared');
        }
    }

    // Add agenda button click handler
    addAgendaBtn.addEventListener('click', function() {
        const selectedAgenda = agendaSelect.value;

        if (!selectedAgenda) {
            alert('Pilih agenda terlebih dahulu');
            return;
        }

        // Check if agenda already added
        if (agendaItems.some(item => item.nama_agenda === selectedAgenda)) {
            alert('Agenda ini sudah ditambahkan');
            return;
        }

        addAgendaItem(selectedAgenda);
        agendaSelect.value = ''; // Reset selection
    });

    // Form submit handler - Update hidden input before submit
    const form = document.getElementById('upa-form');
    if (form) {
        console.log('✅ Form found, adding submit handler');
        form.addEventListener('submit', function(e) {
            console.log('🚀 FORM SUBMIT EVENT TRIGGERED (EDIT)!');
            
            // Update hidden input one more time before submit
            updateAgendaHiddenInputs();
            
            const hiddenInput = document.getElementById('agenda_notes_json');
            console.log('📤 Form Submitting (EDIT):', {
                agendaItemsCount: agendaItems.length,
                hiddenInputExists: !!hiddenInput,
                hiddenInputValue: hiddenInput ? hiddenInput.value : 'null',
                hiddenInputLength: hiddenInput ? hiddenInput.value.length : 0
            });

            if (agendaItems.length === 0) {
                console.warn('⚠️ WARNING: No agenda items found!');
            }
        });
    } else {
        console.error('❌ Form not found!');
    }

    function loadAnggota(kodeUpa) {
        if (kodeUpa) {
            // Load pembimbing UPA terlebih dahulu
            fetch(`{{ url('/api/pembimbing-upa') }}?kode_upa=${kodeUpa}`)
                .then(response => response.json())
                .then(pembimbingData => {
                    // Isi nama pembimbing
                    document.getElementById('nama_pembimbing').value = pembimbingData.nama_pembimbing || '';
                    
                    // Load anggota UPA
                    return fetch(`{{ url('/api/anggota-upa') }}?kode_upa=${kodeUpa}`);
                })
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        let html = '<div class="table-responsive"><table class="table table-sm">';
                        html += '<thead class="table-light"><tr><th>Nama Anggota</th><th>Telepon</th><th>Kehadiran</th></tr></thead>';
                        html += '<tbody>';
                        
                        data.forEach(anggota => {
                            const existingStatus = existingAttendance[anggota.id]?.status_kehadiran || 'Tidak Hadir';
                            const hadirChecked = existingStatus === 'Hadir' ? 'checked' : '';
                            
                            html += `
                                <tr>
                                    <td>${anggota.nama_lengkap}</td>
                                    <td>${anggota.no_telepon || '-'}</td>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" 
                                                   name="anggota_kehadiran[${anggota.id}]" 
                                                   id="hadir_${anggota.id}" value="Hadir" ${hadirChecked}>
                                            <label class="form-check-label" for="hadir_${anggota.id}">
                                                <strong>Hadir</strong>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            `;
                        });
                        
                        html += '</tbody></table></div>';
                        anggotaContainer.innerHTML = html;
                        
                        // Tambahkan event listener untuk tombol "Hadir Semua" dan "Tidak Hadir Semua"
                        const hadirSemuaBtn = document.getElementById('hadir-semua-btn');
                        const tidakHadirSemuaBtn = document.getElementById('tidak-hadir-semua-btn');
                        
                        if (hadirSemuaBtn) {
                            hadirSemuaBtn.addEventListener('click', function() {
                                data.forEach(anggota => {
                                    const checkbox = document.getElementById(`hadir_${anggota.id}`);
                                    if (checkbox) {
                                        checkbox.checked = true;
                                    }
                                });
                            });
                        }
                        
                        if (tidakHadirSemuaBtn) {
                            tidakHadirSemuaBtn.addEventListener('click', function() {
                                data.forEach(anggota => {
                                    const checkbox = document.getElementById(`hadir_${anggota.id}`);
                                    if (checkbox) {
                                        checkbox.checked = false;
                                    }
                                });
                            });
                        }
                    } else {
                        anggotaContainer.innerHTML = '<p class="text-muted">Tidak ada anggota aktif di UPA ini</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    anggotaContainer.innerHTML = '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle me-2"></i>Error loading data: ' + error.message + '</div>';
                });
        } else {
            // Reset nama pembimbing dan anggota
            document.getElementById('nama_pembimbing').value = '';
            anggotaContainer.innerHTML = '<p class="text-muted">Pilih UPA terlebih dahulu untuk melihat daftar anggota</p>';
        }
    }

    // Load anggota on page load
    loadAnggota(kodeUpaSelect.value);

    // Load anggota when UPA changes
    kodeUpaSelect.addEventListener('change', function() {
        loadAnggota(this.value);
    });
});
</script>
@endsection
