@extends('layouts.app')

@section('title', 'Detail Agenda UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Detail Agenda UPA</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('upa-agenda-master.index') }}">Master Agenda UPA</a></li>
                        <li class="breadcrumb-item active">Detail Agenda</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Informasi Agenda UPA</h5>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('upa-agenda-master.edit', $upaAgendaMaster) }}" class="btn btn-warning">
                                <i class="fas fa-edit me-1"></i> Edit
                            </a>
                            <a href="{{ route('upa-agenda-master.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Informasi Dasar -->
                        <div class="col-md-8">
                            <h6 class="text-primary mb-3">Informasi Agenda</h6>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="30%"><strong>Nama Agenda:</strong></td>
                                    <td>{{ $upaAgendaMaster->nama_agenda }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Deskripsi:</strong></td>
                                    <td>
                                        @if($upaAgendaMaster->deskripsi)
                                            {{ $upaAgendaMaster->deskripsi }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $upaAgendaMaster->is_active ? 'success' : 'danger' }}">
                                            {{ $upaAgendaMaster->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Dibuat:</strong></td>
                                    <td>{{ $upaAgendaMaster->created_at->format('d F Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Terakhir Diupdate:</strong></td>
                                    <td>{{ $upaAgendaMaster->updated_at->format('d F Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>

                        <!-- Statistik Penggunaan -->
                        <div class="col-md-4">
                            <h6 class="text-primary mb-3">Statistik Penggunaan</h6>
                            <div class="card bg-light">
                                <div class="card-body text-center">
                                    <h3 class="text-info">{{ $upaAgendaMaster->groupActivities()->count() }}</h3>
                                    <p class="mb-0">Total Penggunaan</p>
                                </div>
                            </div>
                            
                            @if($upaAgendaMaster->groupActivities()->count() > 0)
                            <div class="mt-3">
                                <h6 class="text-primary mb-2">Penggunaan Terbaru</h6>
                                <div class="list-group list-group-flush">
                                    @foreach($upaAgendaMaster->groupActivities()->latest()->take(3)->get() as $activity)
                                        <div class="list-group-item px-0 py-2">
                                            <div class="d-flex justify-content-between">
                                                <div>
                                                    <small class="text-muted">{{ $activity->kode_upa }}</small><br>
                                                    <small>{{ \Carbon\Carbon::parse($activity->tanggal_upa)->format('d/m/Y') }}</small>
                                                </div>
                                                <div>
                                                    <span class="badge bg-{{ $activity->status_terlaksana == 'Terlaksana' ? 'success' : 'warning' }} badge-sm">
                                                        {{ $activity->status_terlaksana }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
