@extends('layouts.app')

@section('title', 'Edit Takwim - Sistem Informasi PKS')

@section('content')
<style>
.dropdown-menu {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1000;
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.dropdown-item {
    padding: 0.5rem 1rem;
    border-bottom: 1px solid #f8f9fa;
}

.dropdown-item:hover,
.dropdown-item.active {
    background-color: #f8f9fa;
    color: #495057;
}

.dropdown-item:last-child {
    border-bottom: none;
}

.dropdown-item strong {
    color: #007bff;
}
</style>

<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Edit Takwim</h1>
        <p class="text-muted">Ubah data program takwim</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('takwim.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
    </div>
</div>

<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-edit me-2"></i>Form Edit Takwim
        </h6>
    </div>
    <div class="card-body">
        <form action="{{ route('takwim.update', $takwim) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="row">
                <div class="col-md-8">
                    <div class="mb-3">
                        <label for="nama_takwim" class="form-label">Nama Takwim <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_takwim') is-invalid @enderror" 
                               id="nama_takwim" name="nama_takwim" value="{{ old('nama_takwim', $takwim->nama_takwim) }}" 
                               placeholder="Masukkan nama takwim" required>
                        @error('nama_takwim')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="status_takwim" class="form-label">Status <span class="text-danger">*</span></label>
                        <select class="form-select @error('status_takwim') is-invalid @enderror" 
                                id="status_takwim" name="status_takwim" required>
                            <option value="">Pilih Status</option>
                            <option value="Aktif" {{ old('status_takwim', $takwim->status_takwim) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="Selesai" {{ old('status_takwim', $takwim->status_takwim) == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                            <option value="Dibatalkan" {{ old('status_takwim', $takwim->status_takwim) == 'Dibatalkan' ? 'selected' : '' }}>Dibatalkan</option>
                        </select>
                        @error('status_takwim')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="deskripsi" class="form-label">Deskripsi</label>
                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                          id="deskripsi" name="deskripsi" rows="3" 
                          placeholder="Masukkan deskripsi takwim">{{ old('deskripsi', $takwim->deskripsi) }}</textarea>
                @error('deskripsi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('tanggal_mulai') is-invalid @enderror" 
                               id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ old('tanggal_mulai', $takwim->tanggal_mulai ? $takwim->tanggal_mulai->format('Y-m-d') : '') }}" required>
                        @error('tanggal_mulai')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control @error('tanggal_selesai') is-invalid @enderror" 
                               id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ old('tanggal_selesai', $takwim->tanggal_selesai ? $takwim->tanggal_selesai->format('Y-m-d') : '') }}">
                        @error('tanggal_selesai')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="penyelenggara" class="form-label">Penyelenggara <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('penyelenggara') is-invalid @enderror" 
                               id="penyelenggara" name="penyelenggara" value="{{ old('penyelenggara', $takwim->penyelenggara) }}" 
                               placeholder="Masukkan nama penyelenggara" required>
                        @error('penyelenggara')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="koordinator_search" class="form-label">Koordinator <span class="text-danger">*</span></label>
                        <div class="position-relative">
                            <input type="text" class="form-control @error('koordinator_anggota_id') is-invalid @enderror" 
                                   id="koordinator_search" name="koordinator_search" 
                                   placeholder="Cari koordinator..." 
                                   autocomplete="off" required>
                            <input type="hidden" id="koordinator_anggota_id" name="koordinator_anggota_id" 
                                   value="{{ old('koordinator_anggota_id', $takwim->koordinator_anggota_id) }}">
                            <div id="koordinator_dropdown" class="dropdown-menu w-100" style="display: none; max-height: 300px; overflow-y: auto;">
                                <!-- Options will be populated by JavaScript -->
                            </div>
                        </div>
                        @error('koordinator_anggota_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="evaluasi" class="form-label">Evaluasi</label>
                <textarea class="form-control @error('evaluasi') is-invalid @enderror" 
                          id="evaluasi" name="evaluasi" rows="3" 
                          placeholder="Masukkan evaluasi takwim">{{ old('evaluasi', $takwim->evaluasi) }}</textarea>
                @error('evaluasi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="catatan_berkelanjutan" class="form-label">Catatan Berkelanjutan</label>
                <textarea class="form-control @error('catatan_berkelanjutan') is-invalid @enderror" 
                          id="catatan_berkelanjutan" name="catatan_berkelanjutan" rows="3" 
                          placeholder="Masukkan catatan berkelanjutan">{{ old('catatan_berkelanjutan', $takwim->catatan_berkelanjutan) }}</textarea>
                @error('catatan_berkelanjutan')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('takwim.show', $takwim) }}" class="btn btn-info">
                    <i class="fas fa-eye me-1"></i> Lihat Detail
                </a>
                <a href="{{ route('takwim.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-1"></i> Batal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-1"></i> Update
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const tanggalMulai = document.getElementById('tanggal_mulai');
    const tanggalSelesai = document.getElementById('tanggal_selesai');
    
    tanggalMulai.addEventListener('change', function() {
        if (this.value) {
            tanggalSelesai.min = this.value;
        }
    });
    
    tanggalSelesai.addEventListener('change', function() {
        if (tanggalMulai.value && this.value < tanggalMulai.value) {
            this.setCustomValidity('Tanggal selesai harus setelah tanggal mulai');
        } else {
            this.setCustomValidity('');
        }
    });
    
    // Searchable Koordinator Dropdown
    const koordinatorSearch = document.getElementById('koordinator_search');
    const koordinatorId = document.getElementById('koordinator_anggota_id');
    const koordinatorDropdown = document.getElementById('koordinator_dropdown');
    let allAnggotas = @json($anggotas);
    let filteredAnggotas = [];
    let selectedIndex = -1;
    
    // Initialize with selected value if exists
    const selectedAnggotaId = koordinatorId.value;
    if (selectedAnggotaId) {
        const selectedAnggota = allAnggotas.find(a => a.id == selectedAnggotaId);
        if (selectedAnggota) {
            koordinatorSearch.value = `${selectedAnggota.nomor_identitas_anggota} - ${selectedAnggota.nama_lengkap} - ${selectedAnggota.ref_jenjang?.jenjang || 'N/A'}`;
        }
    }
    
    function filterAnggotas(searchTerm) {
        if (searchTerm.length < 2) {
            filteredAnggotas = [];
            koordinatorDropdown.style.display = 'none';
            return;
        }
        
        filteredAnggotas = allAnggotas.filter(anggota => 
            anggota.nama_lengkap.toLowerCase().includes(searchTerm.toLowerCase()) ||
            anggota.nomor_identitas_anggota.toLowerCase().includes(searchTerm.toLowerCase()) ||
            (anggota.ref_jenjang?.jenjang || '').toLowerCase().includes(searchTerm.toLowerCase())
        );
        
        displayDropdown();
    }
    
    function displayDropdown() {
        if (filteredAnggotas.length === 0) {
            koordinatorDropdown.style.display = 'none';
            return;
        }
        
        koordinatorDropdown.innerHTML = '';
        filteredAnggotas.forEach((anggota, index) => {
            const option = document.createElement('div');
            option.className = 'dropdown-item';
            option.style.cursor = 'pointer';
            option.innerHTML = `
                <div class="d-flex justify-content-between">
                    <div>
                        <strong>${anggota.nomor_identitas_anggota}</strong> - ${anggota.nama_lengkap}
                    </div>
                    <small class="text-muted">${anggota.ref_jenjang?.jenjang || 'N/A'}</small>
                </div>
            `;
            
            option.addEventListener('click', function() {
                selectAnggota(anggota);
            });
            
            option.addEventListener('mouseenter', function() {
                // Remove active class from all options
                koordinatorDropdown.querySelectorAll('.dropdown-item').forEach(item => {
                    item.classList.remove('active');
                });
                // Add active class to current option
                this.classList.add('active');
                selectedIndex = index;
            });
            
            koordinatorDropdown.appendChild(option);
        });
        
        koordinatorDropdown.style.display = 'block';
        selectedIndex = -1;
    }
    
    function selectAnggota(anggota) {
        koordinatorSearch.value = `${anggota.nomor_identitas_anggota} - ${anggota.nama_lengkap} - ${anggota.ref_jenjang?.jenjang || 'N/A'}`;
        koordinatorId.value = anggota.id;
        koordinatorDropdown.style.display = 'none';
        filteredAnggotas = [];
    }
    
    koordinatorSearch.addEventListener('input', function() {
        filterAnggotas(this.value);
    });
    
    koordinatorSearch.addEventListener('keydown', function(e) {
        if (koordinatorDropdown.style.display === 'none') return;
        
        switch(e.key) {
            case 'ArrowDown':
                e.preventDefault();
                selectedIndex = Math.min(selectedIndex + 1, filteredAnggotas.length - 1);
                updateSelection();
                break;
            case 'ArrowUp':
                e.preventDefault();
                selectedIndex = Math.max(selectedIndex - 1, -1);
                updateSelection();
                break;
            case 'Enter':
                e.preventDefault();
                if (selectedIndex >= 0 && filteredAnggotas[selectedIndex]) {
                    selectAnggota(filteredAnggotas[selectedIndex]);
                }
                break;
            case 'Escape':
                koordinatorDropdown.style.display = 'none';
                selectedIndex = -1;
                break;
        }
    });
    
    function updateSelection() {
        const options = koordinatorDropdown.querySelectorAll('.dropdown-item');
        options.forEach((option, index) => {
            if (index === selectedIndex) {
                option.classList.add('active');
            } else {
                option.classList.remove('active');
            }
        });
    }
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(e) {
        if (!koordinatorSearch.contains(e.target) && !koordinatorDropdown.contains(e.target)) {
            koordinatorDropdown.style.display = 'none';
        }
    });
});
</script>
@endsection

