<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Surat Keputusan Rekomposisi UPA - {{ $rekomposisi->nomor_sk }}</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12pt;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-container {
            margin-bottom: 20px;
        }
        
        .pks-logo-img {
            width: 150px;
            height: 150px;
            margin: 0 auto 10px;
            display: block;
            object-fit: contain;
        }
        
        .pks-text {
            font-size: 18pt;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }
        
        .logo {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .organization {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .address {
            font-size: 10pt;
            margin-bottom: 20px;
        }
        
        .sk-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            margin: 30px 0;
            text-decoration: underline;
        }
        
        .sk-number {
            text-align: center;
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .content {
            text-align: justify;
            margin-bottom: 20px;
        }
        
        .section-title {
            font-weight: bold;
            margin-top: 15px;
            margin-bottom: 5px;
        }
        
        .section-content {
            margin-left: 20px;
            margin-bottom: 10px;
        }
        
        .content-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .content-table td {
            vertical-align: top;
            padding: 8px 12px;
            border: none;
        }
        
        .content-table .section-title {
            font-weight: bold;
            width: 120px;
            text-align: left;
            vertical-align: top;
        }
        
        .content-table .section-content {
            text-align: justify;
            line-height: 1.6;
            margin-left: 0;
            margin-bottom: 0;
        }
        
        .memutuskan-title {
            text-align: center;
            font-weight: bold;
            font-size: 14pt;
            padding: 15px 0;
            border: 2px dashed #333;
            background-color: #f9f9f9;
        }
        
        .decision {
            margin-top: 30px;
        }
        
        .decision-item {
            margin-bottom: 10px;
        }
        
        .signature {
            margin-top: 50px;
            text-align: center;
        }
        
        .signature-name {
            font-weight: bold;
            margin-top: 50px;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 10pt;
        }
        
        .table th,
        .table td {
            border: 1px solid #000;
            padding: 5px;
            text-align: center;
            vertical-align: middle;
        }
        
        .table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .table .text-left {
            text-align: left;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10pt;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <!-- Logo PKS -->
        <div class="logo-container">
            <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('images/logopks.png'))) }}" alt="Logo PKS" class="pks-logo-img">
        </div>
        
        <div class="sk-title">SURAT KEPUTUSAN DEWAN PENGURUS DAERAH</div>
        <div class="organization">PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
        <div class="address">
            Jl. Balai Pustaka No 15 A Rawamangun, Jakarta Timur<br>
            Telp (021) 2247 9675 | https://www.jaktim.pks.id
        </div>
    </div>

    <!-- SK Number -->
    <div class="sk-number">NOMOR : {{ $rekomposisi->nomor_sk }}</div>
    <div class="sk-title">TENTANG</div>
    <div class="sk-title">{{ $rekomposisi->judul_sk }}</div>

    <!-- Content -->
    <div class="content">
        <table class="content-table">
            <tr>
                <td class="section-title">Menimbang :</td>
                <td class="section-content">
                    <strong>a.</strong> {{ $rekomposisi->menimbang_a }}<br>
                    <strong>b.</strong> {{ $rekomposisi->menimbang_b }}<br>
                    <strong>c.</strong> {{ $rekomposisi->menimbang_c }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Mengingat :</td>
                <td class="section-content">
                    <strong>1.</strong> {{ $rekomposisi->mengingat_1 }}<br>
                    <strong>2.</strong> {{ $rekomposisi->mengingat_2 }}<br>
                    <strong>3.</strong> {{ $rekomposisi->mengingat_3 }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Memperhatikan :</td>
                <td class="section-content">
                    Hasil Rapat Bidang Kaderisasi tanggal {{ \Carbon\Carbon::parse($rekomposisi->tanggal_rapat)->format('d F Y') }}
                </td>
            </tr>
            <tr>
                <td colspan="2" class="memutuskan-title">MEMUTUSKAN</td>
            </tr>
            <tr>
                <td class="section-title">Menetapkan :</td>
                <td class="section-content">
                    {{ $rekomposisi->menetapkan }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Pertama :</td>
                <td class="section-content">
                    {{ $rekomposisi->pertama }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Kedua :</td>
                <td class="section-content">
                    {{ $rekomposisi->kedua }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Ketiga :</td>
                <td class="section-content">
                    {{ $rekomposisi->ketiga }}
                </td>
            </tr>
            <tr>
                <td class="section-title">Keempat :</td>
                <td class="section-content">
                    {{ $rekomposisi->keempat }}
                </td>
            </tr>
        </table>
    </div>

    <!-- Signature -->
    <div class="signature">
        <div>Ditetapkan di {{ $rekomposisi->ditetapkan_di ?? 'Jakarta' }}</div>
        <div>Pada tanggal {{ \Carbon\Carbon::parse($rekomposisi->tanggal_sk)->format('d F Y') }}</div>
        
        <div style="margin-top: 30px;">
            <div class="organization">DEWAN PENGURUS DAERAH</div>
            <div class="organization">PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
        </div>
        
        <div class="signature-name">{{ $rekomposisi->ketua_nama }}</div>
    </div>

    <!-- Page Break for Lampiran -->
    <div class="page-break"></div>

    <!-- Lampiran -->
    <div class="header">
        <div class="logo">Lampiran SK Nomor: {{ $rekomposisi->nomor_sk }}</div>
        <div class="sk-title">Tentang: {{ $rekomposisi->judul_sk }}</div>
        <div class="sk-number">Tanggal: {{ $rekomposisi->ditetapkan_tanggal_formatted }}</div>
    </div>

    <!-- Details Table -->
    <table class="table">
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="15%">KODE UPA</th>
                <th width="20%">Pembimbing Baru</th>
                <th width="5%">No</th>
                <th width="20%">Nama Anggota</th>
                <th width="10%">Telp</th>
                <th width="10%">DPRa</th>
                <th width="15%">Pembimbing Lama</th>
                <th width="10%">Ket</th>
            </tr>
        </thead>
        <tbody>
            @php
                $currentUpa = null;
                $rowNumber = 1;
                $upaRowNumber = 1;
            @endphp
            
            @foreach($rekomposisi->details as $detail)
                @if($currentUpa !== $detail->kode_upa)
                    @if($currentUpa !== null)
                        @php $upaRowNumber++; @endphp
                    @endif
                    @php $currentUpa = $detail->kode_upa; @endphp
                    
                    <tr>
                        <td rowspan="{{ $groupedDetails[$detail->kode_upa]->count() }}">{{ $upaRowNumber }}</td>
                        <td rowspan="{{ $groupedDetails[$detail->kode_upa]->count() }}" class="text-left">
                            <strong>{{ $detail->kode_upa_formatted }}</strong>
                        </td>
                        <td rowspan="{{ $groupedDetails[$detail->kode_upa]->count() }}" class="text-left">
                            {{ $detail->pembimbingBaru->nama_lengkap ?? 'N/A' }}
                        </td>
                        <td>{{ $rowNumber }}</td>
                        <td class="text-left">{{ $detail->anggota->nama_lengkap ?? 'N/A' }}</td>
                        <td>{{ $detail->anggota->no_telepon ?? '-' }}</td>
                        <td>{{ $detail->dpr_formatted }}</td>
                        <td class="text-left">
                            @if($detail->pembimbingLama)
                                {{ $detail->pembimbingLama->nama_lengkap }}
                            @else
                                -
                            @endif
                        </td>
                        <td>{{ $detail->keterangan_formatted }}</td>
                    </tr>
                @else
                    <tr>
                        <td>{{ $rowNumber }}</td>
                        <td class="text-left">{{ $detail->anggota->nama_lengkap ?? 'N/A' }}</td>
                        <td>{{ $detail->anggota->no_telepon ?? '-' }}</td>
                        <td>{{ $detail->dpr_formatted }}</td>
                        <td class="text-left">
                            @if($detail->pembimbingLama)
                                {{ $detail->pembimbingLama->nama_lengkap }}
                            @else
                                -
                            @endif
                        </td>
                        <td>{{ $detail->keterangan_formatted }}</td>
                    </tr>
                @endif
                @php $rowNumber++; @endphp
            @endforeach
        </tbody>
    </table>

    <!-- Terlampir -->
    <div style="margin-top: 30px; text-align: center;">
        <div class="section-title">Lampiran SK Nomor: {{ $rekomposisi->nomor_sk_lampiran ?? '036/D/SK/BK/AI-04-PKS/VII/2024' }}</div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="organization">DEWAN PENGURUS DAERAH PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
        <div style="margin-top: 20px;">
            <strong>{{ $rekomposisi->ketua_nama }}</strong>
        </div>
    </div>
</body>
</html>
