{{-- resources/views/surat/penempatan-upa.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Surat Penempatan Anggota ke UPA</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            font-size: 12px; 
            line-height: 1.4; 
            margin: 20px; 
            padding-top: 80px; 
        }
        .header { 
            text-align: left; 
            margin-bottom: 30px; 
        }
        .content { 
            margin-bottom: 30px; 
        }
        .table-data { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        .table-data td { 
            padding: 5px 0px; 
            vertical-align: top; 
        }
        .signature { 
            margin-top: 50px; 
            position: relative; 
        }
        .signature-box { 
            border: 0px solid #000; 
            padding: 15px; 
            text-align: center; 
            width: 250px; 
            margin-left: auto; 
        }
        .signature-image { 
            position: absolute; 
            top: -20px; 
            left: 50%; 
            margin-left: -75px;
            width: 150px; 
            height: 60px; 
            z-index: 10;
        }
        .stamp { 
            position: absolute; 
            top: 10px; 
            right: 10px; 
            width: 100px; 
            height: 100px; 
            opacity: 0.9;
        }
        .tembusan { 
            margin-top: 30px; 
        }
        h1, h2, h3 { 
            margin: 10px 0; 
        }
        .recipient-list {
            margin-bottom: 20px;
        }
        .recipient-item {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    {{-- Header dengan Nomor dan Tanggal --}}
    <div class="header">
        <strong>Nomor</strong> : {{ $nomor_surat }}<br>
        <strong>Jakarta</strong>, {{ $tanggal }}<br><br>
        <strong>Lampiran</strong> : -<br>
        <strong>Perihal</strong> : Penempatan {{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? 'Madya' }}
    </div>

    {{-- Alamat Tujuan --}}
    <div class="recipient-list">
        <strong>Kepada Yth.</strong><br>
        <div class="recipient-item">
            1. <strong>Ketua Bid. Kaderisasi</strong><br>
            &nbsp;&nbsp;&nbsp;&nbsp;<strong>DPC Tujuan</strong>
        </div>
        <div class="recipient-item">
            2. <strong>Ustz. {{ $pembimbing_baru->nama_lengkap }}</strong>
        </div>
        <div class="recipient-item">
            3. <strong>Ustzh. {{ $pembimbing_lama->nama_lengkap ?? 'Ade Sumarni' }}</strong>
        </div>
        <br>
        <strong>di Tempat</strong>
    </div>

    {{-- Salam Pembuka --}}
    <div style="margin-bottom: 20px;">
        <em>Assalaamu'alaikum Wr. Wb.</em>
    </div>

    {{-- Isi Surat --}}
    <div class="content">
        <p>Segala puji hanya bagi Allah SWT. Shalawat dan salam senantiasa tercurahkan kepada Rasulullah Muhammad SAW, keluarganya, para shahabat dan ummatnya yang setia hingga yaumul akhir.</p>
        
        <p>Bersama ini kami sampaikan penempatan Anggota PKS di Unit Pembinaan Anggota DPD Jakarta Timur dengan data sebagai berikut :</p>

        {{-- Data Anggota --}}
        <table class="table-data">
            <tr>
                <td width="25%"><strong>NIA</strong></td>
                <td width="5%">:</td>
                <td>{{ $anggota->nomor_identitas_anggota }}</td>
            </tr>
            <tr>
                <td><strong>Nama Anggota</strong></td>
                <td>:</td>
                <td>{{ $anggota->nama_lengkap }} - No HP: {{ $anggota->no_telepon }}</td>
            </tr>
            <tr>
                <td><strong>Jenjang</strong></td>
                <td>:</td>
                <td><strong>{{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? 'Madya' }}</strong></td>
            </tr>
            <tr>
                <td><strong>Tahun Pelantikan</strong></td>
                <td>:</td>
                <td>{{ \Carbon\Carbon::parse($tahun_pelantikan)->format('d-m-Y') }}</td>
            </tr>
            <tr>
                <td><strong>DPC</strong></td>
                <td>:</td>
                <td>{{ $upa->dpc->nama_dpc ?? 'Cipayung' }}</td>
            </tr>
            <tr>
                <td><strong>Pembimbing Baru</strong></td>
                <td>:</td>
                <td>{{ $pembimbing_baru->nama_lengkap }} - No HP: {{ $pembimbing_baru->no_telepon }}</td>
            </tr>
            <tr>
                <td><strong>Kode UPA</strong></td>
                <td>:</td>
                <td>{{ $upa->kode_upa ?? '' }}</td>
            </tr>
            <tr>
                <td><strong>DPD/DPC Asal</strong></td>
                <td>:</td>
                <td>{{ $anggota->dpc->nama_dpc ?? 'DPC Kramat Jati' }}</td>
            </tr>
            <tr>
                <td><strong>Pembimbing lama</strong></td>
                <td>:</td>
                <td>{{ $pembimbing_lama->nama_lengkap ?? 'ABCD' }} - No HP: {{ $pembimbing_lama->no_telepon ?? '08264654644' }}</td>
            </tr>
            <tr>
                <td><strong>Catatan</strong></td>
                <td>:</td>
                <td>{{ $catatan ?? '' }}</td>
            </tr>
        </table>

        <p>Demikian surat ini disampaikan. Atas kerjasama serta perhatiannya kami ucapkan jazakumullahu khairan katsiron.</p>
        
        <p><em>Wassalaamu'alaikum Wr. Wb.</em></p>
    </div>

    {{-- Tanda Tangan --}}
    <div class="signature">
        {{-- Stempel --}}
        <!--    <img src="{{ public_path('images/stempel.png') }}" alt="Stempel DPD PKS Jakarta Timur" class="stamp">
        -->
        <div class="signature-box" style="border: 0px solid #000;">
            <strong>a.n. Ketua DPD Partai Keadilan Sejahtera</strong><br>
            <strong>Jakarta Timur</strong><br><br><br><br>
            
            {{-- Tanda Tangan Digital --}}
          <div style="margin-right:100px">
            <!--
            <img src="{{ public_path('images/stempel.png') }}" alt="Stempel DPD PKS Jakarta Timur" class="stamp">
    -->  </div>
            <div style="position:absolute; margin-left:100px; margin-top:-30px">
                
                <img src="{{ public_path('images/ttdmutasi.jpg') }}" alt="Tanda Tangan H. Indarmawan" class="signature-image">
           
            </div>
            <h3>{{ $ketua_kaderisasi }}</h3>
            <strong>Ketua Bidang Kaderisasi</strong> 
        </div>
    </div>

    {{-- Tembusan --}}
    <div class="tembusan">
        <strong>Tembusan :</strong>
        <ol>
            <li>Ketua DPD PKS Jakarta Timur</li>
            <li>Bendahara Umum DPD PKS Jakarta Timur</li>
            <li>Arsip</li>
        </ol>
    </div>
</body>
</html>
