{{-- resources/views/surat/mutasi-keluar.blade.php --}}
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Surat Mutasi Anggota Keluar</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; line-height: 1.4; margin: 20px; padding-top: 80px; }
        .header { text-align: left; margin-bottom: 30px; }
        .content { margin-bottom: 30px; }
        .table-data { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .table-data td { padding: 0px; vertical-align: top; }
        .signature { margin-top: 50px; position: relative; }
        .signature-box { border: 0px solid #000; padding: 15px; text-align: center; width: 250px; margin-left: auto; }
        .signature-image { 
            position: absolute; 
            top: -20px; 
            left: 50%; 
            margin-left: -75px;
            width: 150px; 
            height: 60px; 
            z-index: 10;
        }
        .stamp { 
            position: absolute; 
            top: 10px; 
            right: 10px; 
            width: 100px; 
            height: 100px; 
            opacity: 0.9;
        }
        .tembusan { margin-top: 30px; }
        h1, h2, h3 { margin: 10px 0; }
    </style>
</head>
<body>
    {{-- Header dengan Nomor dan Tanggal --}}
    <div class="header">
        <strong>Nomor</strong> : {{ $nomor_surat }}<br>
        <strong>Jakarta</strong>, {{ $tanggal }}<br><br>
        <strong>Lampiran</strong> : -<br>
        <strong>Perihal</strong> : Mutasi Anggota
    </div>

    {{-- Alamat Tujuan --}}
    <div style="margin-bottom: 20px;">
        <strong>Kepada Yth.</strong><br>
        <strong>Ketua DPD Partai Keadilan Sejahtera</strong><br>
        <strong>{{ $dpc_tujuan->nama_struktur ?? 'Jakarta Selatan' }}</strong><br>
        di Tempat
    </div>

    {{-- Salam Pembuka --}}
    <div style="margin-bottom: 20px;">
        <em>Assalaamu'alaikum Wr. Wb.</em>
    </div>

    {{-- Isi Surat --}}
    <div class="content">
        <p>Segala puji hanya milik Allah SWT. Sholawat dan salam senantiasa tercurahkan kepada Rasulullah Muhammad SAW, keluarganya, para sahabatnya, dan umatnya yang setia hingga yaumul akhir.</p>
        
        <p>Bersama ini kami sampaikan mutasi anggota ke wilayah Saudara dengan data sebagai berikut :</p>

        {{-- Data Anggota --}}
        <table class="table-data">
            <tr>
                <td width="20%"><strong>Nama</strong></td>
                <td width="5%">:</td>
                <td>{{ $anggota->nama_lengkap }}</td>
            </tr>
            <tr>
                <td><strong>Alamat Tujuan</strong></td>
                <td>:</td>
                <td>{{ $mutasi->alamat_tujuan }}</td>
            </tr>
            
            <tr>
                <td><strong>Telepon</strong></td>
                <td>:</td>
                <td>{{ $anggota->no_telepon }}</td>
            </tr>
            <tr>
                <td><strong>Tempat, Tgl Lahir</strong></td>
                <td>:</td>
                <td>{{ $anggota->tempat_lahir }}, {{ \Carbon\Carbon::parse($anggota->tanggal_lahir)->format('d F Y') }}</td>
            </tr>
            <tr>
                <td><strong>Jenjang</strong></td>
                <td>:</td>
                <td><strong>{{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota }} ({{ \Carbon\Carbon::parse($anggota->tanggal_lahir)->age }} Tahun)</strong></td>
            </tr>
            <tr>
                <td><strong>Pendidikan</strong></td>
                <td>:</td>
                <td>{{ $anggota->pendidikan ?? 'S1' }}</td>
            </tr>
            <tr>
                <td><strong>Pembimbing</strong></td>
                <td>:</td>
                <td>{{ $anggota->pembimbing_nama ?? 'XYZ' }} / {{ $anggota->pembimbing_telepon ?? '08015648523' }}</td>
            </tr>
            <tr>
                <td><strong>Alasan Pindah</strong></td>
                <td>:</td>
                <td>{{ $mutasi->alasan_mutasi }}</td>
            </tr>
            <tr>
                <td><strong>Catatan</strong></td>
                <td>:</td>
                <td>{{ $mutasi->catatan ?? '' }}</td>
            </tr>
        </table>

        <p>Mohon agar segera diterima dan diproses penempatannya sesuai dengan hak dan kewajibannya di wilayah Saudara.</p>
        
        <p>Demikian surat ini disampaikan. Atas perhatiannya kami ucapkan jazakumullahu khoiron katsiron.</p>
        
        <p><em>Wassalaamu'alaikum Wr. Wb.</em></p>
    </div>

    {{-- Tanda Tangan --}}
    <div class="signature">
        {{-- Stempel --}}
    <!--    <img src="{{ public_path('images/stempel.png') }}" alt="Stempel DPD PKS Jakarta Timur" class="stamp">
    -->
        <div class="signature-box" style="border: 0px solid #000;">
            <strong>a.n. Ketua DPD Partai Keadilan Sejahtera</strong><br>
            <strong>Jakarta Timur</strong><br><br><br><br>
            
            {{-- Tanda Tangan Digital --}}
          <div style="margin-right:100px">
            <!--
            <img src="{{ public_path('images/stempel.png') }}" alt="Stempel DPD PKS Jakarta Timur" class="stamp">
    -->  </div>
            <div style="position:absolute; margin-left:100px; margin-top:-30px">
                
                <img src="{{ public_path('images/ttdmutasi.jpg') }}" alt="Tanda Tangan H. Indarmawan" class="signature-image">
           
            </div>
            <h3>{{ $ketua_kaderisasi }}</h3>
            <strong>Ketua Bidang Kaderisasi</strong> 
        </div>
    </div>

    {{-- Tembusan --}}
    <div class="tembusan">
        <strong>Tembusan :</strong>
        <ol>
            <li>Ketua DPD PKS Jakarta Timur</li>
            <li>Arsip</li>
        </ol>
    </div>
</body>
</html>