@extends('layouts.app')

@section('title', 'Detail Surat Penempatan UPA')

@section('content')
<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-file-alt text-primary me-2"></i>Detail Surat Penempatan UPA
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Detail surat penempatan anggota ke Unit Pembinaan Anggota
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('surat-penempatan.index') }}" class="btn btn-outline-secondary px-3" style="border-radius: 6px;">
            <i class="fas fa-arrow-left me-1"></i>Kembali
        </a>
        <a href="{{ route('surat-penempatan.print', $riwayat->id) }}" class="btn btn-success px-3" style="border-radius: 6px;">
            <i class="fas fa-print me-1"></i>Print Surat
        </a>
    </div>
</div>

<!-- Success/Error Messages -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="row">
    <!-- Informasi Surat -->
    <div class="col-md-8 mb-4">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-primary py-3">
                <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-info-circle me-2"></i>Informasi Surat Penempatan
                </h6>
            </div>
            <div class="card-body p-4">
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label fw-semibold text-dark">
                                <i class="fas fa-hashtag me-1 text-primary"></i>Nomor Surat
                            </label>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                <strong>{{ $riwayat->nomor_surat }}</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label fw-semibold text-dark">
                                <i class="fas fa-calendar me-1 text-primary"></i>Tanggal Efektif
                            </label>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->tanggal_efektif ? $riwayat->tanggal_efektif->format('d F Y') : '-' }}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label fw-semibold text-dark">
                                <i class="fas fa-calendar-alt me-1 text-primary"></i>Tahun Pelantikan
                            </label>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->tahun_pelantikan ? \Carbon\Carbon::parse($riwayat->tahun_pelantikan)->format('d F Y') : '-' }}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label fw-semibold text-dark">
                                <i class="fas fa-tag me-1 text-primary"></i>Status
                            </label>
                            <div class="form-control-plaintext">
                                <span class="badge bg-{{ $riwayat->status == 'completed' ? 'success' : ($riwayat->status == 'pending' ? 'warning' : 'secondary') }} fs-6">
                                    {{ ucfirst($riwayat->status) }}
                                </span>
                            </div>
                        </div>
                    </div>
                    @if($riwayat->catatan)
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-semibold text-dark">
                                <i class="fas fa-sticky-note me-1 text-primary"></i>Catatan
                            </label>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->catatan }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Informasi Anggota -->
    <div class="col-md-4 mb-4">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-success py-3">
                <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-user me-2"></i>Informasi Anggota
                </h6>
            </div>
            <div class="card-body p-4">
                <div class="text-center mb-3">
                    @if($riwayat->anggota->foto && file_exists(public_path('storage/' . $riwayat->anggota->foto)))
                        <img src="{{ url('storage/' . $riwayat->anggota->foto) }}?v={{ $riwayat->anggota->updated_at ? $riwayat->anggota->updated_at->timestamp : time() }}" 
                             alt="Foto {{ $riwayat->anggota->nama_lengkap }}"
                             class="rounded-circle mb-3" 
                             style="width: 80px; height: 80px; object-fit: cover; border: 3px solid #28a745;">
                    @else
                        <div class="rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                             style="width: 80px; height: 80px; background: linear-gradient(135deg, #28a745, #20c997);">
                            <i class="fas fa-user fa-2x text-white"></i>
                        </div>
                    @endif
                </div>
                
                <h6 class="text-primary mb-1">{{ $riwayat->anggota->nama_lengkap }}</h6>
                <p class="text-muted mb-2">{{ $riwayat->anggota->nomor_identitas_anggota }}</p>
                
                <div class="mb-2">
                    <span class="badge bg-{{ $riwayat->anggota->status_keanggotaan == 'Aktif' ? 'success' : 'warning' }} p-2">
                        {{ $riwayat->anggota->status_keanggotaan }}
                    </span>
                </div>
                
                <div class="small text-muted">
                    <div><strong>Jenjang:</strong> {{ $riwayat->anggota->refJenjang->jenjang ?? $riwayat->anggota->jenjang_anggota }}</div>
                    <div><strong>DPC:</strong> {{ $riwayat->anggota->dpc->nama_dpc ?? '-' }}</div>
                    <div><strong>UPA:</strong> {{ $riwayat->anggota->upa->nama_upa ?? '-' }}</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Detail Perpindahan -->
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-info py-3">
                <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-exchange-alt me-2"></i>Detail Perpindahan
                </h6>
            </div>
            <div class="card-body p-4">
                <div class="row">
                    <!-- Dari -->
                    <div class="col-md-6">
                        <div class="card border-warning">
                            <div class="card-header bg-warning text-dark">
                                <h6 class="m-0 fw-bold">
                                    <i class="fas fa-arrow-left me-2"></i>Dari
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong class="text-primary">DPC:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->dpcAsal->nama_dpc ?? '-' }}
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <strong class="text-primary">UPA:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->upaAsal->nama_upa ?? '-' }}
                                    </div>
                                </div>
                                @if($riwayat->pembimbingLama)
                                <div class="mb-3">
                                    <strong class="text-primary">Pembimbing Lama:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->pembimbingLama->nama_lengkap }}
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Ke -->
                    <div class="col-md-6">
                        <div class="card border-success">
                            <div class="card-header bg-success text-white">
                                <h6 class="m-0 fw-bold">
                                    <i class="fas fa-arrow-right me-2"></i>Ke
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong class="text-primary">DPC:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->dpcTujuan->nama_dpc ?? '-' }}
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <strong class="text-primary">UPA:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->upaTujuan->nama_upa ?? '-' }}
                                    </div>
                                </div>
                                @if($riwayat->pembimbingBaru)
                                <div class="mb-3">
                                    <strong class="text-primary">Pembimbing Baru:</strong>
                                    <div class="form-control-plaintext bg-light p-2 rounded">
                                        {{ $riwayat->pembimbingBaru->nama_lengkap }}
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Informasi Sistem -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-secondary py-3">
                <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-cogs me-2"></i>Informasi Sistem
                </h6>
            </div>
            <div class="card-body p-4">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <strong class="text-primary">Dibuat oleh:</strong>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->creator->name ?? 'System' }}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <strong class="text-primary">Disetujui oleh:</strong>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->approver->name ?? 'System' }}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <strong class="text-primary">Tanggal Dibuat:</strong>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->created_at->format('d F Y H:i:s') }}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <strong class="text-primary">Tanggal Disetujui:</strong>
                            <div class="form-control-plaintext bg-light p-2 rounded">
                                {{ $riwayat->approved_at ? $riwayat->approved_at->format('d F Y H:i:s') : '-' }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
