@extends('layouts.app')

@section('title', 'Surat Penempatan UPA')

@section('content')
<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-file-alt text-primary me-2"></i>Surat Penempatan UPA
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola surat penempatan anggota ke Unit Pembinaan Anggota
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('surat-penempatan.create') }}" class="btn btn-primary px-3" style="border-radius: 6px;">
            <i class="fas fa-plus me-1"></i>Buat Surat Penempatan
        </a>
    </div>
</div>

<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('surat-penempatan.index') }}" id="filterForm">
            <!-- Row 1: Pencarian, DPC, UPA, Jenjang -->
            <div class="row g-2 mb-3">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-search me-1 text-primary"></i>Pencarian
                    </label>
                    <input type="text" class="form-control" name="search" 
                           value="{{ request('search') }}" 
                           placeholder="Nama atau NIA..."
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-users me-1 text-primary"></i>DPC
                    </label>
                    <select class="form-select" name="dpc_id" style="border-radius: 6px;">
                        <option value="">Semua DPC</option>
                        @foreach($dpcList as $dpc)
                            <option value="{{ $dpc->dpc_id }}" {{ request('dpc_id') == $dpc->dpc_id ? 'selected' : '' }}>
                                {{ $dpc->nama_dpc }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-building me-1 text-primary"></i>UPA
                    </label>
                    <select class="form-select" name="upa_id" style="border-radius: 6px;">
                        <option value="">Semua UPA</option>
                        @foreach($upaList as $upa)
                            <option value="{{ $upa->upa_id }}" {{ request('upa_id') == $upa->upa_id ? 'selected' : '' }}>
                                {{ $upa->nama_upa }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-layer-group me-1 text-primary"></i>Jenjang
                    </label>
                    <select class="form-select" name="jenjang_id" style="border-radius: 6px;">
                        <option value="">Semua Jenjang</option>
                        @foreach($jenjangList as $jenjang)
                            <option value="{{ $jenjang->ref_jenjang_id }}" {{ request('jenjang_id') == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                {{ $jenjang->jenjang }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="d-flex justify-content-end gap-2">
                <button type="submit" class="btn btn-primary px-4" style="border-radius: 6px;">
                    <i class="fas fa-search me-1"></i>Cari Data
                </button>
                <a href="{{ route('surat-penempatan.index') }}" class="btn btn-outline-secondary px-4" style="border-radius: 6px;">
                    <i class="fas fa-undo me-1"></i>Reset
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow-sm border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-list me-2"></i>Daftar Anggota
            <span class="ms-auto">
                <i class="fas fa-users me-1"></i>Total: {{ $anggotas->total() }} anggota
            </span>
        </h6>
    </div>
    <div class="card-body p-0">

        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th class="border-0 py-3 px-4">No</th>
                        <th class="border-0 py-3 px-4">NIA</th>
                        <th class="border-0 py-3 px-4">Nama Lengkap</th>
                        <th class="border-0 py-3 px-4">Jenjang</th>
                        <th class="border-0 py-3 px-4">DPC</th>
                        <th class="border-0 py-3 px-4">UPA</th>
                        <th class="border-0 py-3 px-4">Status</th>
                        <th class="border-0 py-3 px-4 text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($anggotas as $anggota)
                        <tr>
                            <td class="py-3 px-4">{{ $anggotas->firstItem() + $loop->index }}</td>
                            <td class="py-3 px-4">
                                <span class="fw-semibold text-dark">{{ $anggota->nomor_identitas_anggota }}</span>
                            </td>
                            <td class="py-3 px-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 32px; height: 32px;">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <div>
                                        <div class="fw-semibold">
                                            <a href="{{ route('anggota.show', $anggota) }}" class="text-decoration-none text-primary">
                                                {{ $anggota->nama_lengkap }}
                                            </a>
                                        </div>
                                        <small class="text-muted">{{ $anggota->email ?? 'N/A' }}</small>
                                    </div>
                                </div>
                            </td>
                            <td class="py-3 px-4">
                                <span class="text-dark">
                                    {{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? 'N/A' }}
                                </span>
                            </td>
                            <td class="py-3 px-4">{{ $anggota->dpc->nama_dpc ?? 'N/A' }}</td>
                            <td class="py-3 px-4">
                                @if($anggota->upa)
                                    <span class="text-success">{{ $anggota->upa->nama_upa }}</span>
                                @else
                                    <span class="text-muted">Belum ditempatkan</span>
                                @endif
                            </td>
                            <td class="py-3 px-4">
                                <span class="text-dark">
                                    {{ $anggota->status_keanggotaan }}
                                </span>
                            </td>
                            <td class="py-3 px-4 text-center">
                                <a href="{{ route('surat-penempatan.create', ['anggota_id' => $anggota->id]) }}" 
                                   class="btn btn-primary btn-sm" style="border-radius: 6px;" title="Buat Surat Penempatan">
                                    <i class="fas fa-file-alt me-1"></i>Buat Surat
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <div class="text-muted">
                                    <i class="fas fa-inbox fa-2x mb-3"></i>
                                    <p class="mb-0">Tidak ada data anggota</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($anggotas->hasPages())
            <div class="card-footer bg-light py-3">
                <div class="d-flex justify-content-center">
                    {{ $anggotas->appends(request()->query())->links() }}
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-submit form when DPC changes
    $('#dpc_id').change(function() {
        // Clear UPA options
        $('#upa_id').html('<option value="">Semua UPA</option>');
        
        // Load UPA by DPC
        if ($(this).val()) {
            $.get('/api/upa-by-dpc/' + $(this).val(), function(data) {
                $.each(data, function(index, upa) {
                    $('#upa_id').append('<option value="' + upa.upa_id + '">' + upa.nama_upa + '</option>');
                });
            });
        }
    });
});
</script>
@endpush
