@extends('layouts.app')

@section('title', 'Buat Surat Penempatan UPA')

@section('content')
<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-file-alt text-primary me-2"></i>Buat Surat Penempatan UPA
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Buat surat penempatan anggota ke Unit Pembinaan Anggota
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('surat-penempatan.index') }}" class="btn btn-outline-secondary px-3" style="border-radius: 6px;">
            <i class="fas fa-arrow-left me-1"></i>Kembali
        </a>
    </div>
</div>

<!-- Form Card -->
<div class="card shadow-sm border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-plus me-2"></i>Form Buat Surat Penempatan
        </h6>
    </div>
    <div class="card-body p-4">
        <form id="penempatanForm" method="POST" action="{{ route('surat-penempatan.generate') }}">
            @csrf
            
            <div class="row g-3 mb-4">
                {{-- DPC Asal --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-map-marker-alt me-1 text-primary"></i>DPC Asal <span class="text-danger">*</span>
                    </label>
                    <select name="dpc_asal" id="dpc_asal" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih DPC Asal --</option>
                        @foreach($dpcList as $dpc)
                            <option value="{{ $dpc->dpc_id }}">{{ $dpc->nama_dpc }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- UPA Asal --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-building me-1 text-primary"></i>UPA Asal <span class="text-danger">*</span>
                    </label>
                    <select name="upa_asal_id" id="upa_asal_id" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih UPA Asal --</option>
                        @foreach($upaList as $upa)
                            <option value="{{ $upa->upa_id }}" data-dpc="{{ $upa->dpc_id }}">
                                {{ $upa->nama_upa }} ({{ $upa->kode_upa }})
                            </option>
                        @endforeach
                    </select>
                    @error('upa_asal_id')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row g-3 mb-4">
                {{-- Pilih Anggota --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-user me-1 text-primary"></i>Pilih Anggota <span class="text-danger">*</span>
                    </label>
                    <select name="anggota_id" id="anggota_id" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih Anggota --</option>
                        @foreach($anggotas as $anggota)
                            <option value="{{ $anggota->id }}" 
                                    {{ request('anggota_id') == $anggota->id ? 'selected' : '' }}
                                    data-dpc="{{ $anggota->dpc_id }}"
                                    data-upa="{{ $anggota->upa_id }}"
                                    data-jenjang="{{ $anggota->refJenjang->jenjang ?? $anggota->jenjang_anggota ?? 'Madya' }}">
                                {{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})
                            </option>
                        @endforeach
                    </select>
                    @error('anggota_id')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>

                {{-- Pembimbing Lama --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-user-friends me-1 text-success"></i>Pembimbing Lama
                    </label>
                    <select name="pembimbing_lama_id" id="pembimbing_lama_id" class="form-select" style="border-radius: 6px;">
                        <option value="">-- Pilih Pembimbing Lama --</option>
                    </select>
                    <input type="hidden" id="pembimbing_lama_id_hidden" name="pembimbing_lama_id">
                    @error('pembimbing_lama_id')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row g-3 mb-4">
                {{-- DPC Tujuan --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-map-marker-alt me-1 text-primary"></i>DPC Tujuan <span class="text-danger">*</span>
                    </label>
                    <select name="dpc_tujuan" id="dpc_tujuan" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih DPC Tujuan --</option>
                        @foreach($dpcList as $dpc)
                            <option value="{{ $dpc->dpc_id }}">{{ $dpc->nama_dpc }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- UPA Tujuan --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-building me-1 text-primary"></i>UPA Tujuan <span class="text-danger">*</span>
                    </label>
                    <select name="upa_id" id="upa_id" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih UPA Tujuan --</option>
                        @foreach($upaList as $upa)
                            <option value="{{ $upa->upa_id }}" data-dpc="{{ $upa->dpc_id }}">
                                {{ $upa->nama_upa }} ({{ $upa->kode_upa }})
                            </option>
                        @endforeach
                    </select>
                    @error('upa_id')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row g-3 mb-4">
                {{-- Pembimbing Baru --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-user-tie me-1 text-primary"></i>Pembimbing Baru <span class="text-danger">*</span>
                    </label>
                    <select name="pembimbing_baru_id" id="pembimbing_baru_id" class="form-select" style="border-radius: 6px;" required>
                        <option value="">-- Pilih Pembimbing Baru --</option>
                    </select>
                    <input type="hidden" id="pembimbing_baru_id_hidden" name="pembimbing_baru_id">
                    @error('pembimbing_baru_id')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row g-3 mb-4">
                {{-- Tahun Pelantikan --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-calendar me-1 text-primary"></i>Tahun Pelantikan <span class="text-danger">*</span>
                    </label>
                    <input type="date" name="tahun_pelantikan" id="tahun_pelantikan" 
                           class="form-control" style="border-radius: 6px;"
                           value="{{ old('tahun_pelantikan', now()->format('Y-m-d')) }}" required>
                    @error('tahun_pelantikan')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>

                {{-- Catatan --}}
                <div class="col-lg-6 col-md-12">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-sticky-note me-1 text-primary"></i>Catatan
                    </label>
                    <textarea name="catatan" id="catatan" class="form-control" rows="3" 
                              style="border-radius: 6px;"
                              placeholder="Catatan tambahan (opsional)">{{ old('catatan') }}</textarea>
                    @error('catatan')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            {{-- Preview Data --}}
            <div id="previewData" class="card mt-4" style="display: none;">
                <div class="card-header bg-light">
                    <h6 class="m-0 fw-semibold text-dark d-flex align-items-center">
                        <i class="fas fa-eye me-2"></i>Preview Data Surat
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong class="text-primary">Anggota:</strong> <span id="previewAnggota" class="text-dark"></span>
                            </div>
                            <div class="mb-3">
                                <strong class="text-primary">NIA:</strong> <span id="previewNIA" class="text-dark"></span>
                            </div>
                            <div class="mb-3">
                                <strong class="text-primary">Jenjang:</strong> <span id="previewJenjang" class="text-dark"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong class="text-primary">UPA Tujuan:</strong> <span id="previewUPA" class="text-dark"></span>
                            </div>
                            <div class="mb-3">
                                <strong class="text-primary">Pembimbing Baru:</strong> <span id="previewPembimbingBaru" class="text-dark"></span>
                            </div>
                            <div class="mb-3">
                                <strong class="text-primary">Pembimbing Lama:</strong> <span id="previewPembimbingLama" class="text-dark"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Action Buttons --}}
            <div class="d-flex justify-content-end gap-3 mt-4">
                <button type="submit" class="btn btn-primary px-4" id="generateBtn" style="border-radius: 6px;">
                    <i class="fas fa-eye me-1"></i>Preview Surat
                </button>
                <button type="button" class="btn btn-success px-4" id="generatePdfBtn" style="display: none; border-radius: 6px;">
                    <i class="fas fa-file-pdf me-1"></i>Generate PDF
                </button>
                <button type="button" class="btn btn-warning px-4" id="transferBtn" style="display: none; border-radius: 6px;">
                    <i class="fas fa-exchange-alt me-1"></i>Transfer Anggota
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Step 1: DPC Asal dipilih - filter UPA Asal
    $('#dpc_asal').change(function() {
        const dpcId = $(this).val();
        
        // Filter UPA Asal berdasarkan DPC
        $('#upa_asal_id option').each(function() {
            if ($(this).val() === '') {
                $(this).show();
            } else if (!dpcId || $(this).data('dpc') == dpcId) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
        
        // Reset selections
        $('#upa_asal_id').val('');
        $('#anggota_id').val('');
        $('#pembimbing_lama_id').html('<option value="">-- Pembimbing Lama (Otomatis) --</option>');
        $('#pembimbing_lama_id_hidden').val('');
        updatePreview();
    });

    // Step 2: UPA Asal dipilih - filter Anggota dan load Pembimbing Lama
    $('#upa_asal_id').change(function() {
        const upaAsalId = $(this).val();
        
        if (upaAsalId) {
            // Filter anggota berdasarkan UPA Asal
            $('#anggota_id option').each(function() {
                if ($(this).val() === '') {
                    $(this).show();
                } else if ($(this).data('upa') == upaAsalId) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
            
            // Load pembimbing lama dari UPA asal
            $.get('{{ route("surat-penempatan.pembimbing-by-upa") }}', { upa_id: upaAsalId }, function(data) {
                let options = '<option value="">-- Pilih Pembimbing Lama --</option>';
                
                $.each(data, function(index, pembimbing) {
                    // Format: Nama - Jabatan (NIA)
                    const optionText = pembimbing.nama_lengkap + ' - ' + pembimbing.jabatan + ' (' + pembimbing.nomor_identitas_anggota + ')';
                    options += '<option value="' + pembimbing.id + '" data-jabatan="' + pembimbing.jabatan + '">' + optionText + '</option>';
                });
                
                $('#pembimbing_lama_id').html(options);
                $('#pembimbing_lama_id').prop('disabled', false);
                $('#pembimbing_lama_id').css('background-color', '');
                
                // Auto-select pembimbing pertama
                if (data.length > 0) {
                    $('#pembimbing_lama_id').val(data[0].id);
                    $('#pembimbing_lama_id_hidden').val(data[0].id);
                }
                
                updatePreview();
            }).fail(function() {
                console.log('Tidak dapat load pembimbing lama');
            });
        } else {
            // Reset
            $('#anggota_id option').show();
            $('#pembimbing_lama_id').html('<option value="">-- Pembimbing Lama (Otomatis) --</option>');
            $('#pembimbing_lama_id_hidden').val('');
        }
        
        // Reset anggota selection
        $('#anggota_id').val('');
        updatePreview();
    });

    // Step 3: Anggota dipilih - set default DPC Tujuan sama dengan DPC Asal
    $('#anggota_id').change(function() {
        const anggotaId = $(this).val();
        
        if (anggotaId) {
            // Set DPC tujuan default sama dengan DPC asal
            const dpcAsalId = $('#dpc_asal').val();
            if (dpcAsalId && !$('#dpc_tujuan').val()) {
                $('#dpc_tujuan').val(dpcAsalId).trigger('change');
            }
        }
        
        updatePreview();
    });

    // Step 4: DPC Tujuan dipilih - filter UPA Tujuan
    $('#dpc_tujuan').change(function() {
        const dpcId = $(this).val();
        
        // Filter UPA Tujuan berdasarkan DPC
        $('#upa_id option').each(function() {
            if ($(this).val() === '') {
                $(this).show();
            } else if (!dpcId || $(this).data('dpc') == dpcId) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
        
        // Reset selections
        $('#upa_id').val('');
        $('#pembimbing_baru_id').html('<option value="">-- Pembimbing Baru (Otomatis) --</option>');
        $('#pembimbing_baru_id_hidden').val('');
        updatePreview();
    });

    // Step 5: UPA Tujuan dipilih - load Pembimbing Baru
    $('#upa_id').change(function() {
        const upaId = $(this).val();
        
        if (upaId) {
            // Load pembimbing baru dari UPA tujuan
            $.get('{{ route("surat-penempatan.pembimbing-by-upa") }}', { upa_id: upaId }, function(data) {
                let options = '<option value="">-- Pilih Pembimbing Baru --</option>';
                
                $.each(data, function(index, pembimbing) {
                    // Format: Nama - Jabatan (NIA)
                    const optionText = pembimbing.nama_lengkap + ' - ' + pembimbing.jabatan + ' (' + pembimbing.nomor_identitas_anggota + ')';
                    options += '<option value="' + pembimbing.id + '" data-jabatan="' + pembimbing.jabatan + '">' + optionText + '</option>';
                });
                
                $('#pembimbing_baru_id').html(options);
                $('#pembimbing_baru_id').prop('disabled', false);
                $('#pembimbing_baru_id').css('background-color', '');
                
                // Auto-select pembimbing pertama
                if (data.length > 0) {
                    $('#pembimbing_baru_id').val(data[0].id);
                    $('#pembimbing_baru_id_hidden').val(data[0].id);
                }
                
                updatePreview();
            }).fail(function() {
                console.log('Tidak dapat load pembimbing baru');
            });
        } else {
            $('#pembimbing_baru_id').html('<option value="">-- Pilih Pembimbing Baru --</option>');
            $('#pembimbing_baru_id_hidden').val('');
        }
        
        updatePreview();
    });

    // Update hidden values when selects change
    $('#pembimbing_lama_id').change(function() {
        $('#pembimbing_lama_id_hidden').val($(this).val());
        updatePreview();
    });

    $('#pembimbing_baru_id').change(function() {
        $('#pembimbing_baru_id_hidden').val($(this).val());
        updatePreview();
    });

    // Update preview when any field changes
    $('#tahun_pelantikan').change(function() {
        updatePreview();
    });

    function updatePreview() {
        const anggotaId = $('#anggota_id').val();
        const upaId = $('#upa_id').val();
        const pembimbingBaruId = $('#pembimbing_baru_id_hidden').val() || $('#pembimbing_baru_id').val();
        
        if (anggotaId && upaId && pembimbingBaruId) {
            // Show preview
            $('#previewData').slideDown();
            $('#generatePdfBtn').show();
            $('#transferBtn').show();
            
            // Update preview data
            const selectedAnggota = $('#anggota_id option:selected').text();
            const selectedUPA = $('#upa_id option:selected').text();
            const selectedPembimbingBaru = $('#pembimbing_baru_id option:selected').text();
            const selectedPembimbingLama = $('#pembimbing_lama_id option:selected').text();
            
            $('#previewAnggota').text(selectedAnggota);
            const niaMatch = $('#anggota_id option:selected').text().match(/\(([^)]+)\)/);
            $('#previewNIA').text(niaMatch ? niaMatch[1] : '-');
            $('#previewJenjang').text($('#anggota_id option:selected').data('jenjang'));
            $('#previewUPA').text(selectedUPA);
            $('#previewPembimbingBaru').text(selectedPembimbingBaru);
            $('#previewPembimbingLama').text(selectedPembimbingLama || 'Tidak ada');
        } else {
            $('#previewData').slideUp();
            $('#generatePdfBtn').hide();
            $('#transferBtn').hide();
        }
    }

    // Before submit
    $('#penempatanForm').submit(function(e) {
        if ($(this).attr('action').includes('generate-pdf')) {
            return true; // Allow PDF generation
        }
        
        e.preventDefault();
        
        // Change action to preview
        $(this).attr('action', '{{ route("surat-penempatan.generate") }}');
        $(this).attr('target', '_blank');
        $(this).off('submit').submit();
    });

    // Handle form submission for PDF generation
    $('#generatePdfBtn').click(function() {
        const form = $('#penempatanForm');
        
        form.attr('action', '{{ route("surat-penempatan.generate-pdf") }}');
        form.attr('target', '');
        form.off('submit').submit();
    });

    // Handle transfer anggota
    $('#transferBtn').click(function() {
        if (!confirm('Apakah Anda yakin ingin memindahkan anggota ini? Tindakan ini akan mengupdate database dan tidak dapat dibatalkan.')) {
            return;
        }

        const formData = {
            anggota_id: $('#anggota_id').val(),
            dpc_asal_id: $('#dpc_asal').val(),
            upa_asal_id: $('#upa_asal_id').val(),
            dpc_tujuan_id: $('#dpc_tujuan').val(),
            upa_tujuan_id: $('#upa_id').val(),
            pembimbing_baru_id: $('#pembimbing_baru_id_hidden').val() || $('#pembimbing_baru_id').val(),
            pembimbing_lama_id: $('#pembimbing_lama_id_hidden').val() || $('#pembimbing_lama_id').val(),
            tahun_pelantikan: $('#tahun_pelantikan').val(),
            catatan: $('#catatan').val(),
            _token: $('meta[name="csrf-token"]').attr('content')
        };

        // Show loading
        $(this).prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i>Memproses...');

        $.ajax({
            url: '{{ route("surat-penempatan.transfer") }}',
            method: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    // Show success message
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 3000
                    }).then(() => {
                        // Redirect to surat penempatan detail
                        window.location.href = response.data.redirect_url;
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal!',
                        text: response.message
                    });
                }
            },
            error: function(xhr) {
                let errorMessage = 'Terjadi kesalahan saat memindahkan anggota.';
                
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                    const errors = Object.values(xhr.responseJSON.errors).flat();
                    errorMessage = errors.join('<br>');
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Gagal!',
                    html: errorMessage
                });
            },
            complete: function() {
                // Reset button
                $('#transferBtn').prop('disabled', false).html('<i class="fas fa-exchange-alt me-1"></i>Transfer Anggota');
            }
        });
    });

    // Auto-select anggota if passed via URL
    @if(request('anggota_id'))
        const anggotaData = $('#anggota_id option[value="{{ request("anggota_id") }}"]');
        if (anggotaData.length) {
            const dpcId = anggotaData.data('dpc');
            const upaId = anggotaData.data('upa');
            
            if (dpcId) {
                $('#dpc_asal').val(dpcId).trigger('change');
                setTimeout(function() {
                    if (upaId) {
                        $('#upa_asal_id').val(upaId).trigger('change');
                        setTimeout(function() {
                            $('#anggota_id').val('{{ request("anggota_id") }}').trigger('change');
                        }, 100);
                    }
                }, 100);
            }
        }
    @endif
});
</script>
@endpush
