@extends('layouts.app')

@section('title', 'Statistik Takwim - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Takwim</h1>
        <p class="text-muted">Analisis data takwim PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.takwim') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ request('tanggal_mulai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ request('tanggal_selesai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="status_takwim" class="form-label">Status Takwim</label>
                        <select class="form-select" id="status_takwim" name="status_takwim">
                            <option value="">Semua Status</option>
                            <option value="Aktif" {{ request('status_takwim') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="Selesai" {{ request('status_takwim') == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                            <option value="Dibatalkan" {{ request('status_takwim') == 'Dibatalkan' ? 'selected' : '' }}>Dibatalkan</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="struktur_penyelenggara_id" class="form-label">Penyelenggara</label>
                        <select class="form-select" id="struktur_penyelenggara_id" name="struktur_penyelenggara_id">
                            <option value="">Semua Penyelenggara</option>
                            @foreach($strukturOrganisasi as $struktur)
                                <option value="{{ $struktur->id }}" 
                                        {{ request('struktur_penyelenggara_id') == $struktur->id ? 'selected' : '' }}>
                                    {{ $struktur->nama_struktur }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i> Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistik Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Takwim
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-project-diagram fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Aktif
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['aktif']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-play-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Selesai
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['selesai']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-danger shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Dibatalkan
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['dibatalkan']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-xl-6 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Total Peserta
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total_peserta']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-md-6 mb-4">
        <div class="card border-left-secondary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Rata-rata Peserta
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['rata_rata_peserta'], 1) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Status</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="takwimPerStatusChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Penyelenggara</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="takwimPerStrukturChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-info">Takwim per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="takwimPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-warning">Distribusi per Durasi</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="takwimPerDurasiChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Takwim
        </h6>
    </div>
    <div class="card-body">
        @if($takwim->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Nama Takwim</th>
                        <th width="15%">Penyelenggara</th>
                        <th width="15%">Koordinator</th>
                        <th width="12%">Tanggal Mulai</th>
                        <th width="12%">Tanggal Selesai</th>
                        <th width="8%">Status</th>
                        <th width="8%">Peserta</th>
                        <th width="5%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($takwim as $index => $item)
                    <tr>
                        <td>{{ $takwim->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $item->nama_takwim }}</strong>
                            @if($item->deskripsi)
                            <br><small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                            @endif
                        </td>
                        <td>{{ $item->strukturPenyelenggara->nama_struktur ?? '-' }}</td>
                        <td>{{ $item->koordinator }}</td>
                        <td>{{ $item->tanggal_mulai ? $item->tanggal_mulai->format('d/m/Y') : '-' }}</td>
                        <td>{{ $item->tanggal_selesai ? $item->tanggal_selesai->format('d/m/Y') : '-' }}</td>
                        <td>
                            @php
                                $statusClass = match($item->status_takwim) {
                                    'Aktif' => 'success',
                                    'Selesai' => 'info',
                                    'Dibatalkan' => 'danger',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $statusClass }}">{{ $item->status_takwim }}</span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-primary">{{ $item->pesertaTakwim->where('tanggal_keluar', null)->count() }}</span>
                        </td>
                        <td>
                            <a href="{{ route('takwim.show', $item) }}" class="btn btn-sm btn-info" title="Lihat Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                <small class="text-muted">
                    Menampilkan {{ $takwim->firstItem() }} sampai {{ $takwim->lastItem() }} 
                    dari {{ $takwim->total() }} data
                </small>
            </div>
            <div>
                {{ $takwim->appends(request()->query())->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-project-diagram fa-5x text-muted mb-3"></i>
            <h5 class="text-muted">Tidak Ada Data Takwim</h5>
            <p class="text-muted">Tidak ada data takwim yang sesuai dengan filter yang dipilih</p>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Takwim per Status Chart
const takwimPerStatusCtx = document.getElementById('takwimPerStatusChart').getContext('2d');
const takwimPerStatusChart = new Chart(takwimPerStatusCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_status']->pluck('status_takwim')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_status']->pluck('total')) !!},
            backgroundColor: ['rgba(255, 87, 34, 1)', 'rgba(255, 152, 0, 1)', 'rgba(255, 183, 77, 1)']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Takwim per Struktur Chart
const takwimPerStrukturCtx = document.getElementById('takwimPerStrukturChart').getContext('2d');
const takwimPerStrukturChart = new Chart(takwimPerStrukturCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_struktur']->pluck('nama_struktur')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_struktur']->pluck('total')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Takwim per Bulan Chart
const takwimPerBulanCtx = document.getElementById('takwimPerBulanChart').getContext('2d');
const takwimPerBulanChart = new Chart(takwimPerBulanCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Takwim',
            data: {!! json_encode($chartData['per_bulan']->pluck('total')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Takwim per Durasi Chart
const takwimPerDurasiCtx = document.getElementById('takwimPerDurasiChart').getContext('2d');
const takwimPerDurasiChart = new Chart(takwimPerDurasiCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_durasi']->pluck('durasi')) !!},
        datasets: [{
            label: 'Jumlah Takwim',
            data: {!! json_encode($chartData['per_durasi']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush

