@extends('layouts.app')

@section('title', 'Statistik Mutasi - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Mutasi</h1>
        <p class="text-muted">Analisis data mutasi PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.mutasi') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ request('tanggal_mulai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ request('tanggal_selesai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="jenis_mutasi" class="form-label">Jenis Mutasi</label>
                        <select class="form-select" id="jenis_mutasi" name="jenis_mutasi">
                            <option value="">Semua Jenis</option>
                            <option value="Masuk" {{ request('jenis_mutasi') == 'Masuk' ? 'selected' : '' }}>Masuk</option>
                            <option value="Keluar" {{ request('jenis_mutasi') == 'Keluar' ? 'selected' : '' }}>Keluar</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">Semua Status</option>
                            <option value="Pending" {{ request('status') == 'Pending' ? 'selected' : '' }}>Pending</option>
                            <option value="Disetujui" {{ request('status') == 'Disetujui' ? 'selected' : '' }}>Disetujui</option>
                            <option value="Ditolak" {{ request('status') == 'Ditolak' ? 'selected' : '' }}>Ditolak</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="struktur_organisasi_id" class="form-label">Struktur Organisasi</label>
                        <select class="form-select" id="struktur_organisasi_id" name="struktur_organisasi_id">
                            <option value="">Semua Struktur</option>
                            @foreach($strukturOrganisasi as $struktur)
                                <option value="{{ $struktur->id }}" 
                                        {{ request('struktur_organisasi_id') == $struktur->id ? 'selected' : '' }}>
                                    {{ $struktur->nama_struktur }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i> Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistik Cards -->
<div class="row mb-4">
    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Mutasi
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-exchange-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Pending
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['pending']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-clock fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Disetujui
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['disetujui']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-danger shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Ditolak
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['ditolak']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Masuk
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['masuk']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-sign-in-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-secondary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Keluar
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['keluar']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-sign-out-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Jenis Mutasi</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="mutasiPerJenisChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Status</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="mutasiPerStatusChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Mutasi per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="mutasiPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Tujuan Mutasi</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="mutasiPerStrukturChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Mutasi
        </h6>
    </div>
    <div class="card-body">
        @if($mutasi->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th width="12%">Anggota</th>
                        <th width="8%">Jenis</th>
                        <th width="15%">DPC Asal</th>
                        <th width="15%">DPC Tujuan</th>
                        <th width="10%">Tanggal</th>
                        <th width="8%">Status</th>
                        <th width="15%">Alasan</th>
                        <th width="12%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($mutasi as $index => $item)
                    <tr>
                        <td>{{ $mutasi->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $item->anggota->nama_lengkap }}</strong>
                            <br><small class="text-muted">{{ $item->anggota->no_anggota }}</small>
                        </td>
                        <td>
                            <span class="badge bg-{{ $item->jenis_mutasi == 'Masuk' ? 'success' : 'danger' }}">
                                {{ $item->jenis_mutasi }}
                            </span>
                        </td>
                        <td>{{ $item->anggota->dpc->nama_dpc ?? '-' }}</td>
                        <td>{{ $item->dpcTujuan->nama_dpc ?? '-' }}</td>
                        <td>{{ $item->tanggal_mutasi->format('d/m/Y') }}</td>
                        <td>
                            @php
                                $statusClass = match($item->status_mutasi) {
                                    'Pending' => 'warning',
                                    'Disetujui' => 'success',
                                    'Ditolak' => 'danger',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $statusClass }}">{{ $item->status_mutasi }}</span>
                        </td>
                        <td>{{ Str::limit($item->alasan, 30) }}</td>
                        <td>
                            <a href="{{ route('mutasi.show', $item) }}" class="btn btn-sm btn-info" title="Lihat Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                <small class="text-muted">
                    Menampilkan {{ $mutasi->firstItem() }} sampai {{ $mutasi->lastItem() }} 
                    dari {{ $mutasi->total() }} data
                </small>
            </div>
            <div>
                {{ $mutasi->appends(request()->query())->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-exchange-alt fa-5x text-muted mb-3"></i>
            <h5 class="text-muted">Tidak Ada Data Mutasi</h5>
            <p class="text-muted">Tidak ada data mutasi yang sesuai dengan filter yang dipilih</p>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Mutasi per Jenis Chart
const mutasiPerJenisCtx = document.getElementById('mutasiPerJenisChart').getContext('2d');
const mutasiPerJenisChart = new Chart(mutasiPerJenisCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_jenis']->pluck('jenis_mutasi')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_jenis']->pluck('total')) !!},
            backgroundColor: ['rgba(255, 87, 34, 1)', 'rgba(255, 183, 77, 1)']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Mutasi per Status Chart
const mutasiPerStatusCtx = document.getElementById('mutasiPerStatusChart').getContext('2d');
const mutasiPerStatusChart = new Chart(mutasiPerStatusCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_status']->pluck('status')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_status']->pluck('total')) !!},
            backgroundColor: ['rgba(255, 87, 34, 1)', 'rgba(255, 152, 0, 1)', 'rgba(255, 183, 77, 1)']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Mutasi per Bulan Chart
const mutasiPerBulanCtx = document.getElementById('mutasiPerBulanChart').getContext('2d');
const mutasiPerBulanChart = new Chart(mutasiPerBulanCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Mutasi',
            data: {!! json_encode($chartData['per_bulan']->pluck('total')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Mutasi per Struktur Chart
const mutasiPerStrukturCtx = document.getElementById('mutasiPerStrukturChart').getContext('2d');
const mutasiPerStrukturChart = new Chart(mutasiPerStrukturCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_struktur']->pluck('nama_struktur')) !!},
        datasets: [{
            label: 'Jumlah Mutasi',
            data: {!! json_encode($chartData['per_struktur']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush
