@extends('layouts.app')

@section('title', 'Statistik Kegiatan - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Kegiatan</h1>
        <p class="text-muted">Analisis data kegiatan PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.kegiatan') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ request('tanggal_mulai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ request('tanggal_selesai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="jenis_kegiatan" class="form-label">Jenis Kegiatan</label>
                        <select class="form-select" id="jenis_kegiatan" name="jenis_kegiatan">
                            <option value="">Semua Jenis</option>
                            <option value="Rapat" {{ request('jenis_kegiatan') == 'Rapat' ? 'selected' : '' }}>Rapat</option>
                            <option value="Pelatihan" {{ request('jenis_kegiatan') == 'Pelatihan' ? 'selected' : '' }}>Pelatihan</option>
                            <option value="Seminar" {{ request('jenis_kegiatan') == 'Seminar' ? 'selected' : '' }}>Seminar</option>
                            <option value="Workshop" {{ request('jenis_kegiatan') == 'Workshop' ? 'selected' : '' }}>Workshop</option>
                            <option value="Lainnya" {{ request('jenis_kegiatan') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">Semua Status</option>
                            <option value="Selesai" {{ request('status') == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                            <option value="Dibatalkan" {{ request('status') == 'Dibatalkan' ? 'selected' : '' }}>Dibatalkan</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="struktur_organisasi_id" class="form-label">Struktur Organisasi</label>
                        <select class="form-select" id="struktur_organisasi_id" name="struktur_organisasi_id">
                            <option value="">Semua Struktur</option>
                            @foreach($strukturOrganisasi as $struktur)
                                <option value="{{ $struktur->id }}" 
                                        {{ request('struktur_organisasi_id') == $struktur->id ? 'selected' : '' }}>
                                    {{ $struktur->nama_struktur }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i> Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistik Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Kegiatan
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Selesai
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['selesai']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-danger shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Dibatalkan
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['dibatalkan']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Rata-rata Peserta
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['rata_rata_peserta'], 1) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Jenis Kegiatan</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="kegiatanPerJenisChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Status</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="kegiatanPerStatusChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-info">Kegiatan per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="kegiatanPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-warning">Distribusi per Struktur</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="kegiatanPerStrukturChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Kegiatan
        </h6>
    </div>
    <div class="card-body">
        @if($kegiatan->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Nama Kegiatan</th>
                        <th width="15%">Jenis</th>
                        <th width="15%">Struktur</th>
                        <th width="12%">Tanggal</th>
                        <th width="10%">Status</th>
                        <th width="8%">Peserta</th>
                        <th width="15%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($kegiatan as $index => $item)
                    <tr>
                        <td>{{ $kegiatan->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $item->nama_kegiatan }}</strong>
                            @if($item->deskripsi)
                            <br><small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-info">{{ $item->jenis_kegiatan }}</span>
                        </td>
                        <td>{{ $item->strukturOrganisasi->nama_struktur ?? '-' }}</td>
                        <td>{{ $item->tanggal_kegiatan->format('d/m/Y') }}</td>
                        <td>
                            <span class="badge bg-{{ $item->status == 'Selesai' ? 'success' : 'danger' }}">
                                {{ $item->status }}
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-primary">{{ $item->absensiKegiatan->count() }}</span>
                        </td>
                        <td>
                            <a href="{{ route('kegiatan.show', $item) }}" class="btn btn-sm btn-info" title="Lihat Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                <small class="text-muted">
                    Menampilkan {{ $kegiatan->firstItem() }} sampai {{ $kegiatan->lastItem() }} 
                    dari {{ $kegiatan->total() }} data
                </small>
            </div>
            <div>
                {{ $kegiatan->appends(request()->query())->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-calendar fa-5x text-muted mb-3"></i>
            <h5 class="text-muted">Tidak Ada Data Kegiatan</h5>
            <p class="text-muted">Tidak ada data kegiatan yang sesuai dengan filter yang dipilih</p>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Kegiatan per Jenis Chart
const kegiatanPerJenisCtx = document.getElementById('kegiatanPerJenisChart').getContext('2d');
const kegiatanPerJenisChart = new Chart(kegiatanPerJenisCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_jenis']->pluck('jenis_kegiatan')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_jenis']->pluck('total')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Kegiatan per Status Chart
const kegiatanPerStatusCtx = document.getElementById('kegiatanPerStatusChart').getContext('2d');
const kegiatanPerStatusChart = new Chart(kegiatanPerStatusCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_status']->pluck('status')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_status']->pluck('total')) !!},
            backgroundColor: ['rgba(255, 87, 34, 1)', 'rgba(255, 183, 77, 1)']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Kegiatan per Bulan Chart
const kegiatanPerBulanCtx = document.getElementById('kegiatanPerBulanChart').getContext('2d');
const kegiatanPerBulanChart = new Chart(kegiatanPerBulanCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Kegiatan',
            data: {!! json_encode($chartData['per_bulan']->pluck('total')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Kegiatan per Struktur Chart
const kegiatanPerStrukturCtx = document.getElementById('kegiatanPerStrukturChart').getContext('2d');
const kegiatanPerStrukturChart = new Chart(kegiatanPerStrukturCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_struktur']->pluck('nama_struktur')) !!},
        datasets: [{
            label: 'Jumlah Kegiatan',
            data: {!! json_encode($chartData['per_struktur']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush

