@extends('layouts.app')

@section('title', 'Statistik - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Dashboard Statistik</h1>
        <p class="text-muted">Overview statistik sistem PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <div class="btn-group" role="group">
            <a href="{{ route('statistik.anggota') }}" class="btn btn-outline-primary">
                <i class="fas fa-users me-1"></i> Statistik Anggota
            </a>
            <a href="{{ route('statistik.kegiatan') }}" class="btn btn-outline-success">
                <i class="fas fa-calendar me-1"></i> Statistik Kegiatan
            </a>
            <a href="{{ route('statistik.mutasi') }}" class="btn btn-outline-warning">
                <i class="fas fa-exchange-alt me-1"></i> Statistik Mutasi
            </a>
            <a href="{{ route('statistik.takwim') }}" class="btn btn-outline-info">
                <i class="fas fa-project-diagram me-1"></i> Statistik Takwim
            </a>
        </div>
    </div>
</div>

<!-- Overview Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Anggota
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_anggota'] ?? 0) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-success">{{ $stats['anggota_aktif'] ?? 0 }} aktif</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Total Kegiatan
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_kegiatan'] ?? 0) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-info">{{ $stats['kegiatan_bulan_ini'] ?? 0 }} bulan ini</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Total Mutasi
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_mutasi'] ?? 0) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-warning">{{ $stats['mutasi_pending'] ?? 0 }} pending</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-exchange-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Total Takwim
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_takwim'] ?? 0) }}</div>
                        <div class="text-xs text-muted">
                            <span class="text-success">{{ $stats['takwim_aktif'] ?? 0 }} aktif</span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-project-diagram fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Anggota per Bulan Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Pertumbuhan Anggota per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="anggotaPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Kegiatan per Bulan Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Kegiatan per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="kegiatanPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Anggota per Struktur Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi Anggota per Jenjang</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="anggotaPerStrukturChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Kegiatan per Jenis Chart -->
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi Kegiatan per Jenis</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="kegiatanPerJenisChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-tachometer-alt me-2"></i>Quick Actions
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <a href="{{ route('statistik.anggota') }}" class="btn btn-primary btn-block">
                            <i class="fas fa-users me-2"></i>Lihat Statistik Anggota
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="{{ route('statistik.kegiatan') }}" class="btn btn-success btn-block">
                            <i class="fas fa-calendar me-2"></i>Lihat Statistik Kegiatan
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="{{ route('statistik.mutasi') }}" class="btn btn-warning btn-block">
                            <i class="fas fa-exchange-alt me-2"></i>Lihat Statistik Mutasi
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="{{ route('statistik.takwim') }}" class="btn btn-info btn-block">
                            <i class="fas fa-project-diagram me-2"></i>Lihat Statistik Takwim
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Anggota per Bulan Chart
const anggotaPerBulanCtx = document.getElementById('anggotaPerBulanChart').getContext('2d');
const anggotaPerBulanChart = new Chart(anggotaPerBulanCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['anggota_per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Anggota Baru',
            data: {!! json_encode($chartData['anggota_per_bulan']->pluck('total')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Kegiatan per Bulan Chart
const kegiatanPerBulanCtx = document.getElementById('kegiatanPerBulanChart').getContext('2d');
const kegiatanPerBulanChart = new Chart(kegiatanPerBulanCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['kegiatan_per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Kegiatan',
            data: {!! json_encode($chartData['kegiatan_per_bulan']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Anggota per Struktur Chart
const anggotaPerStrukturCtx = document.getElementById('anggotaPerStrukturChart').getContext('2d');
const anggotaPerStrukturChart = new Chart(anggotaPerStrukturCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['anggota_per_struktur']->pluck('nama_struktur')) !!},
        datasets: [{
            data: {!! json_encode($chartData['anggota_per_struktur']->pluck('total')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Kegiatan per Jenis Chart
const kegiatanPerJenisCtx = document.getElementById('kegiatanPerJenisChart').getContext('2d');
const kegiatanPerJenisChart = new Chart(kegiatanPerJenisCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['kegiatan_per_jenis']->pluck('jenis_kegiatan')) !!},
        datasets: [{
            data: {!! json_encode($chartData['kegiatan_per_jenis']->pluck('total')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});
</script>
@endpush

