@extends('layouts.app')

@section('title', 'Statistik Anggota - Sistem Informasi PKS')

@section('content')
@if(session('warning'))
<div class="alert alert-warning alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-triangle me-2"></i>
    {{ session('warning') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i>
    {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Statistik Anggota</h1>
        <p class="text-muted">Analisis data anggota PKS</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('statistik.anggota.export', request()->query()) }}" class="btn btn-success me-2">
            <i class="fas fa-file-csv me-1"></i> Export CSV
        </a>
        <a href="{{ route('statistik.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

<!-- Filter Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-filter me-2"></i>Filter Data
        </h6>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('statistik.anggota') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                               value="{{ request('tanggal_mulai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                               value="{{ request('tanggal_selesai') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="ref_jenjang_id" class="form-label">Jenjang Anggota</label>
                        <select class="form-select" id="ref_jenjang_id" name="ref_jenjang_id">
                            <option value="">Semua Jenjang</option>
                            @foreach(\App\Models\RefJenjang::active()->get() as $jenjang)
                                <option value="{{ $jenjang->ref_jenjang_id }}" {{ request('ref_jenjang_id') == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                    {{ $jenjang->jenjang }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="">Semua Status</option>
                            <option value="Aktif" {{ request('status') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="Tidak Aktif" {{ request('status') == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                        <select class="form-select" id="jenis_kelamin" name="jenis_kelamin">
                            <option value="">Semua Jenis Kelamin</option>
                            <option value="L" {{ request('jenis_kelamin') == 'L' ? 'selected' : '' }}>Laki-laki</option>
                            <option value="P" {{ request('jenis_kelamin') == 'P' ? 'selected' : '' }}>Perempuan</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="umur_min" class="form-label">Umur Minimum</label>
                        <input type="number" class="form-control" id="umur_min" name="umur_min" 
                               value="{{ request('umur_min') }}" min="0" max="100">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="umur_max" class="form-label">Umur Maksimum</label>
                        <input type="number" class="form-control" id="umur_max" name="umur_max" 
                               value="{{ request('umur_max') }}" min="0" max="100">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i> Filter
                            </button>
                            <a href="{{ route('statistik.anggota.export', request()->query()) }}" class="btn btn-success">
                                <i class="fas fa-file-csv me-1"></i> Export CSV
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistik Cards -->
<div class="row mb-4">
    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Anggota
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['total']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Laki-laki
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['laki_laki']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-male fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Perempuan
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['perempuan']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-female fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Aktif
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['aktif']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-danger shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Tidak Aktif
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['tidak_aktif']) }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-2 col-md-4 mb-4">
        <div class="card border-left-secondary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                            Rata-rata Umur
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistik['rata_rata_umur'], 1) }} tahun</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-birthday-cake fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi Anggota per Jenjang</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="anggotaPerStrukturChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-white">Distribusi per Jenis Kelamin</h6>
            </div>
            <div class="card-body">
                <div class="chart-pie pt-4 pb-2">
                    <canvas id="anggotaPerJenisKelaminChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-info">Pertumbuhan Anggota per Bulan</h6>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="anggotaPerBulanChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-7">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-warning">Distribusi per Kelompok Umur</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="anggotaPerUmurChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-table me-2"></i>Data Anggota
        </h6>
    </div>
    <div class="card-body">
        @if($anggota->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Nama Lengkap</th>
                        <th width="15%">No. Anggota</th>
                        <th width="15%">Jenjang</th>
                        <th width="10%">Jenis Kelamin</th>
                        <th width="10%">Umur</th>
                        <th width="10%">Status</th>
                        <th width="15%">Tanggal Bergabung</th>
                        <th width="10%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($anggota as $index => $item)
                    <tr>
                        <td>{{ $anggota->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $item->nama_lengkap }}</strong>
                            <br><small class="text-muted">{{ $item->refJenjang->jenjang ?? $item->jenjang_anggota ?? '-' }}</small>
                        </td>
                        <td>{{ $item->nomor_identitas_anggota }}</td>
                        <td>
                            <span class="badge bg-info">{{ $item->refJenjang->jenjang ?? $item->jenjang_anggota }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $item->jenis_kelamin == 'L' ? 'primary' : 'info' }}">
                                {{ $item->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}
                            </span>
                        </td>
                        <td>{{ $item->umur }} tahun</td>
                        <td>
                            <span class="badge bg-{{ $item->status == 'Aktif' ? 'success' : 'danger' }}">
                                {{ $item->status }}
                            </span>
                        </td>
                        <td>{{ $item->created_at->format('d/m/Y') }}</td>
                        <td>
                            <a href="{{ route('anggota.show', $item) }}" class="btn btn-sm btn-info" title="Lihat Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                <small class="text-muted">
                    Menampilkan {{ $anggota->firstItem() }} sampai {{ $anggota->lastItem() }} 
                    dari {{ $anggota->total() }} data
                </small>
            </div>
            <div>
                {{ $anggota->appends(request()->query())->links() }}
            </div>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-users fa-5x text-muted mb-3"></i>
            <h5 class="text-muted">Tidak Ada Data Anggota</h5>
            <p class="text-muted">Tidak ada data anggota yang sesuai dengan filter yang dipilih</p>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Anggota per Struktur Chart
const anggotaPerStrukturCtx = document.getElementById('anggotaPerStrukturChart').getContext('2d');
const anggotaPerStrukturChart = new Chart(anggotaPerStrukturCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_struktur']->pluck('nama_struktur')) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_struktur']->pluck('total')) !!},
            backgroundColor: [
                'rgba(255, 87, 34, 1)',
                'rgba(255, 152, 0, 1)',
                'rgba(255, 193, 7, 1)',
                'rgba(255, 183, 77, 1)',
                'rgba(255, 204, 128, 1)',
                'rgba(255, 224, 178, 1)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Anggota per Jenis Kelamin Chart
const anggotaPerJenisKelaminCtx = document.getElementById('anggotaPerJenisKelaminChart').getContext('2d');
const anggotaPerJenisKelaminChart = new Chart(anggotaPerJenisKelaminCtx, {
    type: 'doughnut',
    data: {
        labels: {!! json_encode($chartData['per_jenis_kelamin']->map(function($item) {
            return $item->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan';
        })) !!},
        datasets: [{
            data: {!! json_encode($chartData['per_jenis_kelamin']->pluck('total')) !!},
            backgroundColor: ['rgba(255, 87, 34, 1)', 'rgba(255, 183, 77, 1)']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Anggota per Bulan Chart
const anggotaPerBulanCtx = document.getElementById('anggotaPerBulanChart').getContext('2d');
const anggotaPerBulanChart = new Chart(anggotaPerBulanCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($chartData['per_bulan']->map(function($item) {
            return Carbon\Carbon::create($item->tahun, $item->bulan, 1)->format('M Y');
        })) !!},
        datasets: [{
            label: 'Anggota Baru',
            data: {!! json_encode($chartData['per_bulan']->pluck('total')) !!},
            borderColor: 'rgb(255, 87, 34)',
            backgroundColor: 'rgba(255, 87, 34, 0.1)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Anggota per Umur Chart
const anggotaPerUmurCtx = document.getElementById('anggotaPerUmurChart').getContext('2d');
const anggotaPerUmurChart = new Chart(anggotaPerUmurCtx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($chartData['per_umur']->pluck('kelompok_umur')) !!},
        datasets: [{
            label: 'Jumlah Anggota',
            data: {!! json_encode($chartData['per_umur']->pluck('total')) !!},
            backgroundColor: 'rgba(255, 87, 34, 0.8)',
            borderColor: 'rgba(255, 87, 34, 1)',
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush
