@extends('layouts.app')

@section('title', 'Detail Rekomposisi UPA')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-eye me-2"></i>Detail Rekomposisi UPA
            </h1>
            <p class="text-muted mb-0">{{ $rekomposisiUpa->nomor_sk }}</p>
        </div>
        <div>
            <a href="{{ route('rekomposisi-upa.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali
            </a>
            @if($rekomposisiUpa->canEdit())
                <a href="{{ route('rekomposisi-upa.edit', $rekomposisiUpa->id) }}" class="btn btn-warning">
                    <i class="fas fa-edit me-1"></i>Edit
                </a>
            @endif
            <a href="{{ route('rekomposisi-upa.print', $rekomposisiUpa->id) }}" class="btn btn-info" target="_blank">
                <i class="fas fa-print me-1"></i>Print
            </a>
            <a href="{{ route('rekomposisi-upa.pdf', $rekomposisiUpa->id) }}" class="btn btn-danger">
                <i class="fas fa-file-pdf me-1"></i>PDF
            </a>
        </div>
    </div>

    <!-- Status Card -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h5 class="mb-1">{{ $rekomposisiUpa->judul_sk }}</h5>
                    <p class="text-muted mb-0">
                        <strong>DPC:</strong> {{ $rekomposisiUpa->dpc->nama_dpc ?? 'N/A' }} | 
                        <strong>Tanggal SK:</strong> {{ $rekomposisiUpa->tanggal_sk_formatted }} |
                        <strong>Total UPA:</strong> {{ $rekomposisiUpa->total_upa }} |
                        <strong>Total Anggota:</strong> {{ $rekomposisiUpa->total_anggota }}
                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <span class="badge bg-{{ $rekomposisiUpa->status_badge_class }} fs-6">
                        {{ $rekomposisiUpa->status_text }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    @if($rekomposisiUpa->canApprove() || $rekomposisiUpa->canPublish())
        <div class="card shadow mb-4">
            <div class="card-body text-center">
                @if($rekomposisiUpa->canApprove())
                    <form action="{{ route('rekomposisi-upa.approve', $rekomposisiUpa->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-success btn-lg me-2" 
                                onclick="return confirm('Setujui rekomposisi ini?')">
                            <i class="fas fa-check me-1"></i>Setujui Rekomposisi
                        </button>
                    </form>
                @endif
                
                @if($rekomposisiUpa->canPublish())
                    <form action="{{ route('rekomposisi-upa.publish', $rekomposisiUpa->id) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-info btn-lg" 
                                onclick="return confirm('Publikasikan rekomposisi ini?')">
                            <i class="fas fa-share me-1"></i>Publikasikan
                        </button>
                    </form>
                @endif
            </div>
        </div>
    @endif

    <!-- Basic Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-info-circle me-1"></i>Informasi Dasar
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <td width="30%"><strong>Nomor SK:</strong></td>
                            <td><code class="text-primary">{{ $rekomposisiUpa->nomor_sk }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Judul SK:</strong></td>
                            <td>{{ $rekomposisiUpa->judul_sk }}</td>
                        </tr>
                        <tr>
                            <td><strong>DPC:</strong></td>
                            <td>{{ $rekomposisiUpa->dpc->nama_dpc ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Tanggal SK:</strong></td>
                            <td>{{ $rekomposisiUpa->tanggal_sk_formatted }}</td>
                        </tr>
                        <tr>
                            <td><strong>Ditetapkan di:</strong></td>
                            <td>{{ $rekomposisiUpa->ditetapkan_di }}</td>
                        </tr>
                        <tr>
                            <td><strong>Ditetapkan tanggal:</strong></td>
                            <td>{{ $rekomposisiUpa->ditetapkan_tanggal_formatted }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <td width="30%"><strong>Ketua:</strong></td>
                            <td>{{ $rekomposisiUpa->ketua_nama }}</td>
                        </tr>
                        <tr>
                            <td><strong>Jabatan:</strong></td>
                            <td>{{ $rekomposisiUpa->ketua_jabatan }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge bg-{{ $rekomposisiUpa->status_badge_class }}">
                                    {{ $rekomposisiUpa->status_text }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Dibuat oleh:</strong></td>
                            <td>{{ $rekomposisiUpa->creator->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Disetujui oleh:</strong></td>
                            <td>{{ $rekomposisiUpa->approver->name ?? 'Belum disetujui' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Dibuat pada:</strong></td>
                            <td>{{ $rekomposisiUpa->created_at->format('d F Y H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Preview -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-file-alt me-1"></i>Isi Surat Keputusan
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <h6 class="text-primary">Menimbang:</h6>
                    <p><strong>a.</strong> {{ $rekomposisiUpa->menimbang_a }}</p>
                    <p><strong>b.</strong> {{ $rekomposisiUpa->menimbang_b }}</p>
                    <p><strong>c.</strong> {{ $rekomposisiUpa->menimbang_c }}</p>
                    
                    <h6 class="text-primary mt-4">Mengingat:</h6>
                    <p><strong>1.</strong> {{ $rekomposisiUpa->mengingat_1 }}</p>
                    <p><strong>2.</strong> {{ $rekomposisiUpa->mengingat_2 }}</p>
                    <p><strong>3.</strong> {{ $rekomposisiUpa->mengingat_3 }}</p>
                    
                    <h6 class="text-primary mt-4">Memperhatikan:</h6>
                    <p>{{ $rekomposisiUpa->memperhatikan }}</p>
                    
                    <h6 class="text-primary mt-4">Memutuskan:</h6>
                    <p>{{ $rekomposisiUpa->memutuskan }}</p>
                    
                    <h6 class="text-primary mt-4">Menetapkan:</h6>
                    <p>{{ $rekomposisiUpa->menetapkan }}</p>
                    
                    <h6 class="text-primary mt-4">Keputusan:</h6>
                    <p><strong>Pertama:</strong> {{ $rekomposisiUpa->pertama }}</p>
                    <p><strong>Kedua:</strong> {{ $rekomposisiUpa->kedua }}</p>
                    <p><strong>Ketiga:</strong> {{ $rekomposisiUpa->ketiga }}</p>
                    <p><strong>Keempat:</strong> {{ $rekomposisiUpa->keempat }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Details Table -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-1"></i>Detail Rekomposisi UPA
            </h6>
        </div>
        <div class="card-body">
            @if($rekomposisiUpa->details->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">No</th>
                                <th width="15%">Kode UPA</th>
                                <th width="20%">Pembimbing Baru</th>
                                <th width="20%">Anggota</th>
                                <th width="15%">DPRa</th>
                                <th width="15%">Pembimbing Lama</th>
                                <th width="10%">Keterangan</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rekomposisiUpa->details as $index => $detail)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <code class="text-primary">{{ $detail->kode_upa_formatted }}</code>
                                    </td>
                                    <td>
                                        <div class="fw-bold">{{ $detail->pembimbingBaru->nama_lengkap ?? 'N/A' }}</div>
                                        <small class="text-muted">{{ $detail->pembimbingBaru->nomor_identitas_anggota ?? '' }}</small>
                                    </td>
                                    <td>
                                        <div class="fw-bold">{{ $detail->anggota->nama_lengkap ?? 'N/A' }}</div>
                                        <small class="text-muted">{{ $detail->anggota->nomor_identitas_anggota ?? '' }}</small>
                                    </td>
                                    <td>{{ $detail->dpr_formatted }}</td>
                                    <td>
                                        @if($detail->pembimbingLama)
                                            <div class="fw-bold">{{ $detail->pembimbingLama->nama_lengkap }}</div>
                                            <small class="text-muted">{{ $detail->pembimbingLama->nomor_identitas_anggota }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>{{ $detail->keterangan_formatted }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-list fa-2x text-muted mb-3"></i>
                    <h6 class="text-muted">Belum ada detail rekomposisi</h6>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection







