@extends('layouts.app')

@section('title', 'Rekomposisi UPA')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-users-cog me-2"></i>Rekomposisi UPA
            </h1>
            <p class="text-muted mb-0">Kelola rekomposisi Unit Pembinaan Anggota</p>
        </div>
        <div>
            <a href="{{ route('rekomposisi-upa.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i>Tambah Rekomposisi
            </a>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter me-1"></i>Filter & Pencarian
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('rekomposisi-upa.index') }}">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="dpc_id" class="form-label">DPC</label>
                        <select name="dpc_id" id="dpc_id" class="form-select">
                            <option value="">Semua DPC</option>
                            @foreach($dpcList as $dpc)
                                <option value="{{ $dpc->dpc_id }}" {{ request('dpc_id') == $dpc->dpc_id ? 'selected' : '' }}>
                                    {{ $dpc->nama_dpc }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="status" class="form-label">Status</label>
                        <select name="status" id="status" class="form-select">
                            <option value="">Semua Status</option>
                            <option value="Draft" {{ request('status') == 'Draft' ? 'selected' : '' }}>Draft</option>
                            <option value="Approved" {{ request('status') == 'Approved' ? 'selected' : '' }}>Disetujui</option>
                            <option value="Published" {{ request('status') == 'Published' ? 'selected' : '' }}>Dipublikasikan</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="tanggal_dari" class="form-label">Tanggal Dari</label>
                        <input type="date" name="tanggal_dari" id="tanggal_dari" class="form-control" value="{{ request('tanggal_dari') }}">
                    </div>
                    <div class="col-md-2">
                        <label for="tanggal_sampai" class="form-label">Tanggal Sampai</label>
                        <input type="date" name="tanggal_sampai" id="tanggal_sampai" class="form-control" value="{{ request('tanggal_sampai') }}">
                    </div>
                    <div class="col-md-2">
                        <label for="search" class="form-label">Pencarian</label>
                        <input type="text" name="search" id="search" class="form-control" placeholder="Nomor SK, Judul..." value="{{ request('search') }}">
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i>Cari
                        </button>
                        <a href="{{ route('rekomposisi-upa.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-list me-1"></i>Daftar Rekomposisi UPA
                <span class="badge bg-primary ms-2">{{ $rekomposisi->total() }}</span>
            </h6>
        </div>
        <div class="card-body">
            @if($rekomposisi->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">No</th>
                                <th width="15%">Nomor SK</th>
                                <th width="20%">Judul</th>
                                <th width="15%">DPC</th>
                                <th width="10%">Tanggal SK</th>
                                <th width="10%">Status</th>
                                <th width="10%">Total UPA</th>
                                <th width="10%">Total Anggota</th>
                                <th width="15%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rekomposisi as $index => $item)
                                <tr>
                                    <td>{{ $rekomposisi->firstItem() + $index }}</td>
                                    <td>
                                        <code class="text-primary">{{ $item->nomor_sk }}</code>
                                    </td>
                                    <td>
                                        <div class="fw-bold">{{ $item->judul_sk }}</div>
                                        <small class="text-muted">Oleh: {{ $item->creator->name ?? 'N/A' }}</small>
                                    </td>
                                    <td>{{ $item->dpc->nama_dpc ?? 'N/A' }}</td>
                                    <td>{{ $item->tanggal_sk_formatted }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->status_badge_class }}">
                                            {{ $item->status_text }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $item->total_upa }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-success">{{ $item->total_anggota }}</span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('rekomposisi-upa.show', $item->id) }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if($item->canEdit())
                                                <a href="{{ route('rekomposisi-upa.edit', $item->id) }}" 
                                                   class="btn btn-sm btn-outline-warning" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endif
                                            
                                            @if($item->canApprove())
                                                <form action="{{ route('rekomposisi-upa.approve', $item->id) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-outline-success" 
                                                            title="Setujui" 
                                                            onclick="return confirm('Setujui rekomposisi ini?')">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                            @endif
                                            
                                            @if($item->canPublish())
                                                <form action="{{ route('rekomposisi-upa.publish', $item->id) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-outline-info" 
                                                            title="Publikasikan" 
                                                            onclick="return confirm('Publikasikan rekomposisi ini?')">
                                                        <i class="fas fa-share"></i>
                                                    </button>
                                                </form>
                                            @endif
                                            
                                            <a href="{{ route('rekomposisi-upa.print', $item->id) }}" 
                                               class="btn btn-sm btn-outline-secondary" 
                                               title="Print" target="_blank">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            
                                            <a href="{{ route('rekomposisi-upa.pdf', $item->id) }}" 
                                               class="btn btn-sm btn-outline-danger" 
                                               title="Download PDF">
                                                <i class="fas fa-file-pdf"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan {{ $rekomposisi->firstItem() }} sampai {{ $rekomposisi->lastItem() }} 
                        dari {{ $rekomposisi->total() }} data
                    </div>
                    <div>
                        {{ $rekomposisi->appends(request()->query())->links() }}
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-users-cog fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada rekomposisi UPA</h5>
                    <p class="text-muted">Klik tombol "Tambah Rekomposisi" untuk membuat rekomposisi UPA pertama</p>
                    <a href="{{ route('rekomposisi-upa.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>Tambah Rekomposisi
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-submit form on filter change
    $('#dpc_id, #status').change(function() {
        $(this).closest('form').submit();
    });
});
</script>
@endpush







