@extends('layouts.app')

@section('title', 'Edit Rekomposisi UPA')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-edit me-2"></i>Edit Rekomposisi UPA
            </h1>
            <p class="text-muted mb-0">{{ $rekomposisiUpa->nomor_sk }}</p>
        </div>
        <div>
            <a href="{{ route('rekomposisi-upa.show', $rekomposisiUpa->id) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali
            </a>
        </div>
    </div>

    <form action="{{ route('rekomposisi-upa.update', $rekomposisiUpa->id) }}" method="POST" id="rekomposisiForm">
        @csrf
        @method('PUT')
        
        <!-- Basic Information Card -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-info-circle me-1"></i>Informasi Dasar
                </h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="dpc_id" class="form-label">DPC</label>
                        <select name="dpc_id" id="dpc_id" class="form-select" disabled>
                            <option value="{{ $rekomposisiUpa->dpc_id }}">{{ $rekomposisiUpa->dpc->nama_dpc ?? 'N/A' }}</option>
                        </select>
                        <small class="text-muted">DPC tidak dapat diubah setelah rekomposisi dibuat</small>
                    </div>
                    <div class="col-md-6">
                        <label for="judul_sk" class="form-label">Judul SK <span class="text-danger">*</span></label>
                        <input type="text" name="judul_sk" id="judul_sk" 
                               class="form-control @error('judul_sk') is-invalid @enderror" 
                               value="{{ old('judul_sk', $rekomposisiUpa->judul_sk) }}" required>
                        @error('judul_sk')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="tanggal_sk" class="form-label">Tanggal SK <span class="text-danger">*</span></label>
                        <input type="date" name="tanggal_sk" id="tanggal_sk" 
                               class="form-control @error('tanggal_sk') is-invalid @enderror" 
                               value="{{ old('tanggal_sk', $rekomposisiUpa->tanggal_sk->format('Y-m-d')) }}" required>
                        @error('tanggal_sk')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="tanggal_rapat" class="form-label">Tanggal Rapat <span class="text-danger">*</span></label>
                        <input type="date" name="tanggal_rapat" id="tanggal_rapat" 
                               class="form-control @error('tanggal_rapat') is-invalid @enderror" 
                               value="{{ old('tanggal_rapat', $rekomposisiUpa->tanggal_rapat ? $rekomposisiUpa->tanggal_rapat->format('Y-m-d') : date('Y-m-d')) }}" required>
                        @error('tanggal_rapat')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="ditetapkan_tanggal" class="form-label">Ditetapkan Tanggal <span class="text-danger">*</span></label>
                        <input type="date" name="ditetapkan_tanggal" id="ditetapkan_tanggal" 
                               class="form-control @error('ditetapkan_tanggal') is-invalid @enderror" 
                               value="{{ old('ditetapkan_tanggal', $rekomposisiUpa->ditetapkan_tanggal->format('Y-m-d')) }}" required>
                        @error('ditetapkan_tanggal')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="ditetapkan_di" class="form-label">Ditetapkan di <span class="text-danger">*</span></label>
                        <input type="text" name="ditetapkan_di" id="ditetapkan_di" 
                               class="form-control @error('ditetapkan_di') is-invalid @enderror" 
                               value="{{ old('ditetapkan_di', $rekomposisiUpa->ditetapkan_di) }}" required>
                        @error('ditetapkan_di')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label for="nomor_sk_lampiran" class="form-label">Nomor SK Lampiran</label>
                        <input type="text" name="nomor_sk_lampiran" id="nomor_sk_lampiran" 
                               class="form-control @error('nomor_sk_lampiran') is-invalid @enderror" 
                               value="{{ old('nomor_sk_lampiran', $rekomposisiUpa->nomor_sk_lampiran) }}">
                        @error('nomor_sk_lampiran')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        <!-- Ketua Information Card -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-user-tie me-1"></i>Informasi Ketua
                </h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="ketua_nama" class="form-label">Nama Ketua <span class="text-danger">*</span></label>
                        <input type="text" name="ketua_nama" id="ketua_nama" 
                               class="form-control @error('ketua_nama') is-invalid @enderror" 
                               value="{{ old('ketua_nama', $rekomposisiUpa->ketua_nama) }}" required>
                        @error('ketua_nama')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="ketua_jabatan" class="form-label">Jabatan Ketua <span class="text-danger">*</span></label>
                        <input type="text" name="ketua_jabatan" id="ketua_jabatan" 
                               class="form-control @error('ketua_jabatan') is-invalid @enderror" 
                               value="{{ old('ketua_jabatan', $rekomposisiUpa->ketua_jabatan) }}" required>
                        @error('ketua_jabatan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>


        <!-- Current Details Card -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-list me-1"></i>Detail Rekomposisi UPA Saat Ini
                </h6>
            </div>
            <div class="card-body">
                @if($rekomposisiUpa->details->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="15%">Kode UPA</th>
                                    <th width="20%">Pembimbing Baru</th>
                                    <th width="20%">Anggota</th>
                                    <th width="15%">DPRa</th>
                                    <th width="15%">Pembimbing Lama</th>
                                    <th width="10%">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($rekomposisiUpa->details as $index => $detail)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <code class="text-primary">{{ $detail->kode_upa_formatted }}</code>
                                        </td>
                                        <td>
                                            <div class="fw-bold">{{ $detail->pembimbingBaru->nama_lengkap ?? 'N/A' }}</div>
                                            <small class="text-muted">{{ $detail->pembimbingBaru->nomor_identitas_anggota ?? '' }}</small>
                                        </td>
                                        <td>
                                            <div class="fw-bold">{{ $detail->anggota->nama_lengkap ?? 'N/A' }}</div>
                                            <small class="text-muted">{{ $detail->anggota->nomor_identitas_anggota ?? '' }}</small>
                                        </td>
                                        <td>{{ $detail->dpr_formatted }}</td>
                                        <td>
                                            @if($detail->pembimbingLama)
                                                <div class="fw-bold">{{ $detail->pembimbingLama->nama_lengkap }}</div>
                                                <small class="text-muted">{{ $detail->pembimbingLama->nomor_identitas_anggota }}</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>{{ $detail->keterangan_formatted }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-1"></i>
                        <strong>Catatan:</strong> Detail rekomposisi tidak dapat diubah melalui form edit. 
                        Untuk mengubah detail, silakan hapus rekomposisi ini dan buat yang baru.
                    </div>
                @else
                    <div class="text-center py-4">
                        <i class="fas fa-list fa-2x text-muted mb-3"></i>
                        <h6 class="text-muted">Belum ada detail rekomposisi</h6>
                    </div>
                @endif
            </div>
        </div>

        <!-- Submit Button -->
        <div class="card shadow">
            <div class="card-body text-center">
                <button type="submit" class="btn btn-primary btn-lg me-2">
                    <i class="fas fa-save me-1"></i>Update Rekomposisi
                </button>
                <a href="{{ route('rekomposisi-upa.show', $rekomposisiUpa->id) }}" class="btn btn-secondary btn-lg">
                    <i class="fas fa-times me-1"></i>Batal
                </a>
            </div>
        </div>
    </form>
</div>
@endsection
