@extends('layouts.app')

@section('title', 'Detail Perpindahan Anggota')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-exchange-alt"></i> Detail Perpindahan Anggota
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('perpindahan.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Status Badge -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <span class="badge bg-{{ $perpindahan->status_badge_class }} fs-6 px-3 py-2">
                                Status: {{ $perpindahan->status_label }}
                            </span>
                        </div>
                    </div>

                    <!-- Informasi Anggota -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="text-primary">Informasi Anggota</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tr>
                                        <th width="200">Nama Lengkap</th>
                                        <td>{{ $perpindahan->anggota->nama_lengkap }}</td>
                                    </tr>
                                    <tr>
                                        <th>Nomor Identitas Anggota</th>
                                        <td>{{ $perpindahan->anggota->nomor_identitas_anggota }}</td>
                                    </tr>
                                    <tr>
                                        <th>Tanggal Perpindahan</th>
                                        <td>{{ $perpindahan->tanggal_perpindahan_formatted }}</td>
                                    </tr>
                                    <tr>
                                        <th>Keterangan</th>
                                        <td>{{ $perpindahan->keterangan ?: '-' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Perbandingan Data -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="text-success">Perbandingan Data</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="bg-light">
                                        <tr>
                                            <th width="150">Field</th>
                                            <th class="text-center">Sebelum</th>
                                            <th class="text-center">Sesudah</th>
                                            <th class="text-center">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th>DPD</th>
                                            <td class="text-center">
                                                {{ $perpindahan->dpdBefore->nama_dpd ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $perpindahan->dpdAfter->nama_dpd ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                @if($perpindahan->dpd_id_before != $perpindahan->dpd_id_after)
                                                    <span class="badge badge-warning">Berubah</span>
                                                @else
                                                    <span class="badge badge-secondary">Sama</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>DPC</th>
                                            <td class="text-center">
                                                {{ $perpindahan->dpcBefore->nama_dpc ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $perpindahan->dpcAfter->nama_dpc ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                @if($perpindahan->dpc_id_before != $perpindahan->dpc_id_after)
                                                    <span class="badge badge-warning">Berubah</span>
                                                @else
                                                    <span class="badge badge-secondary">Sama</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>UPA</th>
                                            <td class="text-center">
                                                {{ $perpindahan->upaBefore->nama_upa ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $perpindahan->upaAfter->nama_upa ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                @if($perpindahan->upa_id_before != $perpindahan->upa_id_after)
                                                    <span class="badge badge-warning">Berubah</span>
                                                @else
                                                    <span class="badge badge-secondary">Sama</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Jenjang</th>
                                            <td class="text-center">
                                                {{ $perpindahan->jenjangBefore->jenjang ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $perpindahan->jenjangAfter->jenjang ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                @if($perpindahan->ref_jenjang_id_before != $perpindahan->ref_jenjang_id_after)
                                                    <span class="badge badge-warning">Berubah</span>
                                                @else
                                                    <span class="badge badge-secondary">Sama</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Grup UPA</th>
                                            <td class="text-center">
                                                {{ $perpindahan->grupUpaBefore->nama_grup_upa ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $perpindahan->grupUpaAfter->nama_grup_upa ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                @if($perpindahan->ref_grup_upa_id_before != $perpindahan->ref_grup_upa_id_after)
                                                    <span class="badge badge-warning">Berubah</span>
                                                @else
                                                    <span class="badge badge-secondary">Sama</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Informasi Admin -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="text-info">Informasi Admin</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tr>
                                        <th width="200">Dibuat Oleh</th>
                                        <td>{{ $perpindahan->createdBy->name ?? '-' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Tanggal Dibuat</th>
                                        <td>{{ $perpindahan->created_at->format('d F Y H:i:s') }}</td>
                                    </tr>
                                    @if($perpindahan->approvedBy)
                                        <tr>
                                            <th>Disetujui Oleh</th>
                                            <td>{{ $perpindahan->approvedBy->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Tanggal Disetujui</th>
                                            <td>{{ $perpindahan->updated_at->format('d F Y H:i:s') }}</td>
                                        </tr>
                                    @endif
                                    @if($perpindahan->catatan_admin)
                                        <tr>
                                            <th>Catatan Admin</th>
                                            <td>{{ $perpindahan->catatan_admin }}</td>
                                        </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <div class="btn-group" role="group">
                                @if($perpindahan->status_perpindahan === 'Diajukan')
                                    <a href="{{ route('perpindahan.edit', $perpindahan->id) }}" class="btn btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    
                                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#approveModal">
                                        <i class="fas fa-check"></i> Setujui
                                    </button>
                                    
                                    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                        <i class="fas fa-times"></i> Tolak
                                    </button>
                                    
                                    <form method="POST" action="{{ route('perpindahan.destroy', $perpindahan->id) }}" 
                                          style="display: inline;" onsubmit="return confirm('Yakin ingin menghapus?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">
                                            <i class="fas fa-trash"></i> Hapus
                                        </button>
                                    </form>
                                @endif
                                
                                @if($perpindahan->status_perpindahan === 'Disetujui')
                                    <a href="{{ route('perpindahan.print.surat-penempatan', $perpindahan->id) }}" 
                                       class="btn btn-success" target="_blank">
                                        <i class="fas fa-print"></i> Print Surat Penempatan
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approveModalLabel">Setujui Perpindahan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="{{ route('perpindahan.approve', $perpindahan->id) }}">
                @csrf
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menyetujui perpindahan ini?</p>
                    <div class="form-group mb-3">
                        <label for="catatan_admin_approve">Catatan Admin (Opsional)</label>
                        <textarea class="form-control" id="catatan_admin_approve" name="catatan_admin" rows="3" 
                                  placeholder="Catatan untuk perpindahan ini..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">Setujui</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="rejectModalLabel">Tolak Perpindahan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="{{ route('perpindahan.reject', $perpindahan->id) }}">
                @csrf
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menolak perpindahan ini?</p>
                    <div class="form-group mb-3">
                        <label for="catatan_admin_reject">Alasan Penolakan <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="catatan_admin_reject" name="catatan_admin" rows="3" 
                                  placeholder="Alasan penolakan..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Tolak</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
