<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Perpindahan Anggota</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12pt;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo {
            width: 80px;
            height: 80px;
            margin-bottom: 10px;
        }
        
        .title {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .subtitle {
            font-size: 14pt;
            margin-bottom: 20px;
        }
        
        .info {
            margin-bottom: 20px;
        }
        
        .info p {
            margin: 5px 0;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table th,
        .table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        
        .table th {
            background-color: #f5f5f5;
            font-weight: bold;
            text-align: center;
        }
        
        .table .center {
            text-align: center;
        }
        
        .table .number {
            text-align: center;
            width: 40px;
        }
        
        .footer {
            margin-top: 40px;
            text-align: right;
        }
        
        .signature {
            margin-top: 30px;
        }
        
        .signature-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .signature-table td {
            padding: 10px;
            text-align: center;
            vertical-align: top;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            height: 60px;
            margin-bottom: 5px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 15px;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('images/logopks.png') }}" alt="Logo PKS" class="logo">
        <div class="title">LAPORAN PERPINDAHAN ANGGOTA</div>
        <div class="subtitle">DPD PKS JAKARTA TIMUR</div>
    </div>

    <div class="info">
        <p><strong>Periode:</strong> {{ \Carbon\Carbon::parse(request('tanggal_mulai'))->format('d F Y') }} s/d {{ \Carbon\Carbon::parse(request('tanggal_selesai'))->format('d F Y') }}</p>
        <p><strong>Tanggal Laporan:</strong> {{ now()->format('d F Y') }}</p>
        <p><strong>Total Data:</strong> {{ $perpindahan->count() }} perpindahan</p>
    </div>

    @if($perpindahan->count() > 0)
        <table class="table">
            <thead>
                <tr>
                    <th class="number">No</th>
                    <th>Nama Anggota</th>
                    <th>NIA</th>
                    <th>Tanggal Perpindahan</th>
                    <th>Perubahan</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($perpindahan as $index => $item)
                    <tr>
                        <td class="number">{{ $index + 1 }}</td>
                        <td>{{ $item->anggota->nama_lengkap }}</td>
                        <td class="center">{{ $item->anggota->nomor_identitas_anggota }}</td>
                        <td class="center">{{ $item->tanggal_perpindahan_formatted }}</td>
                        <td>
                            @php
                                $changes = [];
                                if ($item->dpd_id_before != $item->dpd_id_after) $changes[] = 'DPD';
                                if ($item->dpc_id_before != $item->dpc_id_after) $changes[] = 'DPC';
                                if ($item->dpc_id_before != $item->dpc_id_after) $changes[] = 'UPA';
                                if ($item->ref_jenjang_id_before != $item->ref_jenjang_id_after) $changes[] = 'Jenjang';
                                if ($item->ref_grup_upa_id_before != $item->ref_grup_upa_id_after) $changes[] = 'Grup UPA';
                            @endphp
                            {{ implode(', ', $changes) }}
                        </td>
                        <td class="center">{{ $item->status_label }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Detail Perpindahan -->
        <div class="page-break"></div>
        
        <div class="header">
            <div class="title">DETAIL PERPINDAHAN ANGGOTA</div>
            <div class="subtitle">DPD PKS JAKARTA TIMUR</div>
        </div>

        @foreach($perpindahan as $index => $item)
            <div style="margin-bottom: 30px;">
                <h4>{{ $index + 1 }}. {{ $item->anggota->nama_lengkap }} ({{ $item->anggota->nomor_identitas_anggota }})</h4>
                
                <table class="table">
                    <thead>
                        <tr>
                            <th>Field</th>
                            <th>Sebelum</th>
                            <th>Sesudah</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <th>DPD</th>
                            <td>{{ $item->dpdBefore->nama_dpd ?? '-' }}</td>
                            <td>{{ $item->dpdAfter->nama_dpd ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>DPC</th>
                            <td>{{ $item->dpcBefore->nama_dpc ?? '-' }}</td>
                            <td>{{ $item->dpcAfter->nama_dpc ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>UPA</th>
                            <td>{{ $item->upaBefore->nama_upa ?? '-' }}</td>
                            <td>{{ $item->upaAfter->nama_upa ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Jenjang</th>
                            <td>{{ $item->jenjangBefore->jenjang ?? '-' }}</td>
                            <td>{{ $item->jenjangAfter->jenjang ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Grup UPA</th>
                            <td>{{ $item->grupUpaBefore->nama_grup_upa ?? '-' }}</td>
                            <td>{{ $item->grupUpaAfter->nama_grup_upa ?? '-' }}</td>
                        </tr>
                    </tbody>
                </table>
                
                @if($item->keterangan)
                    <p><strong>Keterangan:</strong> {{ $item->keterangan }}</p>
                @endif
                
                <p><strong>Disetujui oleh:</strong> {{ $item->approvedBy->name ?? '-' }}</p>
            </div>
            
            @if($index < $perpindahan->count() - 1)
                <div class="page-break"></div>
            @endif
        @endforeach
    @else
        <div style="text-align: center; padding: 40px;">
            <p>Tidak ada data perpindahan dalam periode yang dipilih.</p>
        </div>
    @endif

    <div class="footer">
        <div class="signature">
            <table class="signature-table">
                <tr>
                    <td style="width: 50%;">
                        <div class="signature-line"></div>
                        <p><strong>Ketua Kaderisasi</strong></p>
                        <p>DPD PKS Jakarta Timur</p>
                    </td>
                    <td style="width: 50%;">
                        <div class="signature-line"></div>
                        <p><strong>Ketua DPD</strong></p>
                        <p>DPD PKS Jakarta Timur</p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div style="margin-top: 20px;">
            <p>Jakarta, {{ now()->format('d F Y') }}</p>
        </div>
    </div>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" class="btn btn-primary">Print</button>
        <button onclick="window.close()" class="btn btn-secondary">Tutup</button>
    </div>
</body>
</html>






