<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Surat Penempatan Anggota</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12pt;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo {
            width: 80px;
            height: 80px;
            margin-bottom: 10px;
        }
        
        .title {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        .subtitle {
            font-size: 14pt;
            margin-bottom: 20px;
        }
        
        .nomor-surat {
            text-align: right;
            margin-bottom: 30px;
        }
        
        .content {
            margin-bottom: 30px;
        }
        
        .content p {
            margin: 10px 0;
            text-align: justify;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .table th,
        .table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        
        .table th {
            background-color: #f5f5f5;
            font-weight: bold;
            text-align: center;
        }
        
        .table .center {
            text-align: center;
        }
        
        .footer {
            margin-top: 40px;
        }
        
        .signature {
            margin-top: 30px;
        }
        
        .signature-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .signature-table td {
            padding: 10px;
            text-align: center;
            vertical-align: top;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            height: 60px;
            margin-bottom: 5px;
        }
        
        .highlight {
            background-color: #ffffcc;
            padding: 2px 4px;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 15px;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('images/logopks.png') }}" alt="Logo PKS" class="logo">
        <div class="title">Surat Penempatan Anggota</div>
        <div class="subtitle">DPD PKS JAKARTA TIMUR</div>
    </div>

    <div class="nomor-surat">
        <p><strong>Nomor:</strong> {{ 'SP-' . $perpindahan->id . '/DPD-PKS/JKT-TIM/' . now()->format('Y') }}</p>
        <p><strong>Tanggal:</strong> {{ now()->format('d F Y') }}</p>
    </div>

    <div class="content">
        <p>Yang bertanda tangan di bawah ini, Ketua Kaderisasi DPD PKS Jakarta Timur, dengan ini memberitahukan bahwa:</p>
        
        <table class="table">
            <tr>
                <th width="200">Nama Lengkap</th>
                <td>{{ $perpindahan->anggota->nama_lengkap }}</td>
            </tr>
            <tr>
                <th>Nomor Identitas Anggota</th>
                <td>{{ $perpindahan->anggota->nomor_identitas_anggota }}</td>
            </tr>
            <tr>
                <th>Tanggal Perpindahan</th>
                <td>{{ $perpindahan->tanggal_perpindahan_formatted }}</td>
            </tr>
        </table>

        <p>Telah dipindahkan dari:</p>
        
        <table class="table">
            <thead>
                <tr>
                    <th>DPD</th>
                    <th>DPC</th>
                    <th>UPA</th>
                    <th>Jenjang</th>
                    <th>Grup UPA</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="center">{{ $perpindahan->dpdBefore->nama_dpd ?? '-' }}</td>
                    <td class="center">{{ $perpindahan->dpcBefore->nama_dpc ?? '-' }}</td>
                    <td class="center">{{ $perpindahan->upaBefore->nama_upa ?? '-' }}</td>
                    <td class="center">{{ $perpindahan->jenjangBefore->jenjang ?? '-' }}</td>
                    <td class="center">{{ $perpindahan->grupUpaBefore->nama_grup_upa ?? '-' }}</td>
                </tr>
            </tbody>
        </table>

        <p>Ke:</p>
        
        <table class="table">
            <thead>
                <tr>
                    <th>DPD</th>
                    <th>DPC</th>
                    <th>UPA</th>
                    <th>Jenjang</th>
                    <th>Grup UPA</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="center highlight">{{ $perpindahan->dpdAfter->nama_dpd ?? '-' }}</td>
                    <td class="center highlight">{{ $perpindahan->dpcAfter->nama_dpc ?? '-' }}</td>
                    <td class="center highlight">{{ $perpindahan->upaAfter->nama_upa ?? '-' }}</td>
                    <td class="center highlight">{{ $perpindahan->jenjangAfter->jenjang ?? '-' }}</td>
                    <td class="center highlight">{{ $perpindahan->grupUpaAfter->nama_grup_upa ?? '-' }}</td>
                </tr>
            </tbody>
        </table>

        @if($perpindahan->keterangan)
            <p><strong>Alasan Perpindahan:</strong> {{ $perpindahan->keterangan }}</p>
        @endif

        <p>Surat penempatan ini berlaku mulai tanggal <strong>{{ $perpindahan->tanggal_perpindahan_formatted }}</strong> dan diharapkan kepada semua pihak terkait untuk mematuhi dan melaksanakan penempatan ini dengan sebaik-baiknya.</p>

        <p>Demikian surat penempatan ini dibuat untuk dapat dipergunakan seperlunya.</p>
    </div>

    <div class="footer">
        <div class="signature">
            <table class="signature-table">
                <tr>
                    <td style="width: 50%;">
                        <div class="signature-line"></div>
                        <p><strong>Ketua Kaderisasi</strong></p>
                        <p>DPD PKS Jakarta Timur</p>
                        <br>
                        <p><strong>H. Indarmawan, Ak</strong></p>
                    </td>
                    <td style="width: 50%;">
                        <div class="signature-line"></div>
                        <p><strong>Ketua DPD</strong></p>
                        <p>DPD PKS Jakarta Timur</p>
                        <br>
                        <p><strong>_________________</strong></p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div style="margin-top: 20px; text-align: center;">
            <p>Jakarta, {{ now()->format('d F Y') }}</p>
        </div>
    </div>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()" class="btn btn-primary">Print</button>
        <button onclick="window.close()" class="btn btn-secondary">Tutup</button>
    </div>
</body>
</html>






