@extends('layouts.app')

@section('title', 'Perpindahan Anggota')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-exchange-alt"></i> Perpindahan Anggota
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('perpindahan.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Ajukan Perpindahan
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('perpindahan.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search">Cari Anggota</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="{{ request('search') }}" placeholder="Nama atau NIA">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control" id="status" name="status">
                                        <option value="">Semua Status</option>
                                        <option value="Diajukan" {{ request('status') == 'Diajukan' ? 'selected' : '' }}>Diajukan</option>
                                        <option value="Disetujui" {{ request('status') == 'Disetujui' ? 'selected' : '' }}>Disetujui</option>
                                        <option value="Ditolak" {{ request('status') == 'Ditolak' ? 'selected' : '' }}>Ditolak</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="tanggal_mulai">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                                           value="{{ request('tanggal_mulai') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="tanggal_selesai">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                                           value="{{ request('tanggal_selesai') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="anggota_id">Anggota</label>
                                    <select class="form-control" id="anggota_id" name="anggota_id">
                                        <option value="">Semua Anggota</option>
                                        @foreach($anggotaList as $anggota)
                                            <option value="{{ $anggota->id }}" {{ request('anggota_id') == $anggota->id ? 'selected' : '' }}>
                                                {{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Print Options -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#printSuratResmiModal">
                                    <i class="fas fa-print"></i> Print Surat Resmi
                                </button>
                                <a href="{{ route('perpindahan.create') }}?anggota_id={{ request('anggota_id') }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-plus"></i> Perpindahan Anggota Terpilih
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Data Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Anggota</th>
                                    <th>Tanggal Perpindahan</th>
                                    <th>Perubahan</th>
                                    <th>Status</th>
                                    <th>Dibuat Oleh</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($perpindahan as $index => $item)
                                    <tr>
                                        <td>{{ $perpindahan->firstItem() + $index }}</td>
                                        <td>
                                            <div>
                                                <strong>{{ $item->anggota->nama_lengkap }}</strong><br>
                                                <small class="text-muted">{{ $item->anggota->nomor_identitas_anggota }}</small>
                                            </div>
                                        </td>
                                        <td>{{ $item->tanggal_perpindahan_formatted }}</td>
                                        <td>
                                            <span class="badge badge-info">{{ $item->changes_summary }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $item->status_badge_class }}">
                                                {{ $item->status_label }}
                                            </span>
                                        </td>
                                        <td>
                                            {{ $item->createdBy->name ?? '-' }}
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="{{ route('perpindahan.show', $item->id) }}" 
                                                   class="btn btn-info btn-sm" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($item->status_perpindahan === 'Diajukan')
                                                    <a href="{{ route('perpindahan.edit', $item->id) }}" 
                                                       class="btn btn-warning btn-sm" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    
                                                    <form method="POST" action="{{ route('perpindahan.destroy', $item->id) }}" 
                                                          style="display: inline;" onsubmit="return confirm('Yakin ingin menghapus?')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" title="Hapus">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                
                                                @if($item->status_perpindahan === 'Disetujui')
                                                    <a href="{{ route('perpindahan.print.surat-penempatan', $item->id) }}" 
                                                       class="btn btn-success btn-sm" title="Print Surat Penempatan" target="_blank">
                                                        <i class="fas fa-print"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">Tidak ada data perpindahan</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between">
                        <div>
                            <p class="text-muted">
                                Menampilkan {{ $perpindahan->firstItem() }} sampai {{ $perpindahan->lastItem() }} 
                                dari {{ $perpindahan->total() }} data
                            </p>
                        </div>
                        <div>
                            {{ $perpindahan->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Print Surat Resmi Modal -->
<div class="modal fade" id="printSuratResmiModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Print Surat Resmi</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="GET" action="{{ route('perpindahan.print.surat-resmi') }}" target="_blank">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="print_tanggal_mulai">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="print_tanggal_mulai" name="tanggal_mulai" required>
                    </div>
                    <div class="form-group">
                        <label for="print_tanggal_selesai">Tanggal Selesai</label>
                        <input type="date" class="form-control" id="print_tanggal_selesai" name="tanggal_selesai" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Print</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Set default date range to current month
    const today = new Date();
    const firstDay = new Date(today.getFullYear(), today.getMonth(), 1);
    const lastDay = new Date(today.getFullYear(), today.getMonth() + 1, 0);
    
    $('#print_tanggal_mulai').val(firstDay.toISOString().split('T')[0]);
    $('#print_tanggal_selesai').val(lastDay.toISOString().split('T')[0]);
});
</script>
@endpush
