<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Surat Penempatan - {{ $riwayat->nomor_surat }}</title>
    <style>
        @page { margin: 2cm; }
        body { font-family: 'Times New Roman', Times, serif; font-size: 12pt; line-height: 1.6; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 3px solid #000; padding-bottom: 10px; }
        .header h2 { margin: 5px 0; font-size: 16pt; }
        .header p { margin: 3px 0; font-size: 10pt; }
        .nomor-surat { text-align: center; margin: 20px 0; font-weight: bold; }
        .content { margin: 20px 0; text-align: justify; }
        .data-table { width: 100%; margin: 20px 0; }
        .data-table td { padding: 5px; }
        .data-table td:first-child { width: 180px; }
        .ttd { margin-top: 50px; float: right; text-align: center; width: 200px; }
        .ttd-space { height: 80px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>PARTAI KEADILAN SEJAHTERA</h2>
        <h2>{{ strtoupper($riwayat->dpcTujuan->nama_dpc ?? 'DPC') }}</h2>
        <p>{{ $riwayat->dpcTujuan->alamat ?? '' }}</p>
        <p>Telp: {{ $riwayat->dpcTujuan->no_telepon ?? '' }} | Email: {{ $riwayat->dpcTujuan->email ?? '' }}</p>
    </div>

    <div class="nomor-surat">
        <u>SURAT PENEMPATAN ANGGOTA</u><br>
        Nomor: {{ $riwayat->nomor_surat }}
    </div>

    <div class="content">
        <p>Yang bertanda tangan di bawah ini, Ketua {{ $riwayat->dpcTujuan->nama_dpc ?? 'DPC' }} Partai Keadilan Sejahtera, dengan ini menerangkan bahwa:</p>
        
        <table class="data-table">
            <tr>
                <td>Nama</td>
                <td>: {{ $riwayat->anggota->nama_lengkap }}</td>
            </tr>
            <tr>
                <td>Nomor Identitas Anggota</td>
                <td>: {{ $riwayat->anggota->nomor_identitas_anggota }}</td>
            </tr>
            <tr>
                <td>Tempat, Tanggal Lahir</td>
                <td>: {{ $riwayat->anggota->tempat_lahir }}, {{ $riwayat->anggota->tanggal_lahir ? \Carbon\Carbon::parse($riwayat->anggota->tanggal_lahir)->format('d F Y') : '-' }}</td>
            </tr>
            <tr>
                <td>Alamat</td>
                <td>: {{ $riwayat->anggota->alamat_lengkap }}</td>
            </tr>
            <tr>
                <td>Tahun Pelantikan</td>
                <td>: {{ $riwayat->tahun_pelantikan }}</td>
            </tr>
        </table>

        <p>Dengan ini ditempatkan di:</p>
        <table class="data-table">
            <tr>
                <td>DPC</td>
                <td>: {{ $riwayat->dpcTujuan->nama_dpc ?? '-' }}</td>
            </tr>
            <tr>
                <td>UPA</td>
                <td>: {{ $riwayat->upaTujuan->nama_upa ?? '-' }} ({{ $riwayat->upaTujuan->kode_upa ?? '-' }})</td>
            </tr>
            @if($riwayat->pembimbingBaru)
            <tr>
                <td>Pembimbing</td>
                <td>: {{ $riwayat->pembimbingBaru->nama_lengkap }}</td>
            </tr>
            @endif
        </table>

        @if($riwayat->catatan)
        <p><strong>Catatan:</strong><br>
        {{ $riwayat->catatan }}</p>
        @endif

        <p>Demikian surat penempatan ini dibuat untuk dapat dipergunakan sebagaimana mestinya.</p>
    </div>

    <div class="ttd">
        <p>{{ $riwayat->dpcTujuan->nama_dpc ?? 'DPC' }}, {{ $riwayat->tanggal_efektif->format('d F Y') }}</p>
        <p>Ketua DPC,</p>
        <div class="ttd-space"></div>
        <p><strong><u>(_____________________)</u></strong></p>
    </div>
</body>
</html>

