<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Surat Mutasi Anggota - {{ $riwayat->nomor_surat }}</title>
    <style>
        @page { margin: 2cm; }
        body { font-family: 'Times New Roman', Times, serif; font-size: 12pt; line-height: 1.6; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 3px solid #000; padding-bottom: 10px; }
        .header h2 { margin: 5px 0; font-size: 16pt; }
        .header p { margin: 3px 0; font-size: 10pt; }
        .nomor-surat { text-align: center; margin: 20px 0; font-weight: bold; }
        .content { margin: 20px 0; text-align: justify; }
        .data-table { width: 100%; margin: 20px 0; }
        .data-table td { padding: 5px; }
        .data-table td:first-child { width: 180px; }
        .ttd { margin-top: 50px; float: right; text-align: center; width: 200px; }
        .ttd-space { height: 80px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>PARTAI KEADILAN SEJAHTERA</h2>
        <h2>{{ strtoupper($riwayat->dpcAsal->nama_dpc ?? 'DPC') }}</h2>
        <p>{{ $riwayat->dpcAsal->alamat ?? '' }}</p>
        <p>Telp: {{ $riwayat->dpcAsal->no_telepon ?? '' }} | Email: {{ $riwayat->dpcAsal->email ?? '' }}</p>
    </div>

    <div class="nomor-surat">
        <u>SURAT MUTASI ANGGOTA</u><br>
        Nomor: {{ $riwayat->nomor_surat }}
    </div>

    <div class="content">
        <p>Yang bertanda tangan di bawah ini, Ketua {{ $riwayat->dpcAsal->nama_dpc ?? 'DPC' }} Partai Keadilan Sejahtera, dengan ini menerangkan bahwa:</p>
        
        <table class="data-table">
            <tr>
                <td>Nama</td>
                <td>: {{ $riwayat->anggota->nama_lengkap }}</td>
            </tr>
            <tr>
                <td>Nomor Identitas Anggota</td>
                <td>: {{ $riwayat->anggota->nomor_identitas_anggota }}</td>
            </tr>
            <tr>
                <td>Tempat, Tanggal Lahir</td>
                <td>: {{ $riwayat->anggota->tempat_lahir }}, {{ $riwayat->anggota->tanggal_lahir ? \Carbon\Carbon::parse($riwayat->anggota->tanggal_lahir)->format('d F Y') : '-' }}</td>
            </tr>
            <tr>
                <td>Alamat</td>
                <td>: {{ $riwayat->anggota->alamat_lengkap }}</td>
            </tr>
        </table>

        <p>Telah dimutasi dari:</p>
        <table class="data-table">
            <tr>
                <td>DPC Asal</td>
                <td>: {{ $riwayat->dpcAsal->nama_dpc ?? '-' }}</td>
            </tr>
            <tr>
                <td>UPA Asal</td>
                <td>: {{ $riwayat->upaAsal->nama_upa ?? '-' }} ({{ $riwayat->upaAsal->kode_upa ?? '-' }})</td>
            </tr>
            @if($riwayat->pembimbingLama)
            <tr>
                <td>Pembimbing Lama</td>
                <td>: {{ $riwayat->pembimbingLama->nama_lengkap }}</td>
            </tr>
            @endif
        </table>

        <p>Kepada:</p>
        <table class="data-table">
            <tr>
                <td>DPC Tujuan</td>
                <td>: {{ $riwayat->dpcTujuan->nama_dpc ?? '-' }}</td>
            </tr>
            <tr>
                <td>UPA Tujuan</td>
                <td>: {{ $riwayat->upaTujuan->nama_upa ?? '-' }} ({{ $riwayat->upaTujuan->kode_upa ?? '-' }})</td>
            </tr>
            @if($riwayat->pembimbingBaru)
            <tr>
                <td>Pembimbing Baru</td>
                <td>: {{ $riwayat->pembimbingBaru->nama_lengkap }}</td>
            </tr>
            @endif
        </table>

        <p><strong>Alasan Mutasi:</strong><br>
        {{ $riwayat->alasan }}</p>

        @if($riwayat->catatan)
        <p><strong>Catatan:</strong><br>
        {{ $riwayat->catatan }}</p>
        @endif

        <p>Demikian surat mutasi ini dibuat untuk dapat dipergunakan sebagaimana mestinya.</p>
    </div>

    <div class="ttd">
        <p>{{ $riwayat->dpcAsal->nama_dpc ?? 'DPC' }}, {{ $riwayat->tanggal_efektif->format('d F Y') }}</p>
        <p>Ketua DPC,</p>
        <div class="ttd-space"></div>
        <p><strong><u>(_____________________)</u></strong></p>
    </div>
</body>
</html>

