@extends('layouts.app')

@section('content')
<div class="container-fluid px-4">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="mt-4">
                <i class="fas fa-file-alt me-2"></i>Detail {{ $riwayat->tipe_transaksi_label }}
            </h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('perpindahan-anggota.index') }}">Riwayat Perpindahan</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            {{-- Info Perpindahan --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informasi Perpindahan</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th width="200">Nomor Surat</th>
                            <td><strong>{{ $riwayat->nomor_surat }}</strong></td>
                        </tr>
                        <tr>
                            <th>Tipe Transaksi</th>
                            <td><span class="badge bg-secondary">{{ $riwayat->tipe_transaksi_label }}</span></td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td><span class="badge bg-{{ $riwayat->status_badge }}">{{ ucfirst($riwayat->status) }}</span></td>
                        </tr>
                        <tr>
                            <th>Tanggal Efektif</th>
                            <td>{{ $riwayat->tanggal_efektif->format('d F Y') }}</td>
                        </tr>
                        @if($riwayat->tahun_pelantikan)
                        <tr>
                            <th>Tahun Pelantikan</th>
                            <td>{{ $riwayat->tahun_pelantikan }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>

            {{-- Info Anggota --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>Data Anggota</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th width="200">Nama Lengkap</th>
                            <td>{{ $riwayat->anggota->nama_lengkap ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>NIA</th>
                            <td>{{ $riwayat->anggota->nomor_identitas_anggota ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>No. Telepon</th>
                            <td>{{ $riwayat->anggota->no_telepon ?? '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            {{-- Info Perpindahan Detail --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Detail Perpindahan</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-danger"><i class="fas fa-arrow-circle-left"></i> Asal</h6>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <th>DPC</th>
                                    <td>{{ $riwayat->dpcAsal->nama_dpc ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>UPA</th>
                                    <td>{{ $riwayat->upaAsal->nama_upa ?? '-' }}</td>
                                </tr>
                                @if($riwayat->pembimbingLama)
                                <tr>
                                    <th>Pembimbing</th>
                                    <td>{{ $riwayat->pembimbingLama->nama_lengkap }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-success"><i class="fas fa-arrow-circle-right"></i> Tujuan</h6>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <th>DPC</th>
                                    <td>{{ $riwayat->dpcTujuan->nama_dpc ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <th>UPA</th>
                                    <td>{{ $riwayat->upaTujuan->nama_upa ?? '-' }}</td>
                                </tr>
                                @if($riwayat->pembimbingBaru)
                                <tr>
                                    <th>Pembimbing</th>
                                    <td>{{ $riwayat->pembimbingBaru->nama_lengkap }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Alasan & Catatan --}}
            @if($riwayat->alasan || $riwayat->catatan)
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-warning">
                    <h5 class="mb-0"><i class="fas fa-comment me-2"></i>Alasan & Catatan</h5>
                </div>
                <div class="card-body">
                    @if($riwayat->alasan)
                    <div class="mb-3">
                        <strong>Alasan:</strong>
                        <p class="mb-0">{{ $riwayat->alasan }}</p>
                    </div>
                    @endif
                    @if($riwayat->catatan)
                    <div>
                        <strong>Catatan:</strong>
                        <p class="mb-0">{{ $riwayat->catatan }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>

        <div class="col-lg-4">
            {{-- Actions --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Aksi</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('perpindahan-anggota.download-surat', $riwayat->id) }}" 
                           class="btn btn-success">
                            <i class="fas fa-download me-1"></i>Download Surat PDF
                        </a>
                        <a href="{{ route('perpindahan-anggota.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>Kembali ke List
                        </a>
                        @if(in_array($riwayat->status, ['draft', 'cancelled']))
                        <form action="{{ route('perpindahan-anggota.destroy', $riwayat->id) }}" 
                              method="POST" onsubmit="return confirm('Yakin ingin menghapus riwayat ini?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-trash me-1"></i>Hapus Riwayat
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Metadata --}}
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-info me-2"></i>Metadata</h5>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <th>Dibuat Oleh</th>
                            <td>{{ $riwayat->creator->name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Tanggal Dibuat</th>
                            <td>{{ $riwayat->created_at->format('d/m/Y H:i') }}</td>
                        </tr>
                        @if($riwayat->approved_by)
                        <tr>
                            <th>Disetujui Oleh</th>
                            <td>{{ $riwayat->approver->name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Tanggal Disetujui</th>
                            <td>{{ $riwayat->approved_at ? $riwayat->approved_at->format('d/m/Y H:i') : '-' }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

