@extends('layouts.app')

@section('title', 'Performance Dashboard - Sistem Informasi PKS')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 text-gray-800 mb-0">Performance Dashboard</h1>
            <p class="text-muted">Monitor dan optimasi performa aplikasi</p>
        </div>
    </div>

    <!-- Performance Stats -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">Cache Status</h4>
                            <p class="card-text">
                                @if($stats['cache']['anggota_status_list'])
                                    <i class="fas fa-check-circle"></i> Active
                                @else
                                    <i class="fas fa-times-circle"></i> Inactive
                                @endif
                            </p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-database fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">Memory Usage</h4>
                            <p class="card-text">{{ $stats['memory']['current'] }}</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-memory fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">Database</h4>
                            <p class="card-text">{{ $stats['database']['connection_status'] }}</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-server fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">Peak Memory</h4>
                            <p class="card-text">{{ $stats['memory']['peak'] }}</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-chart-line fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Cache Management -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-cogs me-2"></i>Cache Management
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Cache Status</h6>
                            <ul class="list-group list-group-flush">
                                @foreach($stats['cache'] as $key => $status)
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    {{ ucfirst(str_replace('_', ' ', $key)) }}
                                    @if($status)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Actions</h6>
                            <div class="d-grid gap-2">
                                <button class="btn btn-primary" onclick="clearCache()">
                                    <i class="fas fa-trash me-1"></i> Clear Cache
                                </button>
                                <button class="btn btn-success" onclick="warmCache()">
                                    <i class="fas fa-fire me-1"></i> Warm Cache
                                </button>
                                <button class="btn btn-info" onclick="refreshStats()">
                                    <i class="fas fa-sync me-1"></i> Refresh Stats
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Performance Recommendations -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-lightbulb me-2"></i>Performance Recommendations
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Database Optimizations</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i> Add database indexes</li>
                                <li><i class="fas fa-check text-success me-2"></i> Use eager loading</li>
                                <li><i class="fas fa-check text-success me-2"></i> Implement query caching</li>
                                <li><i class="fas fa-times text-danger me-2"></i> Enable query logging</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Application Optimizations</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i> Enable view caching</li>
                                <li><i class="fas fa-check text-success me-2"></i> Use lazy loading</li>
                                <li><i class="fas fa-check text-success me-2"></i> Minify assets</li>
                                <li><i class="fas fa-times text-danger me-2"></i> Enable OPcache</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function clearCache() {
    if (confirm('Are you sure you want to clear all caches?')) {
        fetch('/performance/clear-cache', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Cache cleared successfully!');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while clearing cache');
        });
    }
}

function warmCache() {
    fetch('/performance/warm-cache', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Cache warmed up successfully!');
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while warming cache');
    });
}

function refreshStats() {
    location.reload();
}
</script>
@endsection


