@extends('layouts.app')

@section('title', 'Detail Penilaian Peserta - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Detail Penilaian Peserta</h1>
        <p class="text-muted">Hasil penilaian: <strong>{{ $penilaian->pesertaTakwim->anggota->nama_lengkap ?? 'Data tidak ditemukan' }}</strong></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('penilaian-peserta.edit', $penilaian) }}" class="btn btn-outline-warning me-2">
            <i class="fas fa-edit me-1"></i> Edit Penilaian
        </a>
        <a href="{{ route('penilaian-peserta.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
    </div>
</div>

<!-- Informasi Peserta -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-user me-2"></i>Informasi Peserta
        </h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td class="fw-bold text-muted">Nama Lengkap:</td>
                        <td>{{ $penilaian->pesertaTakwim->anggota->nama_lengkap }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">NIA:</td>
                        <td>{{ $penilaian->pesertaTakwim->anggota->nomor_identitas_anggota }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Jenjang:</td>
                        <td><span class="text-dark">{{ $penilaian->pesertaTakwim->anggota->refJenjang->jenjang ?? $penilaian->pesertaTakwim->anggota->jenjang_anggota }}</span></td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td class="fw-bold text-muted">Program Takwim:</td>
                        <td><span class="text-dark">{{ $penilaian->pesertaTakwim->takwim->nama_takwim }}</span></td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Tanggal Penilaian:</td>
                        <td>{{ $penilaian->tanggal_penilaian->format('d/m/Y') }}</td>
                    </tr>
                    <tr>
                        <td class="fw-bold text-muted">Penilai:</td>
                        <td>{{ $penilaian->penilai->name }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Hasil Penilaian -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-clipboard-check me-2"></i>Hasil Penilaian
        </h6>
    </div>
    <div class="card-body">
        <!-- Ringkasan Hasil -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary h-100">
                    <div class="card-body py-3">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Skor
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $penilaian->total_skor }}/7
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-star fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-{{ $penilaian->status_kelulusan == 'Lulus' ? 'success' : 'danger' }} h-100">
                    <div class="card-body py-3">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-{{ $penilaian->status_kelulusan == 'Lulus' ? 'success' : 'danger' }} text-uppercase mb-1">
                                    Status Kelulusan
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $penilaian->status_kelulusan }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-{{ $penilaian->status_kelulusan == 'Lulus' ? 'check-circle' : 'times-circle' }} fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-info h-100">
                    <div class="card-body py-3">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Persentase
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ round(($penilaian->total_skor / 7) * 100, 1) }}%
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-percentage fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning h-100">
                    <div class="card-body py-3">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Kriteria Lulus
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    ≥ 5/7
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-graduation-cap fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Detail Indikator -->
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th style="width: 5%">No</th>
                        <th style="width: 60%">INDIKATOR</th>
                        <th style="width: 17.5%">LULUS</th>
                        <th style="width: 17.5%">TIDAK</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $indikators = $penilaian->indikator_list;
                    @endphp
                    
                    @foreach($indikators as $key => $indikator)
                    <tr class="{{ $indikator['value'] ? 'table-success' : 'table-danger' }}">
                        <td class="text-center fw-bold">{{ $loop->iteration }}</td>
                        <td class="text-justify">{{ $indikator['label'] }}</td>
                        <td class="text-center">
                            @if($indikator['value'])
                                <i class="fas fa-check-circle text-success fa-lg"></i>
                            @else
                                <i class="fas fa-times-circle text-muted fa-lg"></i>
                            @endif
                        </td>
                        <td class="text-center">
                            @if(!$indikator['value'])
                                <i class="fas fa-times-circle text-danger fa-lg"></i>
                            @else
                                <i class="fas fa-check-circle text-muted fa-lg"></i>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Catatan dan Rekomendasi -->
        @if($penilaian->catatan_penilaian || $penilaian->rekomendasi)
        <div class="row mt-4">
            @if($penilaian->catatan_penilaian)
            <div class="col-md-6">
                <h6 class="fw-bold text-muted mb-3">
                    <i class="fas fa-sticky-note me-2"></i>Catatan Penilaian
                </h6>
                <div class="card">
                    <div class="card-body">
                        <p class="mb-0">{{ $penilaian->catatan_penilaian }}</p>
                    </div>
                </div>
            </div>
            @endif
            
            @if($penilaian->rekomendasi)
            <div class="col-md-6">
                <h6 class="fw-bold text-muted mb-3">
                    <i class="fas fa-lightbulb me-2"></i>Rekomendasi
                </h6>
                <div class="card">
                    <div class="card-body">
                        <p class="mb-0">{{ $penilaian->rekomendasi }}</p>
                    </div>
                </div>
            </div>
            @endif
        </div>
        @endif
    </div>
</div>
@endsection
