@extends('layouts.app')

@section('title', 'Laporan Penilaian Peserta - Sistem Informasi PKS')

@section('content')
<div class="row mb-4">
    <div class="col-md-6">
        <h1 class="h3 text-gray-800 mb-0">Laporan Penilaian Peserta</h1>
        <p class="text-muted">Laporan hasil penilaian peserta takwim</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="{{ route('penilaian-peserta.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
        </a>
    </div>
</div>

<!-- Statistik Ringkasan -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card border-left-primary h-100">
            <div class="card-body py-3">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Penilaian
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            {{ $statistik['total_penilaian'] }}
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-left-success h-100">
            <div class="card-body py-3">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Lulus
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            {{ $statistik['lulus'] }}
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-left-danger h-100">
            <div class="card-body py-3">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                            Tidak Lulus
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            {{ $statistik['tidak_lulus'] }}
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-left-info h-100">
            <div class="card-body py-3">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Rata-rata Skor
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            {{ number_format($statistik['rata_rata_skor'], 1) }}/7
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-star fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filter -->
<div class="card shadow mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('penilaian-peserta.laporan') }}">
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="form-label">Takwim</label>
                    <select class="form-select" name="takwim_id">
                        <option value="">Semua Takwim</option>
                        @foreach($takwimList as $takwim)
                            <option value="{{ $takwim->id }}" {{ request('takwim_id') == $takwim->id ? 'selected' : '' }}>
                                {{ $takwim->nama_takwim }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Status Kelulusan</label>
                    <select class="form-select" name="status_kelulusan">
                        <option value="">Semua Status</option>
                        <option value="Lulus" {{ request('status_kelulusan') == 'Lulus' ? 'selected' : '' }}>Lulus</option>
                        <option value="Tidak Lulus" {{ request('status_kelulusan') == 'Tidak Lulus' ? 'selected' : '' }}>Tidak Lulus</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Penilai</label>
                    <select class="form-select" name="penilai_id">
                        <option value="">Semua Penilai</option>
                        @foreach($penilaiList as $penilai)
                            <option value="{{ $penilai->id }}" {{ request('penilai_id') == $penilai->id ? 'selected' : '' }}>
                                {{ $penilai->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search me-1"></i> Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-chart-bar me-2"></i>Laporan Penilaian
        </h6>
        <span class="badge bg-light text-dark">
            Total: {{ $penilaian->total() }} penilaian
        </span>
    </div>
    <div class="card-body">
        @if($penilaian->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover" id="dataTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Peserta</th>
                            <th>Takwim</th>
                            <th>Jenjang</th>
                            <th>Penilai</th>
                            <th>Tanggal Penilaian</th>
                            <th>Skor</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($penilaian as $index => $item)
                        <tr>
                            <td>{{ $penilaian->firstItem() + $index }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="rounded-circle me-2 d-flex align-items-center justify-content-center" 
                                         style="width: 35px; height: 35px; background: linear-gradient(135deg, #F0833A, #E67E22);">
                                        <i class="fas fa-user text-white"></i>
                                    </div>
                                    <div>
                                        <div class="fw-bold">{{ $item->pesertaTakwim->anggota->nama_lengkap }}</div>
                                        <small class="text-muted">{{ $item->pesertaTakwim->anggota->nomor_identitas_anggota }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $item->pesertaTakwim->takwim->nama_takwim }}</span>
                            </td>
                            <td>
                                <span class="badge bg-secondary">{{ $item->pesertaTakwim->anggota->refJenjang->jenjang ?? $item->pesertaTakwim->anggota->jenjang_anggota }}</span>
                            </td>
                            <td>{{ $item->penilai->name }}</td>
                            <td>{{ $item->tanggal_penilaian->format('d/m/Y') }}</td>
                            <td>
                                <span class="fw-bold">{{ $item->total_skor }}/7</span>
                                <small class="text-muted">({{ round(($item->total_skor / 7) * 100, 1) }}%)</small>
                            </td>
                            <td>
                                <span class="badge bg-{{ $item->status_kelulusan == 'Lulus' ? 'success' : 'danger' }}">
                                    {{ $item->status_kelulusan }}
                                </span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('penilaian-peserta.show', $item) }}" 
                                       class="btn btn-outline-info" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('penilaian-peserta.edit', $item) }}" 
                                       class="btn btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div class="text-muted">
                    Menampilkan {{ $penilaian->firstItem() }} sampai {{ $penilaian->lastItem() }} dari {{ $penilaian->total() }} data
                </div>
                <div>
                    {{ $penilaian->links() }}
                </div>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Belum ada data penilaian</h5>
                <p class="text-muted">Data penilaian akan muncul setelah ada penilaian yang dilakukan</p>
            </div>
        @endif
    </div>
</div>
@endsection

