{{-- resources/views/mutasi/index.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-exchange-alt text-primary me-2"></i>Data Mutasi Keluar
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola data mutasi anggota keluar
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('mutasi.create') }}" class="btn btn-primary px-3" style="border-radius: 6px;">
            <i class="fas fa-plus me-1"></i>Tambah Mutasi
        </a>
    </div>
</div>
                
<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('mutasi.index') }}" id="filterForm">
            <!-- Row 1: Pencarian, Status, Tanggal -->
            <div class="row g-2 mb-3">
                <div class="col-lg-4 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-search me-1 text-primary"></i>Pencarian
                    </label>
                    <input type="text" class="form-control" name="search" 
                           value="{{ request('search') }}" 
                           placeholder="Cari nama anggota..."
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-4 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-flag me-1 text-primary"></i>Status
                    </label>
                    <select class="form-select" name="status" style="border-radius: 6px;">
                        <option value="">Semua Status</option>
                        <option value="Pending" {{ request('status') == 'Pending' ? 'selected' : '' }}>Pending</option>
                        <option value="Disetujui" {{ request('status') == 'Disetujui' ? 'selected' : '' }}>Disetujui</option>
                        <option value="Ditolak" {{ request('status') == 'Ditolak' ? 'selected' : '' }}>Ditolak</option>
                    </select>
                </div>
                <div class="col-lg-4 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar me-1 text-primary"></i>Tanggal Mutasi
                    </label>
                    <input type="date" class="form-control" name="tanggal_dari" 
                           value="{{ request('tanggal_dari') }}" 
                           style="border-radius: 6px;">
                </div>
            </div>
            
            <!-- Row 2: Action Buttons -->
            <div class="row g-2 align-items-end">
                <div class="col-12">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary px-4" style="border-radius: 6px;">
                            <i class="fas fa-search me-1"></i>Cari Data
                        </button>
                        <a href="{{ route('mutasi.index') }}" class="btn btn-outline-secondary px-4" style="border-radius: 6px;">
                            <i class="fas fa-undo me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Alert Messages --}}
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<!-- Data Table -->
<div class="card shadow-sm border-0">
    <div class="card-body p-0">
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th width="4%">No</th>
                                    <th width="12%">Nomor SK</th>
                                    <th width="18%">Nama Anggota</th>
                                    <th width="12%">DPC Asal</th>
                                    <th width="12%">UPA Asal</th>
                                    <th width="12%">DPD Tujuan</th>
                                    <th width="8%">Tanggal</th>
                                    <th width="8%">Status</th>
                                    <th width="14%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($mutasis as $index => $mutasi)
                                <tr>
                                    <td>{{ $mutasis->firstItem() + $index }}</td>
                                    <td>
                                        @if($mutasi->nomor_sk)
                                            <strong class="text-dark">{{ $mutasi->nomor_sk }}</strong>
                                        @else
                                            <span class="text-muted"><em>Belum Generate</em></span>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>
                                            <a href="{{ anggota_route('anggota.show', $mutasi->anggota->id, $mutasi->anggota->nama_lengkap) }}" class="text-decoration-none text-primary">
                                                {{ $mutasi->anggota->nama_lengkap }}
                                            </a>
                                        </strong><br>
                                        <small class="text-muted">{{ $mutasi->anggota->nomor_identitas_anggota }}</small>
                                    </td>
                                    <td>{{ $mutasi->anggota->dpc->nama_dpc ?? '-' }}</td>
                                    <td>{{ $mutasi->anggota->upa->nama_upa ?? '-' }}</td>
                                    <td>{{ $mutasi->strukturKe->nama_struktur ?? '-' }}</td>
                                    <td>{{ $mutasi->tanggal_mutasi->format('d/m/Y') }}</td>
                                    <td>
                                        <span class="text-dark">
                                            {{ $mutasi->status_mutasi }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group" aria-label="Actions">
                                            {{-- Detail Button --}}
                                            <a href="{{ route('mutasi.show', $mutasi->id) }}" 
                                               class="btn btn-info btn-sm" title="Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            {{-- Edit Button (jika masih bisa diedit) --}}
                                            @if($mutasi->status_mutasi == 'Pending')
                                                <a href="{{ route('mutasi.edit', $mutasi->id) }}" 
                                                   class="btn btn-warning btn-sm" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                
                                                {{-- Delete Button --}}
                                                <form action="{{ route('mutasi.destroy', $mutasi->id) }}" 
                                                      method="POST" style="display: inline;" 
                                                      onsubmit="return confirm('Yakin hapus data ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            @endif
                                            
                                            {{-- Print Button (jika sudah disetujui) --}}
                                            @if($mutasi->status_mutasi == 'Disetujui')
                                                <a href="{{ route('mutasi.print-surat', $mutasi->id) }}" 
                                                   class="btn btn-danger btn-sm" target="_blank" title="Print Surat Mutasi">
                                                    <i class="fas fa-file-pdf"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center text-muted py-4">
                                        <i class="fas fa-inbox fa-3x mb-3 d-block"></i>
                                        <strong>Tidak ada data mutasi</strong><br>
                                        <small>Klik tombol "Tambah Mutasi" untuk menambah data baru</small>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
        
        {{-- Pagination --}}
        @if($mutasis->hasPages())
            <div class="d-flex justify-content-center p-3">
                {{ $mutasis->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>

        </div>
    </div>
</div>
@endsection