{{-- resources/views/mutasi/create.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-sign-out-alt"></i> Tambah Mutasi Keluar</h4>
                </div>
                
                <div class="card-body">
                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif
                    
                    <form action="{{ route('mutasi.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="anggota_id">Anggota <span class="text-danger">*</span></label>
                                    <select name="anggota_id" id="anggota_id" class="form-control @error('anggota_id') is-invalid @enderror" required>
                                        <option value="">-- Pilih Anggota --</option>
                                        @foreach($anggotas as $anggota)
                                            <option value="{{ $anggota->id }}" {{ old('anggota_id') == $anggota->id ? 'selected' : '' }}>
                                                {{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('anggota_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="jenis_mutasi">Jenis Mutasi <span class="text-danger">*</span></label>
                                    <select name="jenis_mutasi" id="jenis_mutasi" class="form-control @error('jenis_mutasi') is-invalid @enderror" required>
                                        <option value="">-- Pilih Jenis Mutasi --</option>
                                        <option value="Keluar" {{ old('jenis_mutasi') == 'Keluar' ? 'selected' : '' }}>Keluar</option>
                                        <option value="Penempatan" {{ old('jenis_mutasi') == 'Penempatan' ? 'selected' : '' }}>Penempatan</option>
                                        <option value="Rekomposisi" {{ old('jenis_mutasi') == 'Rekomposisi' ? 'selected' : '' }}>Rekomposisi</option>
                                    </select>
                                    @error('jenis_mutasi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="tanggal_mutasi">Tanggal Mutasi <span class="text-danger">*</span></label>
                                    <input type="date" name="tanggal_mutasi" id="tanggal_mutasi" 
                                           class="form-control @error('tanggal_mutasi') is-invalid @enderror" 
                                           value="{{ old('tanggal_mutasi', date('Y-m-d')) }}" required>
                                    @error('tanggal_mutasi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <h5 class="mb-3 mt-4">Data Asal</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="dpd_asal">DPD Asal</label>
                                    <input type="text" id="dpd_asal_display" class="form-control" readonly placeholder="(Otomatis terisi saat memilih anggota)">
                                    <input type="hidden" name="dpd_asal" id="dpd_asal">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="dpc_asal">DPC Asal</label>
                                    <input type="text" id="dpc_asal_display" class="form-control" readonly placeholder="(Otomatis terisi saat memilih anggota)">
                                    <input type="hidden" name="dpc_asal" id="dpc_asal">
                                </div>
                            </div>
                        </div>

                        <h5 class="mb-3 mt-4">Data Tujuan</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="dpd_tujuan">DPD Tujuan <span class="text-danger">*</span></label>
                                    <select name="dpd_tujuan" id="dpd_tujuan" class="form-control @error('dpd_tujuan') is-invalid @enderror" required>
                                        <option value="">-- Pilih DPD Tujuan --</option>
                                        @foreach($dpds as $dpd)
                                            <option value="{{ $dpd->dpd_id }}" {{ old('dpd_tujuan') == $dpd->dpd_id ? 'selected' : '' }}>
                                                {{ $dpd->nama_dpd }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpd_tujuan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="dpc_tujuan">DPC Tujuan <small class="text-muted">(Opsional)</small></label>
                                    <select name="dpc_tujuan" id="dpc_tujuan" class="form-control @error('dpc_tujuan') is-invalid @enderror" disabled>
                                        <option value="">-- Pilih DPD Tujuan terlebih dahulu --</option>
                                    </select>
                                    @error('dpc_tujuan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="alasan_mutasi">Alasan Pindah <span class="text-danger">*</span></label>
                            <select name="alasan_mutasi" id="alasan_mutasi" class="form-control @error('alasan_mutasi') is-invalid @enderror" required>
                                <option value="">-- Pilih Alasan --</option>
                                <option value="Pindah Domisili" {{ old('alasan_mutasi') == 'Pindah Domisili' ? 'selected' : '' }}>Pindah Domisili</option>
                                <option value="Pindah Kerja" {{ old('alasan_mutasi') == 'Pindah Kerja' ? 'selected' : '' }}>Pindah Kerja</option>
                                <option value="Keluarga" {{ old('alasan_mutasi') == 'Keluarga' ? 'selected' : '' }}>Alasan Keluarga</option>
                                <option value="Lainnya" {{ old('alasan_mutasi') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                            </select>
                            @error('alasan_mutasi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="alamat_tujuan">Alamat Tujuan <span class="text-danger">*</span></label>
                            <textarea name="alamat_tujuan" id="alamat_tujuan" class="form-control @error('alamat_tujuan') is-invalid @enderror" rows="3" 
                                      placeholder="Masukkan alamat lengkap tujuan" required>{{ old('alamat_tujuan') }}</textarea>
                            @error('alamat_tujuan')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group mb-3">
                            <label for="catatan">Catatan</label>
                            <textarea name="catatan" id="catatan" class="form-control" rows="3" 
                                      placeholder="Catatan tambahan (opsional)">{{ old('catatan') }}</textarea>
                        </div>

                        <div class="form-check mb-3">
                            <input type="checkbox" name="langsung_setujui" id="langsung_setujui" class="form-check-input" 
                                   value="1" {{ old('langsung_setujui') ? 'checked' : '' }}>
                            <label for="langsung_setujui" class="form-check-label">
                                <strong>Setujui dan generate nomor SK langsung</strong>
                            </label>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Mutasi
                            </button>
                            <a href="{{ route('mutasi.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const anggotaSelect = document.getElementById('anggota_id');
    const dpdSelect = document.getElementById('dpd_tujuan');
    const dpcSelect = document.getElementById('dpc_tujuan');
    const dpdAsalDisplay = document.getElementById('dpd_asal_display');
    const dpdAsalInput = document.getElementById('dpd_asal');
    const dpcAsalDisplay = document.getElementById('dpc_asal_display');
    const dpcAsalInput = document.getElementById('dpc_asal');
    
    // Auto-populate DPC and DPD Asal when Anggota is selected
    anggotaSelect.addEventListener('change', function() {
        const anggotaId = this.value;
        console.log('Anggota selected:', anggotaId);
        
        // Reset fields
        dpdAsalDisplay.value = '';
        dpdAsalInput.value = '';
        dpcAsalDisplay.value = '';
        dpcAsalInput.value = '';
        
        if (anggotaId) {
            // Fetch Anggota details
            const url = `{{ route('mutasi.get-anggota-details') }}?anggota_id=${anggotaId}`;
            console.log('Fetching URL:', url);
            
            fetch(url, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'same-origin'
            })
                .then(response => {
                    console.log('Response status:', response.status);
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    console.log('Anggota data received:', data);
                    
                    // Populate DPD Asal
                    if (data.dpd_nama) {
                        dpdAsalDisplay.value = data.dpd_nama;
                        dpdAsalInput.value = data.dpd_id;
                    } else {
                        dpdAsalDisplay.value = '(Tidak ada data DPD)';
                    }
                    
                    // Populate DPC Asal
                    if (data.dpc_nama) {
                        dpcAsalDisplay.value = data.dpc_nama;
                        dpcAsalInput.value = data.dpc_id;
                    } else {
                        dpcAsalDisplay.value = '(Tidak ada data DPC)';
                    }
                })
                .catch(error => {
                    console.error('Error fetching Anggota details:', error);
                    dpdAsalDisplay.value = 'Error loading data';
                    dpcAsalDisplay.value = 'Error loading data';
                });
        }
    });
    
    // Handle DPD Tujuan change to populate DPC Tujuan
    dpdSelect.addEventListener('change', function() {
        const dpdId = this.value;
        console.log('DPD selected:', dpdId);
        
        // Reset DPC select
        dpcSelect.innerHTML = '<option value="">-- Pilih DPC Tujuan (Opsional) --</option>';
        dpcSelect.disabled = true;
        
        if (dpdId) {
            // Fetch DPCs based on selected DPD
            const url = `{{ route('mutasi.get-dpc-by-dpd') }}?dpd_id=${dpdId}`;
            console.log('Fetching URL:', url);
            
            fetch(url, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'same-origin'
            })
                .then(response => {
                    console.log('Response status:', response.status);
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    console.log('DPC data received:', data);
                    dpcSelect.disabled = false;
                    dpcSelect.innerHTML = '<option value="">-- Pilih DPC Tujuan (Opsional) --</option>';
                    
                    if (data && data.length > 0) {
                        data.forEach(dpc => {
                            const option = document.createElement('option');
                            option.value = dpc.dpc_id;
                            option.textContent = dpc.nama_dpc;
                            dpcSelect.appendChild(option);
                        });
                    } else {
                        dpcSelect.innerHTML = '<option value="">Tidak ada DPC untuk DPD ini</option>';
                    }
                })
                .catch(error => {
                    console.error('Error fetching DPCs:', error);
                    dpcSelect.innerHTML = '<option value="">Error loading DPCs</option>';
                });
        }
    });
});
</script>
@endsection