@extends('mobile.layout')

@section('title', 'Profil - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-user text-3xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">{{ $anggota->nama_lengkap }}</h2>
                <p class="text-orange-100 text-sm">{{ $anggota->refJenjang->nama_jenjang ?? 'Anggota' }}</p>
            </div>
        </div>
    </div>

    <!-- Profile Info -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Informasi Profil</h3>
        
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Nama Lengkap:</span>
                <span class="font-medium">{{ $anggota->nama_lengkap }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">NIK:</span>
                <span class="font-medium">{{ $anggota->nik }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Jenis Kelamin:</span>
                <span class="font-medium">{{ $anggota->jenis_kelamin }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Tanggal Lahir:</span>
                <span class="font-medium">{{ \Carbon\Carbon::parse($anggota->tanggal_lahir)->format('d M Y') }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">No. Telepon:</span>
                <span class="font-medium">{{ $anggota->no_telepon ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Email:</span>
                <span class="font-medium">{{ $anggota->email ?? '-' }}</span>
            </div>
        </div>
    </div>

    <!-- Organizational Info -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Informasi Organisasi</h3>
        
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Status Keanggotaan:</span>
                <span class="mobile-badge mobile-badge-success">{{ $anggota->status_keanggotaan }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Jenjang:</span>
                <span class="font-medium">{{ $anggota->refJenjang->nama_jenjang ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Struktur:</span>
                <span class="font-medium">{{ $anggota->strukturOrganisasi->nama_struktur ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">DPC:</span>
                <span class="font-medium">{{ $anggota->dpc->nama_dpc ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Tanggal Bergabung:</span>
                <span class="font-medium">{{ \Carbon\Carbon::parse($anggota->tanggal_bergabung)->format('d M Y') }}</span>
            </div>
        </div>
    </div>

    <!-- Contact Info -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Informasi Kontak</h3>
        
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Alamat:</span>
                <span class="font-medium text-right">{{ $anggota->alamat ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Kecamatan:</span>
                <span class="font-medium">{{ $anggota->refKecamatan->nama_kecamatan ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Kota:</span>
                <span class="font-medium">{{ $anggota->refKota->nama_kota ?? '-' }}</span>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-2 gap-4">
        <div class="mobile-card text-center">
            <div class="text-2xl font-bold text-orange-500">{{ $anggota->absensiKegiatan()->count() }}</div>
            <div class="text-sm text-gray-600">Total Kehadiran</div>
        </div>
        
        <div class="mobile-card text-center">
            <div class="text-2xl font-bold text-green-500">{{ $anggota->mutasi()->count() }}</div>
            <div class="text-sm text-gray-600">Total Mutasi</div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="mobile-card">
        <div class="space-y-3">
            <button onclick="toggleEditForm()" class="mobile-button mobile-button-primary w-full">
                <i class="fas fa-edit mr-2"></i>
                Edit Profil
            </button>
            
            <a href="{{ route('logout') }}" class="mobile-button mobile-button-danger w-full" 
               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="fas fa-sign-out-alt mr-2"></i>
                Keluar
            </a>
        </div>
    </div>

    <!-- Edit Form (Hidden by default) -->
    <div id="edit-form" class="mobile-card" style="display: none;">
        <h3 class="font-semibold text-gray-800 mb-3">Edit Profil</h3>
        
        <form id="profile-form">
            @csrf
            
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">No. Telepon</label>
                    <input type="tel" name="no_telepon" value="{{ $anggota->no_telepon }}" 
                           class="mobile-input" placeholder="Masukkan nomor telepon">
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" value="{{ $anggota->email }}" 
                           class="mobile-input" placeholder="Masukkan email">
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Alamat</label>
                    <textarea name="alamat" rows="3" class="mobile-textarea" 
                              placeholder="Masukkan alamat lengkap">{{ $anggota->alamat }}</textarea>
                </div>
            </div>
            
            <div class="flex space-x-3 mt-4">
                <button type="button" onclick="toggleEditForm()" class="mobile-button mobile-button-secondary flex-1">
                    <i class="fas fa-times mr-2"></i>
                    Batal
                </button>
                
                <button type="submit" class="mobile-button mobile-button-primary flex-1">
                    <i class="fas fa-save mr-2"></i>
                    Simpan
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Logout Form -->
<form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
    @csrf
</form>
@endsection

@push('scripts')
<script>
function toggleEditForm() {
    const editForm = document.getElementById('edit-form');
    if (editForm.style.display === 'none') {
        editForm.style.display = 'block';
    } else {
        editForm.style.display = 'none';
    }
}

// Profile form submission
document.getElementById('profile-form').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    try {
        // Show loading state
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Menyimpan...';
        submitBtn.disabled = true;
        
        const formData = new FormData(form);
        
        const response = await fetch('/mobile/profile/update', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            // Hide edit form
            toggleEditForm();
            // Reload page after 2 seconds
            setTimeout(() => location.reload(), 2000);
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        showAlert('Terjadi kesalahan saat menyimpan profil', 'danger');
    } finally {
        // Reset button state
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    }
});

function showAlert(message, type) {
    const alertContainer = document.getElementById('alert-container');
    const alert = document.createElement('div');
    alert.className = `mobile-alert mobile-alert-${type} mobile-slide-up`;
    alert.innerHTML = `
        <div class="flex items-center justify-between">
            <span>${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-lg">&times;</button>
        </div>
    `;
    alertContainer.appendChild(alert);
    
    setTimeout(() => {
        if (alert.parentElement) {
            alert.remove();
        }
    }, 5000);
}
</script>
@endpush
