@extends('mobile.layout')

@section('title', 'Mutasi - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-exchange-alt text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Pengajuan Mutasi</h2>
                <p class="text-orange-100 text-sm">Kelola pengajuan mutasi Anda</p>
            </div>
        </div>
    </div>

    <!-- Quick Action -->
    <div class="mobile-card">
        <a href="{{ route('mobile.mutasi.create') }}" class="mobile-button mobile-button-primary w-full">
            <i class="fas fa-plus mr-2"></i>
            Ajukan Mutasi Baru
        </a>
    </div>

    <!-- Mutasi List -->
    @if($mutasi->count() > 0)
    <div class="space-y-3">
        @foreach($mutasi as $item)
        <div class="mobile-card mobile-touchable" onclick="location.href='{{ route('mobile.mutasi.show', $item) }}'">
            <div class="flex items-start justify-between">
                <div class="flex-1">
                    <h3 class="font-semibold text-gray-800 mb-2">{{ ucfirst($item->jenis_mutasi) }}</h3>
                    
                    <div class="space-y-1 text-sm text-gray-600">
                        <div class="flex items-center">
                            <i class="fas fa-calendar w-4 mr-2"></i>
                            <span>Diajukan: {{ \Carbon\Carbon::parse($item->created_at)->format('d M Y') }}</span>
                        </div>
                        
                        @if($item->strukturDari)
                        <div class="flex items-center">
                            <i class="fas fa-arrow-left w-4 mr-2"></i>
                            <span>Dari: {{ $item->strukturDari->nama_struktur }}</span>
                        </div>
                        @endif
                        
                        @if($item->strukturKe)
                        <div class="flex items-center">
                            <i class="fas fa-arrow-right w-4 mr-2"></i>
                            <span>Ke: {{ $item->strukturKe->nama_struktur }}</span>
                        </div>
                        @endif
                    </div>
                </div>
                
                <div class="text-right">
                    @php
                        $statusClass = match($item->status_mutasi) {
                            'Pending' => 'mobile-badge-warning',
                            'Disetujui' => 'mobile-badge-success',
                            'Ditolak' => 'mobile-badge-danger',
                            default => 'mobile-badge-secondary'
                        };
                    @endphp
                    
                    <div class="mobile-badge {{ $statusClass }} mb-2">
                        {{ $item->status_mutasi }}
                    </div>
                    
                    <i class="fas fa-arrow-right text-orange-500"></i>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Pagination -->
    @if($mutasi->hasPages())
    <div class="mobile-card">
        <div class="flex items-center justify-between">
            <div class="text-sm text-gray-600">
                Menampilkan {{ $mutasi->firstItem() }} - {{ $mutasi->lastItem() }} dari {{ $mutasi->total() }} pengajuan
            </div>
            
            <div class="flex space-x-2">
                @if($mutasi->previousPageUrl())
                    <a href="{{ $mutasi->previousPageUrl() }}" class="mobile-button mobile-button-secondary">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                @endif
                
                @if($mutasi->nextPageUrl())
                    <a href="{{ $mutasi->nextPageUrl() }}" class="mobile-button mobile-button-secondary">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                @endif
            </div>
        </div>
    </div>
    @endif

    @else
    <!-- Empty State -->
    <div class="mobile-card text-center py-8">
        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-exchange-alt text-3xl text-gray-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-800 mb-2">Belum Ada Pengajuan</h3>
        <p class="text-gray-600 mb-4">Anda belum pernah mengajukan mutasi</p>
        <a href="{{ route('mobile.mutasi.create') }}" class="mobile-button mobile-button-primary">
            <i class="fas fa-plus mr-2"></i>
            Ajukan Mutasi Pertama
        </a>
    </div>
    @endif
</div>
@endsection
