@extends('mobile.layout')

@section('title', 'Ajukan Mutasi - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-exchange-alt text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Ajukan Mutasi</h2>
                <p class="text-orange-100 text-sm">Form pengajuan mutasi anggota</p>
            </div>
        </div>
    </div>

    <!-- Current Profile Info -->
    <div class="mobile-card">
        <h3 class="font-semibold text-gray-800 mb-3">Profil Saat Ini</h3>
        
        <div class="space-y-2">
            <div class="flex justify-between">
                <span class="text-gray-600">Nama:</span>
                <span class="font-medium">{{ $anggota->nama_lengkap }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">Struktur:</span>
                <span class="font-medium">{{ $anggota->strukturOrganisasi->nama_struktur ?? '-' }}</span>
            </div>
            
            <div class="flex justify-between">
                <span class="text-gray-600">DPC:</span>
                <span class="font-medium">{{ $anggota->dpc->nama_dpc ?? '-' }}</span>
            </div>
        </div>
    </div>

    <!-- Mutasi Form -->
    <form id="mutasi-form" class="space-y-4">
        @csrf
        
        <!-- Jenis Mutasi (Hidden - Default to Mutasi) -->
        <input type="hidden" name="jenis_mutasi" value="Mutasi">

        <!-- Tujuan Mutasi -->
        <div class="mobile-card">
            <h3 class="font-semibold text-gray-800 mb-3">Tujuan Mutasi</h3>
            
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Pilih DPC Tujuan</label>
                    <select name="struktur_ke" id="struktur_ke" class="mobile-select" required>
                        <option value="">Pilih DPC Tujuan</option>
                        @foreach($dpcList as $dpc)
                        <option value="{{ $dpc->struktur_organisasi_id }}">{{ $dpc->nama_dpc }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Alasan Mutasi -->
        <div class="mobile-card">
            <h3 class="font-semibold text-gray-800 mb-3">Alasan Mutasi</h3>
            
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Alasan</label>
                    <textarea name="alasan_mutasi" id="alasan_mutasi" rows="4" class="mobile-textarea" 
                              placeholder="Jelaskan alasan mengapa Anda ingin melakukan mutasi..." required></textarea>
                </div>
            </div>
        </div>

        <!-- Alamat Tujuan -->
        <div class="mobile-card">
            <h3 class="font-semibold text-gray-800 mb-3">Alamat Tujuan</h3>
            
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Alamat Lengkap (Opsional)</label>
                    <textarea name="alamat_tujuan" id="alamat_tujuan" rows="3" class="mobile-textarea" 
                              placeholder="Masukkan alamat tujuan..."></textarea>
                </div>
            </div>
        </div>

        <!-- Catatan Tambahan -->
        <div class="mobile-card">
            <h3 class="font-semibold text-gray-800 mb-3">Catatan Tambahan</h3>
            
            <div class="space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Catatan (Opsional)</label>
                    <textarea name="catatan" id="catatan" rows="3" class="mobile-textarea" 
                              placeholder="Tambahkan catatan atau informasi lain yang relevan..."></textarea>
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <div class="mobile-card">
            <button type="submit" id="submit-mutasi" class="mobile-button mobile-button-primary w-full">
                <i class="fas fa-paper-plane mr-2"></i>
                Ajukan Mutasi
            </button>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('mutasi-form');
    
    // Form submission
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const submitBtn = document.getElementById('submit-mutasi');
        const originalText = submitBtn.innerHTML;
        
        try {
            // Show loading state
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengirim...';
            submitBtn.disabled = true;
            
            const formData = new FormData(form);
            
            const response = await fetch('/mobile/mutasi/submit', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: formData
            });
            
            const data = await response.json();
            
            if (data.success) {
                showAlert(data.message, 'success');
                // Redirect to mutasi list after 2 seconds
                setTimeout(() => {
                    window.location.href = '/mobile/mutasi';
                }, 2000);
            } else {
                showAlert(data.message, 'danger');
            }
        } catch (error) {
            showAlert('Terjadi kesalahan saat mengirim pengajuan', 'danger');
        } finally {
            // Reset button state
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }
    });
});

function showAlert(message, type) {
    const alertContainer = document.getElementById('alert-container');
    const alert = document.createElement('div');
    alert.className = `mobile-alert mobile-alert-${type} mobile-slide-up`;
    alert.innerHTML = `
        <div class="flex items-center justify-between">
            <span>${message}</span>
            <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-lg">&times;</button>
        </div>
    `;
    alertContainer.appendChild(alert);
    
    setTimeout(() => {
        if (alert.parentElement) {
            alert.remove();
        }
    }, 5000);
}
</script>
@endpush
