<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'PKS Mobile')</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="{{ asset('favicon.svg') }}">
    
    <!-- Mobile CSS -->
    @vite(['resources/css/mobile.css'])
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    @stack('styles')
</head>
<body class="bg-gray-50">
    <!-- Mobile Container -->
    <div class="mobile-container">
        <!-- Mobile Header -->
        <header class="mobile-header">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    @if(request()->routeIs('mobile.dashboard'))
                        <h1 class="text-lg font-semibold">Dashboard</h1>
                    @elseif(request()->routeIs('mobile.attendance*'))
                        <h1 class="text-lg font-semibold">Absensi</h1>
                    @elseif(request()->routeIs('mobile.mutasi*'))
                        <h1 class="text-lg font-semibold">Mutasi</h1>
                    @elseif(request()->routeIs('mobile.profile'))
                        <h1 class="text-lg font-semibold">Profil</h1>
                    @else
                        <h1 class="text-lg font-semibold">PKS Mobile</h1>
                    @endif
                </div>
                
                <div class="flex items-center space-x-2">
                    <!-- Profile Button -->
                    <a href="{{ route('mobile.profile') }}" class="text-white hover:text-orange-200">
                        <i class="fas fa-user-circle text-xl"></i>
                    </a>
                    
                    <!-- Back Button (if not dashboard) -->
                    @if(!request()->routeIs('mobile.dashboard'))
                        <button onclick="history.back()" class="text-white hover:text-orange-200">
                            <i class="fas fa-arrow-left text-xl"></i>
                        </button>
                    @endif
                </div>
            </div>
        </header>

        <!-- Mobile Content -->
        <main class="mobile-content">
            <!-- Alert Container -->
            <div id="alert-container"></div>
            
            <!-- Loading Overlay -->
            <div id="mobile-loading" style="display: none;">
                <div class="mobile-spinner"></div>
            </div>

            @yield('content')
        </main>

        <!-- Mobile Bottom Navigation -->
        <nav class="mobile-bottom-nav">
            <div class="flex">
                <a href="{{ route('mobile.dashboard') }}" class="mobile-nav-item {{ request()->routeIs('mobile.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-home mobile-nav-icon"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="{{ route('mobile.attendance') }}" class="mobile-nav-item {{ request()->routeIs('mobile.attendance*') ? 'active' : '' }}">
                    <i class="fas fa-calendar-check mobile-nav-icon"></i>
                    <span>Absensi</span>
                </a>
                
                <a href="{{ route('mobile.mutasi') }}" class="mobile-nav-item {{ request()->routeIs('mobile.mutasi*') ? 'active' : '' }}">
                    <i class="fas fa-exchange-alt mobile-nav-icon"></i>
                    <span>Mutasi</span>
                </a>
                
                <a href="{{ route('mobile.profile') }}" class="mobile-nav-item {{ request()->routeIs('mobile.profile') ? 'active' : '' }}">
                    <i class="fas fa-user mobile-nav-icon"></i>
                    <span>Profil</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Mobile JavaScript -->
    @vite(['resources/js/mobile.js'])
    
    @stack('scripts')
</body>
</html>
