@extends('mobile.layout')

@section('title', 'Absensi - PKS Mobile')

@section('content')
<div class="space-y-4">
    <!-- Header Card -->
    <div class="mobile-card bg-gradient-to-r from-orange-500 to-orange-600 text-white">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                <i class="fas fa-calendar-check text-2xl"></i>
            </div>
            <div>
                <h2 class="text-lg font-semibold">Absensi Kegiatan</h2>
                <p class="text-orange-100 text-sm">Lihat dan lakukan absensi kegiatan</p>
            </div>
        </div>
    </div>

    <!-- Filter Options -->
    <div class="mobile-card">
        <div class="flex space-x-2">
            <button class="mobile-button mobile-button-primary flex-1">
                <i class="fas fa-list mr-2"></i>
                Semua
            </button>
            <button class="mobile-button mobile-button-secondary flex-1">
                <i class="fas fa-calendar mr-2"></i>
                Mendatang
            </button>
        </div>
    </div>

    <!-- Activities List -->
    @if($kegiatan->count() > 0)
    <div class="space-y-3">
        @foreach($kegiatan as $item)
        <div class="mobile-card mobile-touchable" onclick="location.href='{{ route('mobile.attendance.detail', $item) }}'">
            <div class="flex items-start justify-between">
                <div class="flex-1">
                    <h3 class="font-semibold text-gray-800 mb-2">{{ $item->nama_kegiatan }}</h3>
                    
                    <div class="space-y-1 text-sm text-gray-600">
                        <div class="flex items-center">
                            <i class="fas fa-calendar w-4 mr-2"></i>
                            <span>{{ \Carbon\Carbon::parse($item->tanggal_kegiatan)->format('d M Y') }}</span>
                        </div>
                        
                        <div class="flex items-center">
                            <i class="fas fa-clock w-4 mr-2"></i>
                            <span>{{ \Carbon\Carbon::parse($item->waktu_mulai)->format('H:i') }} - {{ \Carbon\Carbon::parse($item->waktu_selesai)->format('H:i') }}</span>
                        </div>
                        
                        <div class="flex items-center">
                            <i class="fas fa-map-marker-alt w-4 mr-2"></i>
                            <span>{{ $item->tempat }}</span>
                        </div>
                    </div>
                </div>
                
                <div class="text-right">
                    @php
                        $statusClass = match($item->status_kegiatan) {
                            'Direncanakan' => 'mobile-badge-info',
                            'Berlangsung' => 'mobile-badge-success',
                            'Selesai' => 'mobile-badge-secondary',
                            'Dibatalkan' => 'mobile-badge-danger',
                            default => 'mobile-badge-secondary'
                        };
                    @endphp
                    
                    <div class="mobile-badge {{ $statusClass }} mb-2">
                        {{ $item->status_kegiatan }}
                    </div>
                    
                    <i class="fas fa-arrow-right text-orange-500"></i>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Pagination -->
    @if($kegiatan->hasPages())
    <div class="mobile-card">
        <div class="flex items-center justify-between">
            <div class="text-sm text-gray-600">
                Menampilkan {{ $kegiatan->firstItem() }} - {{ $kegiatan->lastItem() }} dari {{ $kegiatan->total() }} kegiatan
            </div>
            
            <div class="flex space-x-2">
                @if($kegiatan->previousPageUrl())
                    <a href="{{ $kegiatan->previousPageUrl() }}" class="mobile-button mobile-button-secondary">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                @endif
                
                @if($kegiatan->nextPageUrl())
                    <a href="{{ $kegiatan->nextPageUrl() }}" class="mobile-button mobile-button-secondary">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                @endif
            </div>
        </div>
    </div>
    @endif

    @else
    <!-- Empty State -->
    <div class="mobile-card text-center py-8">
        <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-calendar-times text-3xl text-gray-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-gray-800 mb-2">Tidak Ada Kegiatan</h3>
        <p class="text-gray-600 mb-4">Belum ada kegiatan yang tersedia untuk absensi</p>
        <button onclick="location.reload()" class="mobile-button mobile-button-primary">
            <i class="fas fa-refresh mr-2"></i>
            Muat Ulang
        </button>
    </div>
    @endif
</div>
@endsection
