@extends('layouts.app')

@section('title', 'Detail Komposisi UPA - ' . $upa->nama_upa)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-users mr-2"></i>
                        Detail Komposisi UPA: {{ $upa->nama_upa }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('komposisi.print-upa', $upa->upa_id) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print mr-1"></i>
                            Print
                        </a>
                        <a href="{{ route('komposisi.show-dpc', $upa->dpc->dpc_id) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Kembali ke DPC
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Informasi UPA -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Informasi UPA</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td width="150"><strong>Nama UPA:</strong></td>
                                            <td>{{ $upa->nama_upa }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Kode UPA:</strong></td>
                                            <td>{{ $upa->kode_upa }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>DPC:</strong></td>
                                            <td>{{ $upa->dpc->nama_dpc }} ({{ $upa->dpc->dpd->nama_dpd ?? 'N/A' }})</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Alamat:</strong></td>
                                            <td>{{ $upa->alamat ?? '-' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Lokasi:</strong></td>
                                            <td>
                                                {{ $upa->refKelurahan->nama_kelurahan ?? '' }}
                                                {{ $upa->refKecamatan->nama_kecamatan ?? '' }}
                                                {{ $upa->refKota->nama_kota ?? '' }}
                                                {{ $upa->refProvinsi->nama_provinsi ?? '' }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status:</strong></td>
                                            <td>
                                                <span class="badge badge-success">{{ $upa->status }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Tanggal Berdiri:</strong></td>
                                            <td>{{ $upa->tanggal_berdiri ? $upa->tanggal_berdiri->format('d F Y') : '-' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Statistik</h5>
                                </div>
                                <div class="card-body">
                                    <div class="info-box mb-3">
                                        <span class="info-box-icon bg-info">
                                            <i class="fas fa-user-tie"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Pembimbing</span>
                                            <span class="info-box-number">{{ $statistikUpa['pembimbing_aktif']->count() }}</span>
                                        </div>
                                    </div>
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success">
                                            <i class="fas fa-user-friends"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Anggota Aktif</span>
                                            <span class="info-box-number">{{ $statistikUpa['total_anggota'] }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Statistik per Jenjang -->
                    @if($statistikUpa['statistik_jenjang']->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Distribusi Anggota per Jenjang</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        @foreach($statistikUpa['statistik_jenjang'] as $jenjang)
                                        <div class="col-md-3 col-sm-6">
                                            <div class="small-box bg-light">
                                                <div class="inner">
                                                    <h3>{{ $jenjang->total }}</h3>
                                                    <p>{{ $jenjang->jenjang }}</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fas fa-graduation-cap"></i>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Pembimbing Aktif -->
                    @if($statistikUpa['pembimbing_aktif']->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Pembimbing Aktif</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>No</th>
                                                    <th>Nama Lengkap</th>
                                                    <th>Jenjang</th>
                                                    <th>Jabatan</th>
                                                    <th>Tanggal Mulai</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($statistikUpa['pembimbing_aktif'] as $index => $pembimbing)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $pembimbing->nama_lengkap }}</td>
                                                    <td>
                                                        <span class="badge badge-info">
                                                            {{ $pembimbing->refJenjang->jenjang ?? 'N/A' }}
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-primary">
                                                            {{ $pembimbing->pivot->jabatan ?? 'N/A' }}
                                                        </span>
                                                    </td>
                                                    <td>{{ $pembimbing->pivot->tanggal_mulai ? \Carbon\Carbon::parse($pembimbing->pivot->tanggal_mulai)->format('d F Y') : '-' }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Daftar Anggota Aktif -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Daftar Anggota Aktif</h5>
                                </div>
                                <div class="card-body">
                                    @if($upa->anggotaAktif->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>No</th>
                                                        <th>Nama Lengkap</th>
                                                        <th>Jenjang</th>
                                                        <th>Jenis Kelamin</th>
                                                        <th>Kota</th>
                                                        <th>Tanggal Bergabung</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($upa->anggotaAktif as $index => $anggota)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $anggota->nama_lengkap }}</td>
                                                        <td>
                                                            <span class="badge badge-info">
                                                                {{ $anggota->refJenjang->jenjang ?? 'N/A' }}
                                                            </span>
                                                        </td>
                                                        <td>{{ $anggota->jenis_kelamin }}</td>
                                                        <td>{{ $anggota->kota }}</td>
                                                        <td>{{ $anggota->tanggal_bergabung ? \Carbon\Carbon::parse($anggota->tanggal_bergabung)->format('d F Y') : '-' }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            Belum ada anggota aktif di UPA ini.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.small-box {
    border-radius: 0.25rem;
    position: relative;
    display: block;
    margin-bottom: 20px;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.small-box .inner {
    padding: 10px;
}

.small-box .inner h3 {
    font-size: 2.2rem;
    font-weight: bold;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}

.small-box .inner p {
    font-size: 1rem;
    margin: 0;
}

.small-box .icon {
    transition: all .3s linear;
    position: absolute;
    top: -10px;
    right: 10px;
    z-index: 0;
    font-size: 90px;
    color: rgba(0,0,0,0.15);
}
</style>
@endpush
