@extends('layouts.app')

@section('title', 'Detail Komposisi DPC - ' . $dpc->nama_dpc)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-building mr-2"></i>
                        Detail Komposisi DPC: {{ $dpc->nama_dpc }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('komposisi.print-dpc', $dpc->dpc_id) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print mr-1"></i>
                            Print
                        </a>
                        <a href="{{ route('komposisi.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Informasi DPC -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Informasi DPC</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td width="150"><strong>Nama DPC:</strong></td>
                                            <td>{{ $dpc->nama_dpc }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Kode DPC:</strong></td>
                                            <td>{{ $dpc->kode_dpc }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>DPD:</strong></td>
                                            <td>{{ $dpc->dpd->nama_dpd ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Deskripsi:</strong></td>
                                            <td>{{ $dpc->deskripsi ?? '-' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Statistik</h5>
                                </div>
                                <div class="card-body">
                                    <div class="info-box mb-3">
                                        <span class="info-box-icon bg-info">
                                            <i class="fas fa-users"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total UPA</span>
                                            <span class="info-box-number">{{ $statistikDpc['total_upa'] }}</span>
                                        </div>
                                    </div>
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success">
                                            <i class="fas fa-user-friends"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Anggota</span>
                                            <span class="info-box-number">{{ $statistikDpc['total_anggota'] }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Statistik per Jenjang -->
                    @if($statistikDpc['statistik_jenjang']->count() > 0)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Distribusi Anggota per Jenjang</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        @foreach($statistikDpc['statistik_jenjang'] as $jenjang)
                                        <div class="col-md-3 col-sm-6">
                                            <div class="small-box bg-light">
                                                <div class="inner">
                                                    <h3>{{ $jenjang->total }}</h3>
                                                    <p>{{ $jenjang->jenjang }}</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fas fa-graduation-cap"></i>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Daftar UPA -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Daftar UPA di DPC ini</h5>
                                </div>
                                <div class="card-body">
                                    @if($dpc->upa->count() > 0)
                                        <div class="row">
                                            @foreach($dpc->upa as $upa)
                                            <div class="col-lg-6 col-xl-4 mb-3">
                                                <div class="card card-widget widget-user-2">
                                                    <div class="widget-user-header bg-success">
                                                        <div class="widget-user-image">
                                                            <i class="fas fa-users fa-2x"></i>
                                                        </div>
                                                        <h3 class="widget-user-username">{{ $upa->nama_upa }}</h3>
                                                        <h5 class="widget-user-desc">{{ $upa->kode_upa }}</h5>
                                                    </div>
                                                    <div class="card-footer p-0">
                                                        <ul class="nav flex-column">
                                                            <li class="nav-item">
                                                                <a href="#" class="nav-link">
                                                                    Pembimbing
                                                                    <span class="float-right badge bg-primary">{{ $upa->pembimbingAktif->count() }}</span>
                                                                </a>
                                                            </li>
                                                            <li class="nav-item">
                                                                <a href="#" class="nav-link">
                                                                    Anggota Aktif
                                                                    <span class="float-right badge bg-info">{{ $upa->anggotaAktif->count() }}</span>
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="card-footer">
                                                        <div class="row">
                                                            <div class="col-6">
                                                                <a href="{{ route('komposisi.show-upa', $upa->upa_id) }}" class="btn btn-success btn-sm btn-block">
                                                                    <i class="fas fa-eye mr-1"></i>
                                                                    Detail
                                                                </a>
                                                            </div>
                                                            <div class="col-6">
                                                                <a href="{{ route('komposisi.print-upa', $upa->upa_id) }}" class="btn btn-warning btn-sm btn-block" target="_blank">
                                                                    <i class="fas fa-print mr-1"></i>
                                                                    Print
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            Belum ada UPA yang terdaftar di DPC ini.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.widget-user-2 .widget-user-image {
    position: absolute;
    top: 15px;
    left: 15px;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
}

.widget-user-2 .widget-user-header {
    padding: 20px 20px 20px 80px;
}

.small-box {
    border-radius: 0.25rem;
    position: relative;
    display: block;
    margin-bottom: 20px;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.small-box .inner {
    padding: 10px;
}

.small-box .inner h3 {
    font-size: 2.2rem;
    font-weight: bold;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}

.small-box .inner p {
    font-size: 1rem;
    margin: 0;
}

.small-box .icon {
    transition: all .3s linear;
    position: absolute;
    top: -10px;
    right: 10px;
    z-index: 0;
    font-size: 90px;
    color: rgba(0,0,0,0.15);
}
</style>
@endpush
