<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Surat Keputusan Rekomposisi UPA</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        
        .print-container {
            background: white;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            max-width: 100%;
        }
        
        .sk-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .sk-title {
            font-size: 14px;
            font-weight: bold;
            margin: 0 0 5px 0;
            text-transform: uppercase;
        }
        
        .sk-subtitle {
            font-size: 12px;
            margin: 0 0 5px 0;
        }
        
        .sk-number {
            font-size: 11px;
            margin: 0 0 10px 0;
        }
        
        .sk-about {
            font-size: 12px;
            font-weight: bold;
            margin: 0 0 20px 0;
            text-align: center;
        }
        
        .sk-content {
            margin-bottom: 30px;
        }
        
        .sk-section {
            margin-bottom: 15px;
        }
        
        .sk-section-title {
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .sk-section-content {
            margin-left: 20px;
            text-align: justify;
        }
        
        .sk-section-content p {
            margin: 0 0 5px 0;
        }
        
        .sk-decision {
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            font-size: 14px;
        }
        
        .sk-articles {
            margin-bottom: 30px;
        }
        
        .sk-article {
            margin-bottom: 10px;
        }
        
        .sk-article-title {
            font-weight: bold;
            display: inline-block;
            width: 80px;
        }
        
        .sk-article-content {
            display: inline-block;
            width: calc(100% - 90px);
            vertical-align: top;
        }
        
        .sk-footer {
            margin-top: 40px;
        }
        
        .sk-footer-info {
            margin-bottom: 20px;
        }
        
        .sk-footer-info p {
            margin: 0 0 5px 0;
        }
        
        .sk-signature {
            text-align: center;
            margin-top: 40px;
        }
        
        .sk-signature-title {
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .sk-signature-name {
            margin-top: 40px;
            font-weight: bold;
        }
        
        .lampiran-section {
            margin-top: 50px;
            page-break-before: always;
        }
        
        .lampiran-header {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .lampiran-title {
            font-size: 12px;
            font-weight: bold;
            margin: 0 0 10px 0;
        }
        
        .lampiran-info {
            font-size: 11px;
            margin: 0 0 20px 0;
        }
        
        .composition-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 10px;
        }
        
        .composition-table th,
        .composition-table td {
            border: 1px solid #333;
            padding: 4px 3px;
            text-align: left;
            vertical-align: top;
        }
        
        .composition-table th {
            background-color: #f8f9fa;
            font-weight: bold;
            text-align: center;
        }
        
        .upa-header-row {
            background-color: #e9ecef;
            font-weight: bold;
        }
        
        .member-row {
            background-color: #ffffff;
        }
        
        .no-col {
            width: 30px;
            text-align: center;
        }
        
        .kode-upa-col {
            width: 60px;
        }
        
        .pembimbing-col {
            width: 100px;
        }
        
        .nama-anggota-col {
            width: 150px;
        }
        
        .telp-col {
            width: 80px;
        }
        
        .dpr-col {
            width: 80px;
        }
        
        .ket-col {
            width: 100px;
        }
        
        .dpc-section {
            margin-bottom: 30px;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10px;
            }
            
            .print-container {
                box-shadow: none;
                padding: 0;
            }
            
            .lampiran-section {
                page-break-before: always;
            }
        }
    </style>
</head>
<body>
    <div class="print-container">
        <!-- Header SK -->
        <div class="sk-header">
            <div class="sk-title">SURAT KEPUTUSAN DEWAN PENGURUS DAERAH</div>
            <div class="sk-subtitle">PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
            <div class="sk-number">NOMOR : 003/D/SK/BK/AI-04-PKS/VII/2025</div>
            <div class="sk-about">TENTANG<br>REKOMPOSISI<br>UNIT PEMBINAAN ANGGOTA MADYA<br>DEWAN PENGURUS CABANG<br>KECAMATAN CAKUNG</div>
        </div>

        <!-- Isi SK -->
        <div class="sk-content">
            <div class="sk-section">
                <div class="sk-section-title">Menimbang :</div>
                <div class="sk-section-content">
                    <p>a. bahwa dalam upaya mendukung kegiatan rekrutmen, pembinaan dan melakukan kegiatan untuk pemenangan partai dilingkungan daerah Jakarta Timur;</p>
                    <p>b. bahwa dalam rangka membantu efektifitas dan memperkuat struktur partai di tingkat rukun warga, kelurahan atau kecamatan di daerah Jakarta Timur;</p>
                    <p>c. bahwa terkait dengan poin 2 tersebut diatas maka dikeluarkan Surat Keputusan.</p>
                </div>
            </div>

            <div class="sk-section">
                <div class="sk-section-title">Mengingat :</div>
                <div class="sk-section-content">
                    <p>1. Anggaran Dasar Bab IV Pasal 10 dan 11 tentang Anggota Partai;</p>
                    <p>2. Anggaran Rumah Tangga Bab III Pasal 3 tentang Anggota Partai;</p>
                    <p>3. Panduan UPA</p>
                </div>
            </div>

            <div class="sk-section">
                <div class="sk-section-title">Memperhatikan :</div>
                <div class="sk-section-content">
                    <p>Hasil Rapat Bidang Kaderisasi tanggal 02 Juli 2025</p>
                </div>
            </div>

            <div class="sk-decision">MEMUTUSKAN</div>

            <div class="sk-section">
                <div class="sk-section-title">Menetapkan :</div>
                <div class="sk-section-content">
                    <p>REKOMPOSISI UNIT PEMBINAAN ANGGOTA DEWAN PENGURUS CABANG KECAMATAN CAKUNG</p>
                </div>
            </div>
        </div>

        <!-- Footer SK -->
        <div class="sk-footer">
            <div class="sk-footer-info">
                <p><strong>Dewan Pengurus Daerah Partai Keadilan Sejahtera</strong></p>
                <p><strong>Jakarta Timur</strong></p>
                <p>Jl. Balai Pustaka No 15 A Rawamangun, Jakarta Timur</p>
                <p>Telp (021) 2247 9675</p>
                <p>https://www.jaktim.pks.id</p>
            </div>

            <div class="sk-articles">
                <div class="sk-article">
                    <span class="sk-article-title">Pertama :</span>
                    <span class="sk-article-content">Menetapkan adanya Rekomposisi UPA Madya untuk memperkuat struktur Partai Dewan Pengurus Cabang Kecamatan Cakung</span>
                </div>
                <div class="sk-article">
                    <span class="sk-article-title">Kedua :</span>
                    <span class="sk-article-content">Menetapkan Rekomposisi Unit Pembina Anggota Madya, Dewan Pengurus Cabang Kecamatan Cakung terlampir</span>
                </div>
                <div class="sk-article">
                    <span class="sk-article-title">Ketiga :</span>
                    <span class="sk-article-content">Keputusan ini berlaku sejak tanggal ditetapkan;</span>
                </div>
                <div class="sk-article">
                    <span class="sk-article-title">Keempat :</span>
                    <span class="sk-article-content">Keputusan ini akan ditinjau kembali apabila terdapat kekeliruan di kemudian hari.</span>
                </div>
            </div>

            <div class="sk-footer-info">
                <p>Ditetapkan di : Jakarta</p>
                <p>Pada tanggal : 07 Juli 2025</p>
            </div>

            <div class="sk-signature">
                <div class="sk-signature-title">DEWAN PENGURUS DAERAH PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
                <div class="sk-signature-name">Ketua,</div>
                <div class="sk-signature-name" style="margin-top: 40px;">Triyono Mukti</div>
            </div>
        </div>

        <!-- Lampiran -->
        <div class="lampiran-section">
            <div class="lampiran-header">
                <div class="lampiran-title">Lampiran SK Nomor: 036/D/SK/BK/AI-04-PKS/VII/2024</div>
                <div class="lampiran-info">
                    <strong>Tentang :</strong> Penetapan Rekomposisi Anggota Madya, Dewan Pengurus Cabang Kecamatan Cakung<br>
                    <strong>Tanggal :</strong> 07 Juli 2025
                </div>
            </div>

            <table class="composition-table">
                <thead>
                    <tr>
                        <th class="no-col">No</th>
                        <th class="kode-upa-col">KODE UPA</th>
                        <th class="pembimbing-col">Pembimbing Baru</th>
                        <th class="no-col">No</th>
                        <th class="nama-anggota-col">Nama Anggota</th>
                        <th class="telp-col">Telp</th>
                        <th class="dpr-col">DPRa</th>
                        <th class="ket-col">Ket</th>
                    </tr>
                </thead>
                <tbody>
                    @if($dpcList->count() > 0)
                        @php $rowNumber = 1; @endphp
                        @foreach($dpcList as $dpc)
                            @if($dpc->upa->count() > 0)
                                @foreach($dpc->upa as $upa)
                                    @if($upa->anggotaAktif->count() > 0)
                                        <tr class="upa-header-row">
                                            <td class="no-col">{{ $rowNumber }}</td>
                                            <td class="kode-upa">{{ $upa->kode_upa }}</td>
                                            <td class="pembimbing-baru">
                                                @if($upa->pembimbingAktif->count() > 0)
                                                    {{ $upa->pembimbingAktif->first()->nama_lengkap }}
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td class="no-col">-</td>
                                            <td class="nama-anggota-col">-</td>
                                            <td class="telp-col">-</td>
                                            <td class="dpr-col">-</td>
                                            <td class="ket-col">-</td>
                                        </tr>
                                        
                                        @foreach($upa->anggotaAktif as $index => $anggota)
                                        <tr class="member-row">
                                            <td class="no-col"></td>
                                            <td class="kode-upa"></td>
                                            <td class="pembimbing-baru"></td>
                                            <td class="no-col">{{ $index + 1 }}</td>
                                            <td class="nama-anggota-col">{{ $anggota->nama_lengkap }}</td>
                                            <td class="telp-col">{{ $anggota->no_telepon ?? '' }}</td>
                                            <td class="dpr-col">{{ $dpc->nama_dpc }}</td>
                                            <td class="ket-col"></td>
                                        </tr>
                                        @endforeach
                                        
                                        @php $rowNumber++; @endphp
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8" style="text-align: center; padding: 20px;">
                                <em>Belum ada data UPA yang terdaftar.</em>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>

            <div style="margin-top: 40px; text-align: center;">
                <div style="font-weight: bold; margin-bottom: 20px;">DEWAN PENGURUS DAERAH PARTAI KEADILAN SEJAHTERA JAKARTA TIMUR</div>
                <div style="font-weight: bold; margin-top: 40px;">Ketua</div>
                <div style="font-weight: bold; margin-top: 40px;">Triyono Mukti</div>
            </div>
        </div>
    </div>

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
