@extends('layouts.app')

@section('title', 'Komposisi DPC dan UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-sitemap mr-2"></i>
                        Komposisi DPC dan UPA
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('komposisi.print-all') }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print mr-1"></i>
                            Print Semua
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filter Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-filter mr-2"></i>
                                        Filter Komposisi
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <form method="GET" action="{{ route('komposisi.index') }}" id="filterForm">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="dpd_id">DPD</label>
                                                    <select name="dpd_id" id="dpd_id" class="form-control">
                                                        <option value="">Semua DPD</option>
                                                        @foreach($dpdList as $dpd)
                                                            <option value="{{ $dpd->dpd_id }}" 
                                                                {{ request('dpd_id') == $dpd->dpd_id ? 'selected' : '' }}>
                                                                {{ $dpd->nama_dpd }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="status_upa">Status UPA</label>
                                                    <select name="status_upa" id="status_upa" class="form-control">
                                                        <option value="">Semua Status</option>
                                                        @foreach($statusUpaOptions as $value => $label)
                                                            <option value="{{ $value }}" 
                                                                {{ request('status_upa') == $value ? 'selected' : '' }}>
                                                                {{ $label }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="jenjang_id">Jenjang Anggota</label>
                                                    <select name="jenjang_id" id="jenjang_id" class="form-control">
                                                        <option value="">Semua Jenjang</option>
                                                        @foreach($jenjangList as $jenjang)
                                                            <option value="{{ $jenjang->ref_jenjang_id }}" 
                                                                {{ request('jenjang_id') == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                                                {{ $jenjang->jenjang }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="min_anggota">Min. Jumlah Anggota</label>
                                                    <select name="min_anggota" id="min_anggota" class="form-control">
                                                        <option value="">Tidak Ada Batas</option>
                                                        <option value="1" {{ request('min_anggota') == '1' ? 'selected' : '' }}>Min. 1 Anggota</option>
                                                        <option value="5" {{ request('min_anggota') == '5' ? 'selected' : '' }}>Min. 5 Anggota</option>
                                                        <option value="10" {{ request('min_anggota') == '10' ? 'selected' : '' }}>Min. 10 Anggota</option>
                                                        <option value="20" {{ request('min_anggota') == '20' ? 'selected' : '' }}>Min. 20 Anggota</option>
                                                        <option value="50" {{ request('min_anggota') == '50' ? 'selected' : '' }}>Min. 50 Anggota</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-search mr-1"></i>
                                                    Terapkan Filter
                                                </button>
                                                <a href="{{ route('komposisi.index') }}" class="btn btn-secondary">
                                                    <i class="fas fa-times mr-1"></i>
                                                    Reset Filter
                                                </a>
                                                @if(request()->hasAny(['dpd_id', 'status_upa', 'jenjang_id', 'min_anggota']))
                                                    <a href="{{ route('komposisi.print-all', request()->query()) }}" class="btn btn-success mr-2" target="_blank">
                                                        <i class="fas fa-print mr-1"></i>
                                                        Print Hasil Filter
                                                    </a>
                                                    <a href="{{ route('komposisi.print-sk', request()->query()) }}" class="btn btn-primary" target="_blank">
                                                        <i class="fas fa-file-alt mr-1"></i>
                                                        Print Format SK
                                                    </a>
                                                @else
                                                    <a href="{{ route('komposisi.print-all') }}" class="btn btn-success mr-2" target="_blank">
                                                        <i class="fas fa-print mr-1"></i>
                                                        Print Semua
                                                    </a>
                                                    <a href="{{ route('komposisi.print-sk') }}" class="btn btn-primary" target="_blank">
                                                        <i class="fas fa-file-alt mr-1"></i>
                                                        Print Format SK
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Active Info -->
                    @if(request()->hasAny(['dpd_id', 'status_upa', 'jenjang_id', 'min_anggota']))
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Filter Aktif:</strong>
                                @if(request('dpd_id'))
                                    DPD: {{ $dpdList->where('dpd_id', request('dpd_id'))->first()->nama_dpd ?? 'N/A' }}
                                @endif
                                @if(request('status_upa'))
                                    | Status UPA: {{ request('status_upa') }}
                                @endif
                                @if(request('jenjang_id'))
                                    | Jenjang: {{ $jenjangList->where('ref_jenjang_id', request('jenjang_id'))->first()->jenjang ?? 'N/A' }}
                                @endif
                                @if(request('min_anggota'))
                                    | Min. Anggota: {{ request('min_anggota') }}
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Statistik Overview -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <i class="fas fa-building"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total DPC</span>
                                    <span class="info-box-number">{{ $statistik['total_dpc'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-users"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total UPA</span>
                                    <span class="info-box-number">{{ $statistik['total_upa'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-user-friends"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Anggota</span>
                                    <span class="info-box-number">{{ $statistik['total_anggota'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary">
                                    <i class="fas fa-chart-pie"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Rata-rata Anggota/DPC</span>
                                    <span class="info-box-number">{{ $statistik['total_dpc'] > 0 ? round($statistik['total_anggota'] / $statistik['total_dpc'], 1) : 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Statistik per Jenjang -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Distribusi Anggota per Jenjang</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        @foreach($statistik['statistik_jenjang'] as $jenjang)
                                        <div class="col-md-3 col-sm-6">
                                            <div class="small-box bg-light">
                                                <div class="inner">
                                                    <h3>{{ $jenjang->total }}</h3>
                                                    <p>{{ $jenjang->jenjang }}</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fas fa-graduation-cap"></i>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Daftar DPC -->
                    <div class="row">
                        @foreach($dpcList as $dpc)
                        <div class="col-lg-6 col-xl-4">
                            <div class="card card-widget widget-user-2">
                                <div class="widget-user-header bg-primary">
                                    <div class="widget-user-image">
                                        <i class="fas fa-building fa-2x"></i>
                                    </div>
                                    <h3 class="widget-user-username">{{ $dpc->nama_dpc }}</h3>
                                    <h5 class="widget-user-desc">{{ $dpc->dpd->nama_dpd ?? 'N/A' }}</h5>
                                </div>
                                <div class="card-footer p-0">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a href="#" class="nav-link">
                                                UPA Aktif
                                                <span class="float-right badge bg-primary">{{ $dpc->upa->count() }}</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a href="#" class="nav-link">
                                                Total Anggota
                                                <span class="float-right badge bg-info">{{ $dpc->anggota->where('status_keanggotaan', 'Aktif')->count() }}</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-footer">
                                    <div class="row">
                                        <div class="col-6">
                                            <a href="{{ route('komposisi.show-dpc', $dpc->dpc_id) }}" class="btn btn-primary btn-sm btn-block">
                                                <i class="fas fa-eye mr-1"></i>
                                                Detail
                                            </a>
                                        </div>
                                        <div class="col-6">
                                            <a href="{{ route('komposisi.print-dpc', $dpc->dpc_id) }}" class="btn btn-success btn-sm btn-block" target="_blank">
                                                <i class="fas fa-print mr-1"></i>
                                                Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-submit form when filter changes
    $('#filterForm select').change(function() {
        $('#filterForm').submit();
    });
    
    // Show loading state
    $('#filterForm').on('submit', function() {
        $('button[type="submit"]').prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>Memproses...');
    });
});
</script>
@endpush

@push('styles')
<style>
.widget-user-2 .widget-user-image {
    position: absolute;
    top: 15px;
    left: 15px;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
}

.widget-user-2 .widget-user-header {
    padding: 20px 20px 20px 80px;
}

.small-box {
    border-radius: 0.25rem;
    position: relative;
    display: block;
    margin-bottom: 20px;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

.small-box .inner {
    padding: 10px;
}

.small-box .inner h3 {
    font-size: 2.2rem;
    font-weight: bold;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}

.small-box .inner p {
    font-size: 1rem;
    margin: 0;
}

.small-box .icon {
    transition: all .3s linear;
    position: absolute;
    top: -10px;
    right: 10px;
    z-index: 0;
    font-size: 90px;
    color: rgba(0,0,0,0.15);
}
</style>
@endpush
