{{-- resources/views/kegiatan/show.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h4>
                        <i class="fas fa-calendar-alt"></i>
                        Detail Kegiatan - {{ $kegiatan->nama_kegiatan }}
                    </h4>
                </div>
                
                <div class="card-body">
                    {{-- Alert Messages --}}
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    {{-- Info Kegiatan --}}
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Nama Kegiatan</strong></td>
                                    <td>: {{ $kegiatan->nama_kegiatan }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Jenis</strong></td>
                                    <td>: <span class="badge bg-{{ $kegiatan->jenis_badge }}">{{ $kegiatan->jenis_kegiatan }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>: <span class="badge bg-{{ $kegiatan->status_badge }}">{{ $kegiatan->status_kegiatan }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal</strong></td>
                                    <td>: {{ $kegiatan->tanggal_kegiatan->format('d F Y') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Waktu</strong></td>
                                    <td>: {{ $kegiatan->waktu_lengkap }}</td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Tempat</strong></td>
                                    <td>: {{ $kegiatan->tempat }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Target Peserta</strong></td>
                                    <td>: {{ $kegiatan->target_peserta ?? 'Tidak ditentukan' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Partisipan</strong></td>
                                    <td>: {{ $kegiatan->getTotalPartisipan() }} orang</td>
                                </tr>
                                @if($kegiatan->status_kegiatan == 'Selesai')
                                <tr>
                                    <td><strong>Kehadiran</strong></td>
                                    <td>: {{ $kegiatan->getTotalHadir() }} hadir ({{ $kegiatan->getPersentaseKehadiran() }}%)</td>
                                </tr>
                                @endif
                                <tr>
                                    <td><strong>PIC</strong></td>
                                    <td>: {{ $kegiatan->pic->name ?? 'Belum ditentukan' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    {{-- Deskripsi --}}
                    @if($kegiatan->deskripsi)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h6><strong><i class="fas fa-align-left"></i> Deskripsi:</strong></h6>
                            <div class="bg-light p-3 rounded">
                                {{ $kegiatan->deskripsi }}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    {{-- Catatan --}}
                    @if($kegiatan->catatan)
                    <hr>
                    <div class="row">
                        <div class="col-md-12">
                            <h6><strong><i class="fas fa-sticky-note"></i> Catatan:</strong></h6>
                            <div class="bg-light p-3 rounded">
                                {{ $kegiatan->catatan }}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            
            {{-- Daftar Partisipan --}}
            @if($kegiatan->partisipan->count() > 0)
            <div class="card mt-3">
                <div class="card-header">
                    <h5><i class="fas fa-users"></i> Daftar Partisipan ({{ $kegiatan->partisipan->count() }} orang)</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead class="table-dark">
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="30%">Nama Anggota</th>
                                    <th width="15%">Jenjang</th>
                                    <th width="15%">Status Partisipasi</th>
                                    <th width="15%">Status Kehadiran</th>
                                    <th width="20%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($kegiatan->partisipan as $index => $partisipan)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <strong>{{ $partisipan->anggota->nama_lengkap }}</strong><br>
                                        <small class="text-muted">{{ $partisipan->anggota->no_telepon }}</small>
                                    </td>
                                    <td>{{ $partisipan->anggota->refJenjang->jenjang ?? $partisipan->anggota->jenjang_anggota }}</td>
                                    <td>
                                        <span class="badge bg-{{ $partisipan->status_partisipasi_badge }}">
                                            {{ $partisipan->status_partisipasi }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $partisipan->status_kehadiran_badge }}">
                                            {{ $partisipan->status_kehadiran }}
                                        </span>
                                        @if($partisipan->keterangan)
                                            <br><small class="text-muted">{{ $partisipan->keterangan }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($kegiatan->status_kegiatan != 'Dibatalkan')
                                        <button type="button" class="btn btn-sm btn-outline-primary" 
                                                data-bs-toggle="modal" data-bs-target="#kehadiranModal{{ $partisipan->id }}">
                                            <i class="fas fa-check"></i> Update
                                        </button>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>
        
        {{-- SIDEBAR AKSI --}}
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5><i class="fas fa-cogs"></i> Aksi Kegiatan</h5>
                </div>
                
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($kegiatan->canBeEdited())
                            <a href="{{ route('kegiatan.edit', $kegiatan->id) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> Edit Kegiatan
                            </a>
                        @endif
                        
                        <a href="{{ route('kegiatan.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke List
                        </a>
                    </div>
                </div>
            </div>
            
            {{-- Statistik Kehadiran --}}
            @if($kegiatan->partisipan->count() > 0)
            <div class="card mt-3">
                <div class="card-header">
                    <h6><i class="fas fa-chart-pie"></i> Statistik Kehadiran</h6>
                </div>
                <div class="card-body">
                    @php
                        $totalPartisipan = $kegiatan->getTotalPartisipan();
                        $totalHadir = $kegiatan->getTotalHadir();
                        $totalTidakHadir = $kegiatan->partisipan()->where('status_kehadiran', 'Tidak Hadir')->count();
                        $totalIzin = $kegiatan->partisipan()->where('status_kehadiran', 'Izin')->count();
                        $totalBelumKonfirmasi = $kegiatan->partisipan()->where('status_kehadiran', 'Belum Konfirmasi')->count();
                    @endphp
                    
                    <div class="mb-2">
                        <small class="text-muted">Hadir</small>
                        <div class="progress mb-1" style="height: 20px;">
                            <div class="progress-bar bg-success" style="width: {{ $totalPartisipan > 0 ? ($totalHadir / $totalPartisipan) * 100 : 0 }}%">
                                {{ $totalHadir }}
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-2">
                        <small class="text-muted">Tidak Hadir</small>
                        <div class="progress mb-1" style="height: 20px;">
                            <div class="progress-bar bg-danger" style="width: {{ $totalPartisipan > 0 ? ($totalTidakHadir / $totalPartisipan) * 100 : 0 }}%">
                                {{ $totalTidakHadir }}
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-2">
                        <small class="text-muted">Izin</small>
                        <div class="progress mb-1" style="height: 20px;">
                            <div class="progress-bar bg-warning" style="width: {{ $totalPartisipan > 0 ? ($totalIzin / $totalPartisipan) * 100 : 0 }}%">
                                {{ $totalIzin }}
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-2">
                        <small class="text-muted">Belum Konfirmasi</small>
                        <div class="progress mb-1" style="height: 20px;">
                            <div class="progress-bar bg-secondary" style="width: {{ $totalPartisipan > 0 ? ($totalBelumKonfirmasi / $totalPartisipan) * 100 : 0 }}%">
                                {{ $totalBelumKonfirmasi }}
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    <div class="text-center">
                        <strong>Persentase Kehadiran: {{ $kegiatan->getPersentaseKehadiran() }}%</strong>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

{{-- Modal Update Kehadiran --}}
@foreach($kegiatan->partisipan as $partisipan)
<div class="modal fade" id="kehadiranModal{{ $partisipan->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Kehadiran - {{ $partisipan->anggota->nama_lengkap }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('kegiatan.update-kehadiran', $partisipan->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="status_kehadiran{{ $partisipan->id }}">Status Kehadiran <span class="text-danger">*</span></label>
                        <select name="status_kehadiran" id="status_kehadiran{{ $partisipan->id }}" class="form-control" required>
                            <option value="Belum Konfirmasi" {{ $partisipan->status_kehadiran == 'Belum Konfirmasi' ? 'selected' : '' }}>Belum Konfirmasi</option>
                            <option value="Hadir" {{ $partisipan->status_kehadiran == 'Hadir' ? 'selected' : '' }}>Hadir</option>
                            <option value="Tidak Hadir" {{ $partisipan->status_kehadiran == 'Tidak Hadir' ? 'selected' : '' }}>Tidak Hadir</option>
                            <option value="Izin" {{ $partisipan->status_kehadiran == 'Izin' ? 'selected' : '' }}>Izin</option>
                        </select>
                    </div>
                    
                    <div class="form-group mb-3">
                        <label for="keterangan{{ $partisipan->id }}">Keterangan</label>
                        <textarea name="keterangan" id="keterangan{{ $partisipan->id }}" class="form-control" rows="2" 
                                  placeholder="Keterangan tambahan (opsional)">{{ $partisipan->keterangan }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Kehadiran
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
@endsection