@extends('layouts.app')

@section('title', 'Detail Keahlian')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Detail Keahlian</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('keahlian.index') }}">Master Keahlian</a></li>
                        <li class="breadcrumb-item active">Detail Keahlian</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">{{ $keahlian->nama_keahlian }}</h5>
                        <div>
                            <a href="{{ route('keahlian.edit', $keahlian) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit me-1"></i> Edit
                            </a>
                            <a href="{{ route('keahlian.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold text-muted">Nama Keahlian:</td>
                                    <td>{{ $keahlian->nama_keahlian }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Status:</td>
                                    <td>
                                        <span class="badge bg-{{ $keahlian->is_active ? 'success' : 'warning' }}">
                                            {{ $keahlian->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold text-muted">Dibuat:</td>
                                    <td>{{ $keahlian->created_at->format('d F Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Diperbarui:</td>
                                    <td>{{ $keahlian->updated_at->format('d F Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($keahlian->deskripsi)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Deskripsi</h6>
                                <p class="text-muted">{{ $keahlian->deskripsi }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
