@extends('layouts.app')

@section('title', 'Tambah Jenis Kegiatan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Tambah Jenis Kegiatan</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('jenis-kegiatan.index') }}">Master Jenis Kegiatan</a></li>
                        <li class="breadcrumb-item active">Tambah Jenis Kegiatan</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Tambah Jenis Kegiatan</h5>
                </div>

                <div class="card-body">
                    <form action="{{ route('jenis-kegiatan.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Kode Jenis Kegiatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kode_jenis_kegiatan') is-invalid @enderror" 
                                       name="kode_jenis_kegiatan" value="{{ old('kode_jenis_kegiatan') }}" 
                                       placeholder="Contoh: JK001">
                                @error('kode_jenis_kegiatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nama Jenis Kegiatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_jenis_kegiatan') is-invalid @enderror" 
                                       name="nama_jenis_kegiatan" value="{{ old('nama_jenis_kegiatan') }}" 
                                       placeholder="Nama lengkap jenis kegiatan">
                                @error('nama_jenis_kegiatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Kategori</label>
                                <select class="form-select @error('kategori') is-invalid @enderror" name="kategori">
                                    <option value="">Pilih Kategori</option>
                                    <option value="Pembinaan" {{ old('kategori') == 'Pembinaan' ? 'selected' : '' }}>Pembinaan</option>
                                    <option value="Pelatihan" {{ old('kategori') == 'Pelatihan' ? 'selected' : '' }}>Pelatihan</option>
                                    <option value="Seminar" {{ old('kategori') == 'Seminar' ? 'selected' : '' }}>Seminar</option>
                                    <option value="Workshop" {{ old('kategori') == 'Workshop' ? 'selected' : '' }}>Workshop</option>
                                    <option value="Rapat" {{ old('kategori') == 'Rapat' ? 'selected' : '' }}>Rapat</option>
                                    <option value="Konsultasi" {{ old('kategori') == 'Konsultasi' ? 'selected' : '' }}>Konsultasi</option>
                                    <option value="Lainnya" {{ old('kategori') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Durasi Standar (menit)</label>
                                <input type="number" class="form-control @error('durasi_standar') is-invalid @enderror" 
                                       name="durasi_standar" value="{{ old('durasi_standar') }}" 
                                       placeholder="Durasi dalam menit" min="0">
                                @error('durasi_standar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Deskripsi</label>
                                <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                          name="deskripsi" rows="3" 
                                          placeholder="Deskripsi singkat tentang jenis kegiatan ini">{{ old('deskripsi') }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                          name="catatan" rows="2" 
                                          placeholder="Catatan tambahan">{{ old('catatan') }}</textarea>
                                @error('catatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" 
                                           id="is_active" {{ old('is_active', true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        Aktif
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Tombol Aksi -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Simpan Jenis Kegiatan
                                    </button>
                                    <a href="{{ route('jenis-kegiatan.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Batal
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
