@extends('layouts.app')

@section('title', 'Edit Data DPC')

@section('content')
<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
</style>

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-edit text-primary me-2"></i>Edit DPC
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Edit data Dewan Pimpinan Cabang
        </p>
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('dpc.index') }}">Data DPC</a></li>
            <li class="breadcrumb-item active">Edit DPC</li>
        </ol>
    </nav>
</div>

<!-- Form Card -->
<div class="card shadow-sm border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-edit me-2"></i>Form Edit DPC
        </h6>
    </div>
    <div class="card-body p-4">
        <form action="{{ route('dpc.update', $dpc) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="row">
                <!-- Kode DPC -->
                <div class="col-md-6 mb-4">
                    <label for="kode_dpc" class="form-label fw-semibold text-dark">
                        <i class="fas fa-barcode me-1 text-primary"></i>Kode DPC 
                        <span class="text-danger">*</span>
                    </label>
                    <input type="text" 
                           class="form-control @error('kode_dpc') is-invalid @enderror" 
                           id="kode_dpc" 
                           name="kode_dpc" 
                           value="{{ old('kode_dpc', $dpc->kode_dpc) }}" 
                           placeholder="Contoh: DPC-CPY" 
                           required 
                           maxlength="10"
                           style="border-radius: 6px;">
                    @error('kode_dpc')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @else
                        <small class="text-muted">Kode unik untuk identifikasi DPC (maksimal 10 karakter)</small>
                    @enderror
                </div>

                <!-- Nama DPC -->
                <div class="col-md-6 mb-4">
                    <label for="nama_dpc" class="form-label fw-semibold text-dark">
                        <i class="fas fa-sitemap me-1 text-primary"></i>Nama DPC 
                        <span class="text-danger">*</span>
                    </label>
                    <input type="text" 
                           class="form-control @error('nama_dpc') is-invalid @enderror" 
                           id="nama_dpc" 
                           name="nama_dpc" 
                           value="{{ old('nama_dpc', $dpc->nama_dpc) }}" 
                           placeholder="Contoh: DPC Cipayung" 
                           required 
                           maxlength="100"
                           style="border-radius: 6px;">
                    @error('nama_dpc')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @else
                        <small class="text-muted">Nama lengkap DPC (maksimal 100 karakter)</small>
                    @enderror
                </div>

                <!-- DPD -->
                <div class="col-md-6 mb-4">
                    <label for="dpd_id" class="form-label fw-semibold text-dark">
                        <i class="fas fa-building me-1 text-primary"></i>DPD (Dewan Pimpinan Daerah)
                    </label>
                    <select class="form-select @error('dpd_id') is-invalid @enderror" 
                            id="dpd_id" 
                            name="dpd_id"
                            style="border-radius: 6px;">
                        <option value="">Pilih DPD</option>
                        @foreach($dpds as $dpd)
                            <option value="{{ $dpd->dpd_id }}" 
                                {{ old('dpd_id', $dpc->dpd_id) == $dpd->dpd_id ? 'selected' : '' }}>
                                {{ $dpd->nama_dpd }}
                            </option>
                        @endforeach
                    </select>
                    @error('dpd_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @else
                        <small class="text-muted">Pilih DPD yang membawahi DPC ini (opsional)</small>
                    @enderror
                </div>

                <!-- Status Aktif -->
                <div class="col-md-6 mb-4">
                    <label class="form-label fw-semibold text-dark">
                        <i class="fas fa-info-circle me-1 text-primary"></i>Status
                    </label>
                    <div class="form-check form-switch" style="padding-left: 2.5em;">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_active" 
                               name="is_active" 
                               value="1" 
                               {{ old('is_active', $dpc->is_active) ? 'checked' : '' }}
                               style="width: 3em; height: 1.5em; cursor: pointer;">
                        <label class="form-check-label fw-semibold" for="is_active" style="padding-left: 0.5em; cursor: pointer;">
                            DPC Aktif
                        </label>
                    </div>
                    <small class="text-muted">Centang jika DPC ini aktif dan dapat digunakan</small>
                </div>

                <!-- Deskripsi -->
                <div class="col-12 mb-4">
                    <label for="deskripsi" class="form-label fw-semibold text-dark">
                        <i class="fas fa-align-left me-1 text-primary"></i>Deskripsi
                    </label>
                    <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                              id="deskripsi" 
                              name="deskripsi" 
                              rows="4" 
                              placeholder="Masukkan deskripsi atau keterangan tambahan tentang DPC (opsional)"
                              style="border-radius: 6px;">{{ old('deskripsi', $dpc->deskripsi) }}</textarea>
                    @error('deskripsi')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Info Tambahan -->
                <div class="col-12 mb-4">
                    <div class="alert alert-info border-0 shadow-sm" style="border-radius: 6px;">
                        <h6 class="alert-heading fw-bold">
                            <i class="fas fa-info-circle me-2"></i>Informasi DPC
                        </h6>
                        <hr class="my-2">
                        <div class="row mt-3">
                            <div class="col-md-4 mb-2">
                                <strong><i class="fas fa-users me-1 text-primary"></i>Jumlah UPA:</strong> 
                                <span class="badge bg-primary">{{ $dpc->upa()->count() }}</span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <strong><i class="fas fa-user-friends me-1 text-primary"></i>Jumlah Anggota:</strong> 
                                <span class="badge bg-success">{{ $dpc->anggota()->count() }}</span>
                            </div>
                            <div class="col-md-4 mb-2">
                                <strong><i class="fas fa-calendar me-1 text-primary"></i>Dibuat:</strong> 
                                <span class="text-muted">{{ $dpc->created_at->format('d/m/Y H:i') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="row mt-4">
                <div class="col-12">
                    <hr class="mb-4">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary px-4" style="border-radius: 6px;">
                            <i class="fas fa-save me-1"></i>Update
                        </button>
                        <a href="{{ route('dpc.index') }}" class="btn btn-outline-secondary px-4" style="border-radius: 6px;">
                            <i class="fas fa-times me-1"></i>Batal
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
