{{-- resources/views/dashboard.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container-fluid">
    {{-- Header Dashboard --}}
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <small class="text-muted">Ringkasan data anggota Partai Keadilan Sejahtera</small>
    </div>

    {{-- Top Statistics Row --}}
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Anggota</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalAnggota }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Anggota Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalAnggota }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Kegiatan Bulan Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Mutasi Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">0</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exchange-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Jenjang Statistics --}}
    <div class="row">
        {{-- Jenjang Cards --}}
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik Jenjang Anggota</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @php
                            $colors = ['primary', 'success', 'warning', 'info', 'danger'];
                            $icons = ['star', 'award', 'medal', 'trophy', 'crown'];
                        @endphp
                        
                        @foreach($jenjangStats as $index => $jenjang)
                        <div class="col-md-4 mb-3">
                            <div class="card border-left-{{ $colors[$index % 5] }} h-100">
                                <div class="card-body py-3">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-{{ $colors[$index % 5] }} text-uppercase mb-1">
                                                {{ $jenjang->jenjang }}
                                            </div>
                                            <div class="h6 mb-0 font-weight-bold text-gray-800">
                                                {{ $jenjang->total }} orang
                                            </div>
                                            <div class="text-xs text-muted">
                                                {{ number_format(($jenjang->total / $totalAnggota) * 100, 1) }}% dari total
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-{{ $icons[$index % 5] }} fa-lg text-{{ $colors[$index % 5] }}"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        {{-- Chart atau Info Tambahan --}}
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Distribusi Jenjang</h6>
                </div>
                <div class="card-body">
                    @foreach($jenjangStats as $index => $jenjang)
                    <div class="mb-3">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <span class="text-sm font-weight-bold">{{ $jenjang->jenjang }}</span>
                            <span class="text-sm text-muted">{{ $jenjang->total }}</span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-{{ $colors[$index % 5] }}" 
                                 style="width: {{ ($jenjang->total / $totalAnggota) * 100 }}%"></div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            {{-- Quick Actions --}}
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi Cepat</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('anggota.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Tambah Anggota
                        </a>
                        <a href="{{ route('mutasi.create') }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-exchange-alt"></i> Mutasi Keluar
                        </a>
                        <a href="{{ route('penempatan.create') }}" class="btn btn-success btn-sm">
                            <i class="fas fa-users"></i> Penempatan UPA
                        </a>
                        <a href="{{ route('rekomposisi.create') }}" class="btn btn-info btn-sm">
                            <i class="fas fa-sitemap"></i> Rekomposisi UPA
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Recent Activities atau Tabel --}}
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Aktivitas Terbaru</h6>
                    <small class="text-muted">Data mutasi dan kegiatan terbaru</small>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Aktivitas</th>
                                    <th>Anggota</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- Loop recent activities here --}}
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        <i class="fas fa-info-circle"></i> Belum ada aktivitas terbaru
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}
.border-left-danger {
    border-left: 0.25rem solid #e74a3b !important;
}
</style>
@endsection