<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Check-in Kegiatan - PKS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .checkin-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .checkin-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 400px;
            width: 100%;
        }
        
        .checkin-header {
            background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        
        .checkin-header h1 {
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0;
        }
        
        .checkin-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
        }
        
        .checkin-body {
            padding: 30px 20px;
        }
        
        .kegiatan-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border-left: 4px solid #FF6B35;
        }
        
        .kegiatan-info h5 {
            color: #FF6B35;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .info-item {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
            font-size: 0.9rem;
        }
        
        .info-item i {
            width: 20px;
            color: #6c757d;
            margin-right: 10px;
        }
        
        .search-section {
            margin-bottom: 25px;
        }
        
        .search-section h6 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
            padding: 12px 15px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #FF6B35;
            box-shadow: 0 0 0 0.2rem rgba(255, 107, 53, 0.25);
        }
        
        .btn-search {
            background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 20px;
            color: white;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s ease;
        }
        
        .btn-search:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 107, 53, 0.4);
        }
        
        .search-results {
            margin-top: 20px;
        }
        
        .member-card {
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        
        .member-card:hover {
            border-color: #FF6B35;
            box-shadow: 0 5px 15px rgba(255, 107, 53, 0.1);
        }
        
        .member-info h6 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .member-info p {
            color: #6c757d;
            font-size: 0.85rem;
            margin: 0;
        }
        
        .btn-checkin {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            border: none;
            border-radius: 8px;
            padding: 8px 15px;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }
        
        .btn-checkin:hover {
            transform: translateY(-1px);
            box-shadow: 0 3px 10px rgba(40, 167, 69, 0.4);
        }
        
        .btn-checkin:disabled {
            background: #6c757d;
            cursor: not-allowed;
            transform: none;
        }
        
        .status-badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 15px;
            font-size: 0.75rem;
            font-weight: 600;
            margin-left: 10px;
        }
        
        .status-success {
            background: #d4edda;
            color: #155724;
        }
        
        .status-warning {
            background: #fff3cd;
            color: #856404;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
        }
        
        .loading {
            text-align: center;
            padding: 20px;
        }
        
        .spinner-border {
            color: #FF6B35;
        }
        
        @media (max-width: 576px) {
            .checkin-container {
                padding: 10px;
            }
            
            .checkin-header {
                padding: 20px 15px;
            }
            
            .checkin-header h1 {
                font-size: 1.3rem;
            }
            
            .checkin-body {
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <div class="checkin-container">
        <div class="checkin-card">
            <!-- Header -->
            <div class="checkin-header">
                <h1><i class="fas fa-qrcode me-2"></i>Check-in Kegiatan</h1>
                <p>Partai Keadilan Sejahtera</p>
            </div>
            
            <!-- Body -->
            <div class="checkin-body">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                <!-- Kegiatan Info -->
                <div class="kegiatan-info">
                    <h5><i class="fas fa-calendar-alt me-2"></i>Informasi Kegiatan</h5>
                    <div class="info-item">
                        <i class="fas fa-tag"></i>
                        <span><strong>Nama:</strong> {{ $kegiatan->nama_kegiatan ?? 'Kegiatan Tidak Ditemukan' }}</span>
                    </div>
                    <div class="info-item">
                        <i class="fas fa-calendar"></i>
                        <span><strong>Tanggal:</strong> {{ $kegiatan->tanggal_mulai ? \Carbon\Carbon::parse($kegiatan->tanggal_mulai)->format('d M Y') : '-' }}</span>
                    </div>
                    <div class="info-item">
                        <i class="fas fa-clock"></i>
                        <span><strong>Waktu:</strong> {{ $kegiatan->waktu_mulai ? \Carbon\Carbon::parse($kegiatan->waktu_mulai)->format('H:i') : '-' }} - {{ $kegiatan->waktu_selesai ? \Carbon\Carbon::parse($kegiatan->waktu_selesai)->format('H:i') : '-' }}</span>
                    </div>
                    <div class="info-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <span><strong>Tempat:</strong> {{ $kegiatan->tempat ?? '-' }}</span>
                    </div>
                </div>
                
                <!-- Search Section -->
                <div class="search-section">
                    <h6><i class="fas fa-search me-2"></i>Cari Anggota</h6>
                    <form id="searchForm">
                        <div class="mb-3">
                            <input type="text" 
                                   class="form-control" 
                                   id="searchInput" 
                                   placeholder="Masukkan Nama Lengkap atau NIA (PKS-XXX-XXXX)..."
                                   autocomplete="off">
                        </div>
                        <button type="submit" class="btn btn-search">
                            <i class="fas fa-search me-2"></i>Cari Anggota
                        </button>
                    </form>
                </div>
                
                <!-- Search Results -->
                <div id="searchResults" class="search-results" style="display: none;">
                    <h6><i class="fas fa-users me-2"></i>Hasil Pencarian</h6>
                    <div id="memberList"></div>
                </div>
                
                <!-- Loading -->
                <div id="loading" class="loading" style="display: none;">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2">Mencari anggota...</p>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('searchForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const searchTerm = document.getElementById('searchInput').value.trim();
            if (!searchTerm) {
                alert('Masukkan NIA atau nama anggota!');
                return;
            }
            
            // Show loading
            document.getElementById('loading').style.display = 'block';
            document.getElementById('searchResults').style.display = 'none';
            
            // AJAX search
            fetch(`{{ route('checkin.search', $kegiatan->id) }}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    search: searchTerm
                })
            })
            .then(response => response.json())
            .then(data => {
                loading.style.display = 'none';
                
                if (data.success) {
                    displaySearchResults(data.data);
                } else {
                    showError(data.message);
                }
            })
            .catch(error => {
                loading.style.display = 'none';
                showError('Terjadi kesalahan saat mencari anggota');
                console.error('Error:', error);
            });
        });
        
        function displaySearchResults(members) {
            const memberList = document.getElementById('memberList');
            const searchResults = document.getElementById('searchResults');
            const loading = document.getElementById('loading');
            
            loading.style.display = 'none';
            searchResults.style.display = 'block';
            
            if (members.length === 0) {
                memberList.innerHTML = `
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Anggota tidak ditemukan. Periksa kembali NIA atau nama yang dimasukkan.
                    </div>
                `;
                return;
            }
            
            let html = '';
            members.forEach(member => {
                html += `
                    <div class="member-card">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="member-info">
                                <h6>${member.nama}</h6>
                                <p>NIA: ${member.nia} | Jenjang: ${member.jenjang}</p>
                            </div>
                            <div>
                                <button class="btn btn-checkin" onclick="checkInMember(${member.id}, '${member.nama}')">
                                    <i class="fas fa-check me-1"></i>Check-in
                                </button>
                            </div>
                        </div>
                    </div>
                `;
            });
            
            memberList.innerHTML = html;
        }
        
        function checkInMember(memberId, memberName) {
            if (confirm(`Konfirmasi kehadiran ${memberName}?`)) {
                // Disable button
                const button = event.target;
                button.disabled = true;
                button.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Processing...';
                
                // AJAX check-in
                fetch(`{{ route('checkin.checkin', $kegiatan->id) }}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        anggota_id: memberId
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        button.innerHTML = '<i class="fas fa-check me-1"></i>Sudah Check-in';
                        button.classList.remove('btn-checkin');
                        button.classList.add('btn-secondary');
                        
                        // Show success message
                        showSuccess(data.message);
                    } else {
                        button.disabled = false;
                        button.innerHTML = '<i class="fas fa-check me-1"></i>Check-in';
                        showError(data.message);
                    }
                })
                .catch(error => {
                    button.disabled = false;
                    button.innerHTML = '<i class="fas fa-check me-1"></i>Check-in';
                    showError('Terjadi kesalahan saat check-in');
                    console.error('Error:', error);
                });
            }
        }
        
        function showSuccess(message) {
            const alert = document.createElement('div');
            alert.className = 'alert alert-success alert-dismissible fade show';
            alert.innerHTML = `
                <i class="fas fa-check-circle me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.querySelector('.checkin-body').insertBefore(alert, document.querySelector('.kegiatan-info'));
        }
        
        function showError(message) {
            const alert = document.createElement('div');
            alert.className = 'alert alert-danger alert-dismissible fade show';
            alert.innerHTML = `
                <i class="fas fa-exclamation-circle me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.querySelector('.checkin-body').insertBefore(alert, document.querySelector('.kegiatan-info'));
        }
        
        // Auto-focus search input
        document.getElementById('searchInput').focus();
    </script>
</body>
</html>
